/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import java.util.HashMap;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class WorkbenchPartLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private HashMap images = new HashMap();

    public final Image getImage(Object object) {
        if (object instanceof IWorkbenchPart) {
            return ((IWorkbenchPart)object).getTitleImage();
        }
        if (object instanceof Saveable) {
            Saveable saveable = (Saveable)object;
            ImageDescriptor imageDescriptor = saveable.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image image = (Image)this.images.get(imageDescriptor);
            if (image == null) {
                try {
                    image = this.resourceManager.createImage(imageDescriptor);
                    this.images.put(imageDescriptor, image);
                }
                catch (DeviceResourceException deviceResourceException) {
                    WorkbenchPlugin.log(((Object)((Object)this)).getClass(), "getImage", deviceResourceException);
                }
            }
            return image;
        }
        return null;
    }

    public final String getText(Object object) {
        if (object instanceof IWorkbenchPart) {
            IWorkbenchPart iWorkbenchPart = (IWorkbenchPart)object;
            String string = iWorkbenchPart.getTitleToolTip();
            if (string == null || string.trim().length() == 0) {
                return iWorkbenchPart.getTitle();
            }
            return String.valueOf(iWorkbenchPart.getTitle()) + "  [" + string + "]";
        }
        if (object instanceof Saveable) {
            Saveable saveable = (Saveable)object;
            String string = saveable.getToolTipText();
            if (string == null || string.trim().length() == 0) {
                return saveable.getName();
            }
            return String.valueOf(saveable.getName()) + "  [" + string + "]";
        }
        return null;
    }

    public final Image getColumnImage(Object object, int n) {
        return this.getImage(object);
    }

    public final String getColumnText(Object object, int n) {
        return this.getText(object);
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

