/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter3;

public class WorkbenchLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private IPropertyListener editorRegistryListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (n == 1) {
                WorkbenchLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkbenchLabelProvider.this));
            }
        }
    };
    private ResourceManager resourceManager;

    public static ILabelProvider getDecoratingWorkbenchLabelProvider() {
        return new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    public WorkbenchLabelProvider() {
        PlatformUI.getWorkbench().getEditorRegistry().addPropertyListener(this.editorRegistryListener);
    }

    protected ImageDescriptor decorateImage(ImageDescriptor imageDescriptor, Object object) {
        return imageDescriptor;
    }

    protected String decorateText(String string, Object object) {
        return string;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getEditorRegistry().removePropertyListener(this.editorRegistryListener);
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
        this.resourceManager = null;
        super.dispose();
    }

    protected final IWorkbenchAdapter getAdapter(Object object) {
        return (IWorkbenchAdapter)Util.getAdapter(object, IWorkbenchAdapter.class);
    }

    protected final IWorkbenchAdapter2 getAdapter2(Object object) {
        return (IWorkbenchAdapter2)Util.getAdapter(object, IWorkbenchAdapter2.class);
    }

    protected final IWorkbenchAdapter3 getAdapter3(Object object) {
        return (IWorkbenchAdapter3)Util.getAdapter(object, IWorkbenchAdapter3.class);
    }

    private ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public final Image getImage(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = this.getAdapter(object);
        if (iWorkbenchAdapter == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = iWorkbenchAdapter.getImageDescriptor(object);
        if (imageDescriptor == null) {
            return null;
        }
        imageDescriptor = this.decorateImage(imageDescriptor, object);
        return (Image)this.getResourceManager().get((DeviceResourceDescriptor)imageDescriptor);
    }

    public StyledString getStyledText(Object object) {
        IWorkbenchAdapter3 iWorkbenchAdapter3 = this.getAdapter3(object);
        if (iWorkbenchAdapter3 == null) {
            return new StyledString(this.getText(object));
        }
        StyledString styledString = iWorkbenchAdapter3.getStyledText(object);
        String string = this.decorateText(styledString.getString(), object);
        StyledString.Styler styler = this.getDecorationStyle(object);
        return StyledCellLabelProvider.styleDecoratedString((String)string, (StyledString.Styler)styler, (StyledString)styledString);
    }

    protected StyledString.Styler getDecorationStyle(Object object) {
        return StyledString.DECORATIONS_STYLER;
    }

    public final String getText(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = this.getAdapter(object);
        if (iWorkbenchAdapter == null) {
            return "";
        }
        String string = iWorkbenchAdapter.getLabel(object);
        return this.decorateText(string, object);
    }

    public Color getForeground(Object object) {
        return this.getColor(object, true);
    }

    public Color getBackground(Object object) {
        return this.getColor(object, false);
    }

    public Font getFont(Object object) {
        IWorkbenchAdapter2 iWorkbenchAdapter2 = this.getAdapter2(object);
        if (iWorkbenchAdapter2 == null) {
            return null;
        }
        FontData fontData = iWorkbenchAdapter2.getFont(object);
        if (fontData == null) {
            return null;
        }
        return (Font)this.getResourceManager().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)fontData));
    }

    private Color getColor(Object object, boolean bl) {
        RGB rGB;
        IWorkbenchAdapter2 iWorkbenchAdapter2 = this.getAdapter2(object);
        if (iWorkbenchAdapter2 == null) {
            return null;
        }
        RGB rGB2 = rGB = bl ? iWorkbenchAdapter2.getForeground(object) : iWorkbenchAdapter2.getBackground(object);
        if (rGB == null) {
            return null;
        }
        return (Color)this.getResourceManager().get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)rGB));
    }
}

