/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public final class PerspectiveLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private HashMap imageCache = new HashMap(5);
    private boolean markDefault;

    public PerspectiveLabelProvider() {
        this(true);
    }

    public PerspectiveLabelProvider(boolean bl) {
        this.markDefault = bl;
    }

    public final Image getImage(Object object) {
        if (object instanceof IPerspectiveDescriptor) {
            Image image;
            IPerspectiveDescriptor iPerspectiveDescriptor = (IPerspectiveDescriptor)object;
            ImageDescriptor imageDescriptor = iPerspectiveDescriptor.getImageDescriptor();
            if (imageDescriptor == null) {
                imageDescriptor = WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE");
            }
            if ((image = (Image)this.imageCache.get(imageDescriptor)) == null) {
                image = imageDescriptor.createImage();
                this.imageCache.put(imageDescriptor, image);
            }
            return image;
        }
        return null;
    }

    public final void dispose() {
        Iterator iterator = this.imageCache.values().iterator();
        while (iterator.hasNext()) {
            ((Image)iterator.next()).dispose();
        }
        this.imageCache.clear();
    }

    public final String getText(Object object) {
        if (object instanceof IPerspectiveDescriptor) {
            IPerspectiveDescriptor iPerspectiveDescriptor = (IPerspectiveDescriptor)object;
            String string = iPerspectiveDescriptor.getLabel();
            if (this.markDefault) {
                String string2 = PlatformUI.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
                if (iPerspectiveDescriptor.getId().equals(string2)) {
                    string = NLS.bind((String)WorkbenchMessages.PerspectivesPreference_defaultLabel, (Object)string);
                }
            }
            return string;
        }
        return WorkbenchMessages.PerspectiveLabelProvider_unknown;
    }

    public final Image getColumnImage(Object object, int n) {
        return this.getImage(object);
    }

    public final String getColumnText(Object object, int n) {
        return this.getText(object);
    }
}

