/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class AdaptableList
extends WorkbenchAdapter
implements IAdaptable {
    protected List children = null;

    public AdaptableList() {
        this.children = new ArrayList();
    }

    public AdaptableList(int n) {
        this.children = new ArrayList(n);
    }

    public AdaptableList(IAdaptable[] iAdaptableArray) {
        this(iAdaptableArray.length);
        int n = 0;
        while (n < iAdaptableArray.length) {
            this.children.add(iAdaptableArray[n]);
            ++n;
        }
    }

    public AdaptableList(Collection collection) {
        this(collection.size());
        this.children.addAll(collection);
    }

    public AdaptableList add(IAdaptable iAdaptable) {
        Assert.isNotNull((Object)iAdaptable);
        this.children.add(iAdaptable);
        return this;
    }

    public void remove(IAdaptable iAdaptable) {
        Assert.isNotNull((Object)iAdaptable);
        this.children.remove(iAdaptable);
    }

    public int size() {
        return this.children.size();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object object) {
        return this.children.toArray();
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public Object[] getTypedChildren(Class clazz) {
        return this.children.toArray((Object[])Array.newInstance(clazz, this.children.size()));
    }

    public String toString() {
        return this.children.toString();
    }
}

