/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.menus;

import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.menus.CommandMessages;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class CommandContributionItem
extends ContributionItem {
    public static final int STYLE_PUSH = 8;
    public static final int STYLE_CHECK = 32;
    public static final int STYLE_RADIO = 16;
    public static final int STYLE_PULLDOWN = 4;
    public static int MODE_FORCE_TEXT = 1;
    private LocalResourceManager localResourceManager;
    private Listener menuItemListener;
    private Widget widget;
    private IMenuService menuService;
    private ICommandService commandService;
    private IHandlerService handlerService;
    private IBindingService bindingService;
    private ParameterizedCommand command;
    private ImageDescriptor icon;
    private String label;
    private String tooltip;
    private ImageDescriptor disabledIcon;
    private ImageDescriptor hoverIcon;
    private String mnemonic;
    private IElementReference elementRef;
    private boolean checkedState;
    private int style;
    private ICommandListener commandListener;
    private String dropDownMenuOverride;
    private IWorkbenchHelpSystem workbenchHelpSystem;
    private String helpContextId;
    private int mode = 0;
    private boolean visibleEnabled;
    private Display display;
    private String contributedLabel;
    private ImageDescriptor contributedIcon;
    private ImageDescriptor contributedDisabledIcon;
    private ImageDescriptor contributedHoverIcon;
    private IServiceLocator serviceLocator;
    private IBindingManagerListener bindingManagerListener = new IBindingManagerListener(){

        public void bindingManagerChanged(BindingManagerEvent bindingManagerEvent) {
            if (bindingManagerEvent.isActiveBindingsChanged() && bindingManagerEvent.isActiveBindingsChangedFor(CommandContributionItem.this.getCommand())) {
                CommandContributionItem.this.update();
            }
        }
    };

    public CommandContributionItem(CommandContributionItemParameter commandContributionItemParameter) {
        super(commandContributionItemParameter.id);
        this.contributedLabel = commandContributionItemParameter.label;
        this.contributedIcon = commandContributionItemParameter.icon;
        this.contributedDisabledIcon = commandContributionItemParameter.disabledIcon;
        this.contributedHoverIcon = commandContributionItemParameter.hoverIcon;
        this.icon = commandContributionItemParameter.icon;
        this.disabledIcon = commandContributionItemParameter.disabledIcon;
        this.hoverIcon = commandContributionItemParameter.hoverIcon;
        this.label = commandContributionItemParameter.label;
        this.mnemonic = commandContributionItemParameter.mnemonic;
        this.tooltip = commandContributionItemParameter.tooltip;
        this.style = commandContributionItemParameter.style;
        this.helpContextId = commandContributionItemParameter.helpContextId;
        this.visibleEnabled = commandContributionItemParameter.visibleEnabled;
        this.mode = commandContributionItemParameter.mode;
        this.serviceLocator = commandContributionItemParameter.serviceLocator;
        this.menuService = (IMenuService)this.serviceLocator.getService(IMenuService.class);
        this.commandService = (ICommandService)this.serviceLocator.getService(ICommandService.class);
        this.handlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        this.bindingService = (IBindingService)this.serviceLocator.getService(IBindingService.class);
        IWorkbenchLocationService iWorkbenchLocationService = (IWorkbenchLocationService)commandContributionItemParameter.serviceLocator.getService(IWorkbenchLocationService.class);
        this.display = iWorkbenchLocationService.getWorkbench().getDisplay();
        this.createCommand(commandContributionItemParameter.commandId, commandContributionItemParameter.parameters);
        if (this.command != null) {
            try {
                IWorkbenchLocationService iWorkbenchLocationService2;
                IWorkbench iWorkbench;
                UIElement uIElement = new UIElement(commandContributionItemParameter.serviceLocator){

                    @Override
                    public void setChecked(boolean bl) {
                        CommandContributionItem.this.setChecked(bl);
                    }

                    @Override
                    public void setDisabledIcon(ImageDescriptor imageDescriptor) {
                        CommandContributionItem.this.setDisabledIcon(imageDescriptor);
                    }

                    @Override
                    public void setHoverIcon(ImageDescriptor imageDescriptor) {
                        CommandContributionItem.this.setHoverIcon(imageDescriptor);
                    }

                    @Override
                    public void setIcon(ImageDescriptor imageDescriptor) {
                        CommandContributionItem.this.setIcon(imageDescriptor);
                    }

                    @Override
                    public void setText(String string) {
                        CommandContributionItem.this.setText(string);
                    }

                    @Override
                    public void setTooltip(String string) {
                        CommandContributionItem.this.setTooltip(string);
                    }

                    @Override
                    public void setDropDownId(String string) {
                        CommandContributionItem.this.dropDownMenuOverride = string;
                    }
                };
                this.elementRef = this.commandService.registerElementForCommand(this.command, uIElement);
                this.command.getCommand().addCommandListener(this.getCommandListener());
                this.setImages(commandContributionItemParameter.serviceLocator, commandContributionItemParameter.iconStyle);
                if (commandContributionItemParameter.helpContextId == null) {
                    try {
                        this.helpContextId = this.commandService.getHelpContextId(commandContributionItemParameter.commandId);
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                if ((iWorkbench = (iWorkbenchLocationService2 = (IWorkbenchLocationService)this.serviceLocator.getService(IWorkbenchLocationService.class)).getWorkbench()) != null && this.helpContextId != null) {
                    this.workbenchHelpSystem = iWorkbench.getHelpSystem();
                }
            }
            catch (NotDefinedException notDefinedException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, "Unable to register menu item \"" + this.getId() + "\", command \"" + commandContributionItemParameter.commandId + "\" not defined", null));
            }
        }
    }

    public CommandContributionItem(IServiceLocator iServiceLocator, String string, String string2, Map map, ImageDescriptor imageDescriptor, ImageDescriptor imageDescriptor2, ImageDescriptor imageDescriptor3, String string3, String string4, String string5, int n) {
        this(new CommandContributionItemParameter(iServiceLocator, string, string2, map, imageDescriptor, imageDescriptor2, imageDescriptor3, string3, string4, string5, n, null, false));
    }

    private void setImages(IServiceLocator iServiceLocator, String string) {
        if (this.icon == null) {
            ICommandImageService iCommandImageService = (ICommandImageService)iServiceLocator.getService(ICommandImageService.class);
            this.icon = iCommandImageService.getImageDescriptor(this.command.getId(), 0, string);
            this.disabledIcon = iCommandImageService.getImageDescriptor(this.command.getId(), 1, string);
            this.hoverIcon = iCommandImageService.getImageDescriptor(this.command.getId(), 2, string);
            if (this.contributedIcon == null) {
                this.contributedIcon = this.icon;
            }
            if (this.contributedDisabledIcon == null) {
                this.contributedDisabledIcon = this.disabledIcon;
            }
            if (this.contributedHoverIcon == null) {
                this.contributedHoverIcon = this.hoverIcon;
            }
        }
    }

    private ICommandListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new ICommandListener(){

                public void commandChanged(CommandEvent commandEvent) {
                    if (commandEvent.isHandledChanged() || commandEvent.isEnabledChanged() || commandEvent.isDefinedChanged()) {
                        CommandContributionItem.this.updateCommandProperties(commandEvent);
                    }
                }
            };
        }
        return this.commandListener;
    }

    private void updateCommandProperties(final CommandEvent commandEvent) {
        if (commandEvent.isHandledChanged()) {
            this.dropDownMenuOverride = null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (commandEvent.isEnabledChanged() || commandEvent.isHandledChanged()) {
                    IContributionManager iContributionManager;
                    if (CommandContributionItem.this.visibleEnabled && (iContributionManager = CommandContributionItem.this.getParent()) != null) {
                        iContributionManager.update(true);
                    }
                    if (CommandContributionItem.this.shouldRestoreAppearance((IHandler)(iContributionManager = commandEvent.getCommand().getHandler()))) {
                        CommandContributionItem.this.label = CommandContributionItem.this.contributedLabel;
                        CommandContributionItem.this.icon = CommandContributionItem.this.contributedIcon;
                        CommandContributionItem.this.disabledIcon = CommandContributionItem.this.contributedDisabledIcon;
                        CommandContributionItem.this.hoverIcon = CommandContributionItem.this.contributedHoverIcon;
                    }
                }
                if (commandEvent.getCommand().isDefined()) {
                    CommandContributionItem.this.update(null);
                }
            }
        };
        if (this.display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            this.display.asyncExec(runnable);
        }
    }

    private boolean shouldRestoreAppearance(IHandler iHandler) {
        if (iHandler == null) {
            return true;
        }
        if (!(iHandler instanceof IElementUpdater)) {
            return true;
        }
        if (iHandler instanceof HandlerProxy) {
            HandlerProxy handlerProxy = (HandlerProxy)iHandler;
            IHandler iHandler2 = handlerProxy.getHandler();
            return this.shouldRestoreAppearance(iHandler2);
        }
        return false;
    }

    public ParameterizedCommand getCommand() {
        return this.command;
    }

    void createCommand(String string, Map map) {
        if (string == null) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, "Unable to create menu item \"" + this.getId() + "\", no command id", null));
            return;
        }
        Command command = this.commandService.getCommand(string);
        if (!command.isDefined()) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, "Unable to create menu item \"" + this.getId() + "\", command \"" + string + "\" not defined", null));
            return;
        }
        this.command = ParameterizedCommand.generateCommand((Command)command, (Map)map);
    }

    public void fill(Menu menu, int n) {
        if (this.command == null) {
            return;
        }
        if (this.widget != null || menu == null) {
            return;
        }
        int n2 = this.style;
        if (n2 == 4) {
            n2 = 8;
        }
        MenuItem menuItem = null;
        menuItem = n >= 0 ? new MenuItem(menu, n2, n) : new MenuItem(menu, n2);
        menuItem.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp(menuItem, this.helpContextId);
        }
        menuItem.addListener(12, this.getItemListener());
        menuItem.addListener(13, this.getItemListener());
        this.widget = menuItem;
        this.update(null);
        this.updateIcons();
        this.bindingService.addBindingManagerListener(this.bindingManagerListener);
    }

    public void fill(Composite composite) {
        if (this.command == null) {
            return;
        }
        if (this.widget != null || composite == null) {
            return;
        }
        int n = this.style;
        if (n == 4) {
            n = 8;
        }
        Button button = new Button(composite, n);
        button.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp((Control)button, this.helpContextId);
        }
        button.addListener(12, this.getItemListener());
        button.addListener(13, this.getItemListener());
        this.widget = button;
        this.update(null);
        this.updateIcons();
        this.bindingService.addBindingManagerListener(this.bindingManagerListener);
    }

    public void fill(ToolBar toolBar, int n) {
        if (this.command == null) {
            return;
        }
        if (this.widget != null || toolBar == null) {
            return;
        }
        ToolItem toolItem = null;
        toolItem = n >= 0 ? new ToolItem(toolBar, this.style, n) : new ToolItem(toolBar, this.style);
        toolItem.setData((Object)this);
        toolItem.addListener(13, this.getItemListener());
        toolItem.addListener(12, this.getItemListener());
        this.widget = toolItem;
        this.update(null);
        this.updateIcons();
        this.bindingService.addBindingManagerListener(this.bindingManagerListener);
    }

    public void update() {
        this.update(null);
    }

    public void update(String string) {
        if (this.widget != null) {
            if (this.widget instanceof MenuItem) {
                this.updateMenuItem();
            } else if (this.widget instanceof ToolItem) {
                this.updateToolItem();
            } else if (this.widget instanceof Button) {
                this.updateButton();
            }
        }
    }

    private void updateMenuItem() {
        TriggerSequence triggerSequence;
        MenuItem menuItem = (MenuItem)this.widget;
        String string = this.label;
        if (string == null && this.command != null) {
            try {
                string = this.command.getCommand().getName();
            }
            catch (NotDefinedException notDefinedException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, "Update item failed " + this.getId(), (Throwable)notDefinedException));
            }
        }
        string = this.updateMnemonic(string);
        String string2 = null;
        if (this.command != null && (triggerSequence = this.bindingService.getBestActiveBindingFor(this.command)) != null) {
            string2 = triggerSequence.format();
        }
        if (string != null) {
            if (string2 == null) {
                menuItem.setText(string);
            } else {
                menuItem.setText(String.valueOf(string) + '\t' + string2);
            }
        }
        if (menuItem.getSelection() != this.checkedState) {
            menuItem.setSelection(this.checkedState);
        }
        boolean bl = this.isEnabled();
        if (!menuItem.isDisposed() && menuItem.getEnabled() != bl) {
            menuItem.setEnabled(bl);
        }
    }

    private void updateToolItem() {
        ToolItem toolItem = (ToolItem)this.widget;
        String string = this.label;
        String string2 = this.label;
        if (string == null && this.command != null) {
            try {
                string = this.command.getCommand().getName();
                string2 = this.command.getCommand().getDescription();
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = string;
                }
            }
            catch (NotDefinedException notDefinedException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, "Update item failed " + this.getId(), (Throwable)notDefinedException));
            }
        }
        if ((this.icon == null || (this.mode & MODE_FORCE_TEXT) == MODE_FORCE_TEXT) && string != null) {
            toolItem.setText(string);
        }
        String string3 = this.getToolTipText(string2);
        toolItem.setToolTipText(string3);
        if (toolItem.getSelection() != this.checkedState) {
            toolItem.setSelection(this.checkedState);
        }
        boolean bl = this.isEnabled();
        if (!toolItem.isDisposed() && toolItem.getEnabled() != bl) {
            toolItem.setEnabled(bl);
        }
    }

    private void updateButton() {
        Button button = (Button)this.widget;
        String string = this.label;
        if (string == null && this.command != null) {
            try {
                string = this.command.getCommand().getName();
            }
            catch (NotDefinedException notDefinedException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, "Update item failed " + this.getId(), (Throwable)notDefinedException));
            }
        }
        if (string != null) {
            button.setText(string);
        }
        String string2 = this.getToolTipText(string);
        button.setToolTipText(string2);
        if (button.getSelection() != this.checkedState) {
            button.setSelection(this.checkedState);
        }
        boolean bl = this.isEnabled();
        if (!button.isDisposed() && button.getEnabled() != bl) {
            button.setEnabled(bl);
        }
    }

    private String getToolTipText(String string) {
        String string2;
        TriggerSequence triggerSequence;
        String string3 = this.tooltip;
        if (this.tooltip == null) {
            string3 = string != null ? string : "";
        }
        if ((triggerSequence = this.bindingService.getBestActiveBindingFor(this.command)) != null && !triggerSequence.isEmpty() && (string2 = triggerSequence.format()) != null && string2.length() != 0) {
            string3 = NLS.bind((String)CommandMessages.Tooltip_Accelerator, (Object)string3, (Object)string2);
        }
        return string3;
    }

    private String updateMnemonic(String string) {
        if (this.mnemonic == null || string == null) {
            return string;
        }
        int n = string.indexOf(this.mnemonic);
        if (n == -1) {
            return string;
        }
        return String.valueOf(string.substring(0, n)) + '&' + string.substring(n);
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget = null;
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        if (this.elementRef != null) {
            this.commandService.unregisterElement(this.elementRef);
            this.elementRef = null;
        }
        if (this.commandListener != null) {
            this.command.getCommand().removeCommandListener(this.commandListener);
            this.commandListener = null;
        }
        if (this.bindingService != null) {
            this.bindingService.removeBindingManagerListener(this.bindingManagerListener);
        }
        this.command = null;
        this.commandService = null;
        this.bindingService = null;
        this.menuService = null;
        this.handlerService = null;
        this.disposeOldImages();
        super.dispose();
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            CommandContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            if (event.widget == null) break;
                            CommandContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetSelection(Event event) {
        if (this.openDropDownMenu(event)) {
            return;
        }
        if ((this.style & 0x22) != 0) {
            if (event.widget instanceof ToolItem) {
                this.checkedState = ((ToolItem)event.widget).getSelection();
            } else if (event.widget instanceof MenuItem) {
                this.checkedState = ((MenuItem)event.widget).getSelection();
            }
        }
        try {
            this.handlerService.executeCommand(this.command, event);
        }
        catch (ExecutionException executionException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, "Failed to execute item " + this.getId(), (Throwable)executionException));
        }
        catch (NotDefinedException notDefinedException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, "Failed to execute item " + this.getId(), (Throwable)notDefinedException));
        }
        catch (NotEnabledException notEnabledException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, "Failed to execute item " + this.getId(), (Throwable)notEnabledException));
        }
        catch (NotHandledException notHandledException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, "Failed to execute item " + this.getId(), (Throwable)notHandledException));
        }
    }

    private boolean openDropDownMenu(Event event) {
        int n;
        Widget widget = event.widget;
        if (widget != null && ((n = widget.getStyle()) & 4) != 0 && event.detail == 4) {
            ToolItem toolItem = (ToolItem)widget;
            final MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu((Control)toolItem.getParent());
            if (this.workbenchHelpSystem != null) {
                this.workbenchHelpSystem.setHelp(menu, this.helpContextId);
            }
            menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    String string = CommandContributionItem.this.getId();
                    if (CommandContributionItem.this.dropDownMenuOverride != null) {
                        string = CommandContributionItem.this.dropDownMenuOverride;
                    }
                    CommandContributionItem.this.menuService.populateContributionManager((ContributionManager)menuManager, "menu:" + string);
                }

                public void menuAboutToHide(IMenuManager iMenuManager) {
                    CommandContributionItem.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CommandContributionItem.this.menuService.releaseContributions((ContributionManager)menuManager);
                            menuManager.dispose();
                        }
                    });
                }
            });
            Point point = toolItem.getParent().toDisplay(new Point(event.x, event.y));
            menu.setLocation(point.x, point.y);
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    private void setIcon(ImageDescriptor imageDescriptor) {
        this.icon = imageDescriptor;
        this.updateIcons();
    }

    private void updateIcons() {
        if (this.widget instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)this.widget;
            LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources());
            try {
                menuItem.setImage(this.icon == null ? null : localResourceManager.createImage(this.icon));
            }
            catch (DeviceResourceException deviceResourceException) {
                this.icon = ImageDescriptor.getMissingImageDescriptor();
                menuItem.setImage(localResourceManager.createImage(this.icon));
                StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, "Failed to load image", (Throwable)deviceResourceException));
            }
            this.disposeOldImages();
            this.localResourceManager = localResourceManager;
        } else if (this.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)this.widget;
            LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources());
            toolItem.setDisabledImage(this.disabledIcon == null ? null : localResourceManager.createImage(this.disabledIcon));
            toolItem.setHotImage(this.hoverIcon == null ? null : localResourceManager.createImage(this.hoverIcon));
            toolItem.setImage(this.icon == null ? null : localResourceManager.createImage(this.icon));
            this.disposeOldImages();
            this.localResourceManager = localResourceManager;
        }
    }

    private void setText(String string) {
        this.label = string;
        this.update(null);
    }

    private void setChecked(boolean bl) {
        if (this.checkedState == bl) {
            return;
        }
        this.checkedState = bl;
        if (this.widget instanceof MenuItem) {
            ((MenuItem)this.widget).setSelection(this.checkedState);
        } else if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setSelection(this.checkedState);
        }
    }

    private void setTooltip(String string) {
        this.tooltip = string;
        if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setToolTipText(string);
        }
    }

    private void setDisabledIcon(ImageDescriptor imageDescriptor) {
        this.disabledIcon = imageDescriptor;
        this.updateIcons();
    }

    private void setHoverIcon(ImageDescriptor imageDescriptor) {
        this.hoverIcon = imageDescriptor;
        this.updateIcons();
    }

    public boolean isEnabled() {
        if (this.command != null) {
            this.command.getCommand().setEnabled((Object)this.menuService.getCurrentState());
            return this.command.getCommand().isEnabled();
        }
        return false;
    }

    public boolean isVisible() {
        if (this.visibleEnabled) {
            return super.isVisible() && this.isEnabled();
        }
        return super.isVisible();
    }

    public CommandContributionItemParameter getData() {
        CommandContributionItemParameter commandContributionItemParameter = new CommandContributionItemParameter(this.serviceLocator, this.getId(), null, this.style);
        commandContributionItemParameter.icon = this.contributedIcon;
        commandContributionItemParameter.disabledIcon = this.contributedDisabledIcon;
        commandContributionItemParameter.hoverIcon = this.contributedHoverIcon;
        commandContributionItemParameter.label = this.contributedLabel;
        commandContributionItemParameter.helpContextId = this.helpContextId;
        commandContributionItemParameter.mnemonic = this.mnemonic;
        commandContributionItemParameter.tooltip = this.tooltip;
        return commandContributionItemParameter;
    }
}

