/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.preferences.PreferenceTransferManager;
import org.eclipse.ui.internal.wizards.preferences.PreferencesContentProvider;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class WizardPreferencesPage
extends WizardPage
implements Listener,
IOverwriteQuery {
    protected Combo destinationNameField;
    private Button destinationBrowseButton;
    private Button overwriteExistingFilesCheckbox;
    protected FilteredTree transfersTree;
    protected Text descText;
    private Composite buttonComposite;
    private Button transferAllButton;
    private Group group;
    private CheckboxTreeViewer viewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardPreferencesExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardPreferencesExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String TRANSFER_ALL_PREFERENCES_ID = "WizardPreferencesExportPage1.EXPORT_ALL_PREFERENCES_ID";
    private static final String TRANSFER_PREFERENCES_NAMES_ID = "WizardPreferencesExportPage1.TRANSFER_PREFERENCES_NAMES_ID";
    private PreferenceTransferElement[] transfers;
    private String currentMessage;
    private static final String STORE_DESTINATION_ID = null;
    protected static final int COMBO_HISTORY_LENGTH = 5;

    protected WizardPreferencesPage(String string) {
        super(string);
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        this.setButtonLayoutData(button);
        button.setData((Object)new Integer(n));
        button.setText(string);
        if (bl) {
            Shell shell = composite.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected void addDestinationItem(String string) {
        this.destinationNameField.add(string);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        this.createTransferArea(composite2);
        this.setPreferenceTransfers();
        this.restoreWidgetValues();
        if (!(this.validDestination() && this.validateOptionsGroup() && this.validateSourceGroup())) {
            this.setPageComplete(false);
        }
        this.setControl((Control)composite2);
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite2);
    }

    protected abstract void createTransferArea(Composite var1);

    protected boolean validateDestinationGroup() {
        if (!this.validDestination()) {
            this.currentMessage = this.getInvalidDestinationMessage();
            return false;
        }
        return true;
    }

    protected abstract String getInvalidDestinationMessage();

    private String getNoOptionsMessage() {
        return PreferencesMessages.WizardPreferencesPage_noOptionsSelected;
    }

    protected boolean validDestination() {
        File file = new File(this.getDestinationValue());
        return file.getPath().length() > 0 && !file.isDirectory();
    }

    protected void setPreferenceTransfers() {
        PreferenceTransferElement[] preferenceTransferElementArray = this.getTransfers();
        this.viewer.setInput((Object)preferenceTransferElementArray);
    }

    protected PreferenceTransferElement[] getTransfers() {
        if (this.transfers == null) {
            this.transfers = PreferenceTransferManager.getPreferenceTransfers();
        }
        return this.transfers;
    }

    protected void createTransfersList(Composite composite) {
        this.transferAllButton = new Button(composite, 32);
        this.transferAllButton.setText(this.getAllButtonText());
        this.group = new Group(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 21;
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            gridData.horizontalIndent -= ((GridLayout)layout).marginWidth;
            gridData.horizontalIndent -= ((GridLayout)layout).marginLeft;
        }
        this.group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        this.group.setLayout((Layout)gridLayout);
        this.transfersTree = this.createFilteredTree(this.group);
        this.transfersTree.setLayoutData(new GridData(1808));
        this.viewer = (CheckboxTreeViewer)this.transfersTree.getViewer();
        this.viewer.setContentProvider((IContentProvider)new PreferencesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        Label label = new Label((Composite)this.group, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(PreferencesMessages.WizardPreferences_description);
        this.descText = new Text((Composite)this.group, 2632);
        GridData gridData2 = new GridData(1808);
        gridData2.heightHint = this.convertHeightInCharsToPixels(3);
        this.descText.setLayoutData((Object)gridData2);
        this.transferAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (WizardPreferencesPage.this.transferAllButton.getSelection()) {
                    WizardPreferencesPage.this.viewer.setAllChecked(false);
                }
                WizardPreferencesPage.this.updateEnablement();
                WizardPreferencesPage.this.updatePageCompletion();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                WizardPreferencesPage.this.updateDescription();
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                WizardPreferencesPage.this.transferAllButton.setSelection(false);
                WizardPreferencesPage.this.updateEnablement();
                WizardPreferencesPage.this.updatePageCompletion();
            }
        });
        this.addSelectionButtons((Composite)this.group);
    }

    protected void updateDescription() {
        Object object;
        ISelection iSelection = this.viewer.getSelection();
        String string = "";
        if (!iSelection.isEmpty() && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof PreferenceTransferElement) {
            string = ((PreferenceTransferElement)object).getDescription();
        }
        this.descText.setText(string);
    }

    private FilteredTree createFilteredTree(Group group) {
        int n = 2820;
        FilteredTree filteredTree = new FilteredTree((Composite)group, n, new PatternFilter(), true){

            @Override
            protected TreeViewer doCreateTreeViewer(Composite composite, int n) {
                return new CheckboxTreeViewer(composite, n);
            }
        };
        return filteredTree;
    }

    protected abstract String getChooseButtonText();

    protected abstract String getAllButtonText();

    private void addSelectionButtons(Composite composite) {
        Font font = composite.getFont();
        this.buttonComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(512);
        gridData.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setFont(font);
        this.selectAllButton = new Button(this.buttonComposite, 8);
        this.selectAllButton.setText(PreferencesMessages.SelectionDialog_selectLabel);
        this.selectAllButton.setData((Object)new Integer(18));
        this.setButtonLayoutData(this.selectAllButton);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardPreferencesPage.this.viewer.setAllChecked(true);
                WizardPreferencesPage.this.updatePageCompletion();
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.selectAllButton.setFont(font);
        this.deselectAllButton = new Button(this.buttonComposite, 8);
        this.deselectAllButton.setText(PreferencesMessages.SelectionDialog_deselectLabel);
        this.deselectAllButton.setData((Object)new Integer(19));
        this.setButtonLayoutData(this.deselectAllButton);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardPreferencesPage.this.viewer.setAllChecked(false);
                WizardPreferencesPage.this.updatePageCompletion();
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.deselectAllButton.setFont(font);
    }

    protected void setAllChecked(boolean bl) {
        this.transferAllButton.setSelection(false);
    }

    protected void createDestinationGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        Label label = new Label(composite2, 0);
        label.setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(composite2, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData gridData = new GridData(768);
        this.destinationNameField.setLayoutData((Object)gridData);
        this.destinationBrowseButton = new Button(composite2, 8);
        this.destinationBrowseButton.setText(PreferencesMessages.PreferencesExport_browse);
        this.setButtonLayoutData(this.destinationBrowseButton);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        new Label(composite, 0);
    }

    protected void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.overwriteExistingFilesCheckbox = new Button(composite2, 16416);
        this.overwriteExistingFilesCheckbox.setText(PreferencesMessages.ExportFile_overwriteExisting);
    }

    protected boolean ensureDirectoryExists(File file) {
        if (!file.exists()) {
            if (!this.queryYesNoQuestion(PreferencesMessages.PreferencesExport_createTargetDirectory)) {
                return false;
            }
            if (!file.mkdirs()) {
                MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)PreferencesMessages.PreferencesExport_error, (String)PreferencesMessages.PreferencesExport_directoryCreationError, (int)0x10000000);
                return false;
            }
        }
        return true;
    }

    protected boolean queryYesNoQuestion(String string) {
        MessageDialog messageDialog = new MessageDialog(this.getContainer().getShell(), PreferencesMessages.Question, null, string, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return messageDialog.open() == 0;
    }

    protected boolean ensureTargetIsValid(File file) {
        File file2;
        if (file.exists()) {
            String string;
            if (!this.getOverwriteExisting() && !this.queryYesNoQuestion(string = NLS.bind((String)PreferencesMessages.WizardPreferencesExportPage1_overwrite, (Object)file.getAbsolutePath()))) {
                return false;
            }
            file.delete();
        } else if (!file.isDirectory() && (file2 = file.getParentFile()) != null) {
            file.getParentFile().mkdirs();
        }
        return true;
    }

    protected void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES_ID);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            stringArray = this.addToHistory(stringArray, this.getDestinationValue());
            iDialogSettings.put(STORE_DESTINATION_NAMES_ID, stringArray);
            String string = this.getDestinationValue();
            if (string != null && !string.equals("")) {
                iDialogSettings.put(STORE_DESTINATION_ID, string);
            }
            if (this.overwriteExistingFilesCheckbox != null) {
                iDialogSettings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
            }
            if (this.shouldSaveTransferAll()) {
                boolean bl = this.getTransferAll();
                iDialogSettings.put(TRANSFER_ALL_PREFERENCES_ID, bl);
                if (!bl) {
                    Object[] objectArray = this.viewer.getCheckedElements();
                    String[] stringArray2 = new String[objectArray.length];
                    int n = 0;
                    while (n < objectArray.length) {
                        PreferenceTransferElement preferenceTransferElement = (PreferenceTransferElement)objectArray[n];
                        stringArray2[n] = preferenceTransferElement.getID();
                        ++n;
                    }
                    iDialogSettings.put(TRANSFER_PREFERENCES_NAMES_ID, stringArray2);
                }
            }
        }
    }

    public boolean finish() {
        this.saveWidgetValues();
        IPreferenceFilter[] iPreferenceFilterArray = null;
        iPreferenceFilterArray = this.getTransferAll() ? new IPreferenceFilter[]{new IPreferenceFilter(){

            public String[] getScopes() {
                return new String[]{"instance", "configuration"};
            }

            public Map getMapping(String string) {
                return null;
            }
        }} : this.getFilters();
        boolean bl = this.transfer(iPreferenceFilterArray);
        if (bl) {
            this.saveWidgetValues();
        }
        return bl;
    }

    protected IPreferenceFilter[] getFilters() {
        IPreferenceFilter[] iPreferenceFilterArray = null;
        PreferenceTransferElement[] preferenceTransferElementArray = this.getPreferenceTransferElements();
        if (preferenceTransferElementArray != null) {
            iPreferenceFilterArray = new IPreferenceFilter[preferenceTransferElementArray.length];
            int n = 0;
            while (n < preferenceTransferElementArray.length) {
                PreferenceTransferElement preferenceTransferElement = preferenceTransferElementArray[n];
                try {
                    iPreferenceFilterArray[n] = preferenceTransferElement.getFilter();
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log(coreException.getMessage(), coreException);
                }
                ++n;
            }
        } else {
            iPreferenceFilterArray = new IPreferenceFilter[]{};
        }
        return iPreferenceFilterArray;
    }

    protected PreferenceTransferElement[] getPreferenceTransferElements() {
        Object[] objectArray = this.viewer.getCheckedElements();
        PreferenceTransferElement[] preferenceTransferElementArray = new PreferenceTransferElement[objectArray.length];
        System.arraycopy(objectArray, 0, preferenceTransferElementArray, 0, objectArray.length);
        return preferenceTransferElementArray;
    }

    protected abstract boolean transfer(IPreferenceFilter[] var1);

    public void setPageComplete() {
        boolean bl = true;
        if (!this.determinePageCompletion()) {
            bl = false;
        }
        super.setPageComplete(bl);
    }

    protected boolean determinePageCompletion() {
        boolean bl;
        boolean bl2 = bl = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (bl) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return bl;
    }

    protected boolean validateOptionsGroup() {
        Object[] objectArray;
        boolean bl = true;
        if (!(this.getTransferAll() || (objectArray = this.viewer.getCheckedElements()) != null && objectArray.length != 0)) {
            this.currentMessage = this.getNoOptionsMessage();
            bl = false;
        }
        return bl;
    }

    protected boolean validateSourceGroup() {
        return true;
    }

    protected abstract String getDestinationLabel();

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog fileDialog = new FileDialog(this.getContainer().getShell(), this.getFileDialogStyle());
        fileDialog.setText(this.getFileDialogTitle());
        fileDialog.setFilterPath(this.getDestinationValue());
        fileDialog.setFilterExtensions(new String[]{"*.epf", "*.*"});
        String string = fileDialog.open();
        if (string != null) {
            this.setDestinationValue(string);
        }
    }

    protected abstract String getFileDialogTitle();

    protected abstract int getFileDialogStyle();

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void updatePageCompletion() {
        boolean bl = this.determinePageCompletion();
        this.setPageComplete(bl);
        if (bl) {
            this.setMessage(null);
        }
    }

    protected String[] addToHistory(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        this.addToHistory(arrayList, string);
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    protected void addToHistory(List list, String string) {
        list.remove(string);
        list.add(0, string);
        if (list.size() > 5) {
            list.remove(5);
        }
    }

    protected void restoreWidgetValues() {
        String[] stringArray;
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (this.shouldSaveTransferAll() && iDialogSettings != null) {
            String[] stringArray2;
            boolean bl = iDialogSettings.get(TRANSFER_ALL_PREFERENCES_ID) == null ? true : iDialogSettings.getBoolean(TRANSFER_ALL_PREFERENCES_ID);
            this.transferAllButton.setSelection(bl);
            if (!bl && (stringArray2 = iDialogSettings.getArray(TRANSFER_PREFERENCES_NAMES_ID)) != null) {
                PreferenceTransferElement[] preferenceTransferElementArray = this.getTransfers();
                int n = 0;
                while (n < preferenceTransferElementArray.length) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (preferenceTransferElementArray[n].getID().equals(stringArray2[n2])) {
                            this.viewer.setChecked((Object)preferenceTransferElementArray[n], true);
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        } else {
            this.transferAllButton.setSelection(true);
        }
        this.updateEnablement();
        if (iDialogSettings != null && (stringArray = iDialogSettings.getArray(STORE_DESTINATION_NAMES_ID)) != null) {
            this.setDestinationValue(stringArray[0]);
            int n = 0;
            while (n < stringArray.length) {
                this.addDestinationItem(stringArray[n]);
                ++n;
            }
            String string = iDialogSettings.get(STORE_DESTINATION_ID);
            if (string != null) {
                this.setDestinationValue(string);
            }
            if (this.overwriteExistingFilesCheckbox != null) {
                this.overwriteExistingFilesCheckbox.setSelection(iDialogSettings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
            }
        }
    }

    protected abstract boolean shouldSaveTransferAll();

    private boolean getOverwriteExisting() {
        return this.overwriteExistingFilesCheckbox.getSelection();
    }

    private boolean getTransferAll() {
        return this.transferAllButton.getSelection();
    }

    protected void setDestinationValue(String string) {
        this.destinationNameField.setText(string);
    }

    public void dispose() {
        super.dispose();
        this.transfers = null;
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    @Override
    public String queryOverwrite(String string) {
        Path path = new Path(string);
        String string2 = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)PreferencesMessages.WizardDataTransfer_existsQuestion, (Object)string) : NLS.bind((String)PreferencesMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog messageDialog = new MessageDialog(this.getContainer().getShell(), PreferencesMessages.Question, null, string2, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] stringArray = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                messageDialog.open();
            }
        });
        return messageDialog.getReturnCode() < 0 ? "CANCEL" : stringArray[messageDialog.getReturnCode()];
    }

    private void updateEnablement() {
        boolean bl = this.getTransferAll();
        this.selectAllButton.setEnabled(!bl);
        this.deselectAllButton.setEnabled(!bl);
    }
}

