/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;

public class WizardPreferencesImportPage1
extends WizardPreferencesPage {
    protected WizardPreferencesImportPage1(String string) {
        super(string);
        this.setTitle(PreferencesMessages.WizardPreferencesImportPage1_importTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesImportPage1_importDescription);
    }

    public WizardPreferencesImportPage1() {
        this("preferencesImportPage1");
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.preferences_import_wizard_page");
    }

    @Override
    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesImportPage1_all;
    }

    @Override
    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesImportPage1_choose;
    }

    @Override
    protected PreferenceTransferElement[] getTransfers() {
        if (this.validFromFile()) {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this.getDestinationValue());
            }
            catch (FileNotFoundException fileNotFoundException) {
                WorkbenchPlugin.log(fileNotFoundException.getMessage(), fileNotFoundException);
                return new PreferenceTransferElement[0];
            }
            IPreferencesService iPreferencesService = Platform.getPreferencesService();
            try {
                PreferenceTransferElement[] preferenceTransferElementArray;
                IExportedPreferences iExportedPreferences = iPreferencesService.readPreferences((InputStream)fileInputStream);
                PreferenceTransferElement[] preferenceTransferElementArray2 = super.getTransfers();
                IPreferenceFilter[] iPreferenceFilterArray = new IPreferenceFilter[preferenceTransferElementArray2.length];
                int n = 0;
                while (n < preferenceTransferElementArray2.length) {
                    preferenceTransferElementArray = preferenceTransferElementArray2[n];
                    iPreferenceFilterArray[n] = preferenceTransferElementArray.getFilter();
                    ++n;
                }
                IPreferenceFilter[] iPreferenceFilterArray2 = iPreferencesService.matches((IEclipsePreferences)iExportedPreferences, iPreferenceFilterArray);
                preferenceTransferElementArray = new PreferenceTransferElement[iPreferenceFilterArray2.length];
                int n2 = 0;
                int n3 = 0;
                while (n3 < iPreferenceFilterArray2.length) {
                    IPreferenceFilter iPreferenceFilter = iPreferenceFilterArray2[n3];
                    int n4 = 0;
                    while (n4 < preferenceTransferElementArray2.length) {
                        PreferenceTransferElement preferenceTransferElement = preferenceTransferElementArray2[n4];
                        if (preferenceTransferElement.getFilter().equals(iPreferenceFilter)) {
                            preferenceTransferElementArray[n2++] = preferenceTransferElement;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                PreferenceTransferElement[] preferenceTransferElementArray3 = new PreferenceTransferElement[n2];
                System.arraycopy(preferenceTransferElementArray, 0, preferenceTransferElementArray3, 0, n2);
                PreferenceTransferElement[] preferenceTransferElementArray4 = preferenceTransferElementArray3;
                return preferenceTransferElementArray4;
            }
            catch (CoreException coreException) {
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    WorkbenchPlugin.log(iOException.getMessage(), iOException);
                }
            }
        }
        return new PreferenceTransferElement[0];
    }

    private boolean validFromFile() {
        File file = new File(this.getDestinationValue());
        return file.exists() && !file.isDirectory();
    }

    @Override
    protected void setPreferenceTransfers() {
        super.setPreferenceTransfers();
        if (this.validFromFile() && this.transfersTree.getViewer().getTree().getItemCount() == 0) {
            this.descText.setText(PreferencesMessages.WizardPreferences_noSpecificPreferenceDescription);
        } else {
            this.descText.setText("");
        }
    }

    @Override
    protected void createTransferArea(Composite composite) {
        this.createDestinationGroup(composite);
        this.createTransfersList(composite);
    }

    @Override
    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesImportPage1_file;
    }

    @Override
    protected boolean transfer(IPreferenceFilter[] iPreferenceFilterArray) {
        block19: {
            File file = new File(this.getDestinationValue());
            FileInputStream fileInputStream = null;
            try {
                if (iPreferenceFilterArray.length <= 0) break block19;
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    WorkbenchPlugin.log(fileNotFoundException.getMessage(), fileNotFoundException);
                    MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)fileNotFoundException.getLocalizedMessage(), (int)0x10000000);
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            WorkbenchPlugin.log(iOException.getMessage(), iOException);
                            MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)iOException.getLocalizedMessage(), (int)0x10000000);
                        }
                    }
                    return false;
                }
                IPreferencesService iPreferencesService = Platform.getPreferencesService();
                try {
                    IExportedPreferences iExportedPreferences = iPreferencesService.readPreferences((InputStream)fileInputStream);
                    iPreferencesService.applyPreferences((IEclipsePreferences)iExportedPreferences, iPreferenceFilterArray);
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log(coreException.getMessage(), coreException);
                    MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)coreException.getLocalizedMessage(), (int)0x10000000);
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            WorkbenchPlugin.log(iOException.getMessage(), iOException);
                            MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)iOException.getLocalizedMessage(), (int)0x10000000);
                        }
                    }
                    return false;
                }
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        WorkbenchPlugin.log(iOException.getMessage(), iOException);
                        MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)iOException.getLocalizedMessage(), (int)0x10000000);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.destinationNameField) {
            this.setPreferenceTransfers();
        }
        super.handleEvent(event);
    }

    @Override
    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesImportPage1_title;
    }

    @Override
    protected int getFileDialogStyle() {
        return 0x10001000;
    }

    @Override
    protected boolean validDestination() {
        return super.validDestination() && this.validFromFile();
    }

    @Override
    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesImportPage1_invalidPrefFile;
    }

    @Override
    protected boolean shouldSaveTransferAll() {
        return false;
    }
}

