/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;

public class WizardPreferencesExportPage1
extends WizardPreferencesPage {
    private static final String PREFERENCESEXPORTPAGE1 = "preferencesExportPage1";

    protected WizardPreferencesExportPage1(String string) {
        super(string);
        this.setTitle(PreferencesMessages.WizardPreferencesExportPage1_exportTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesExportPage1_exportDescription);
    }

    public WizardPreferencesExportPage1() {
        this(PREFERENCESEXPORTPAGE1);
    }

    protected String getOutputSuffix() {
        return ".epf";
    }

    @Override
    protected String getDestinationValue() {
        String string = this.getOutputSuffix();
        String string2 = super.getDestinationValue();
        if (string2.length() != 0 && !string2.endsWith(File.separator)) {
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                int n2 = string2.lastIndexOf(File.separator);
                if (n2 != -1 && n < n2) {
                    string2 = String.valueOf(string2) + string;
                }
            } else {
                string2 = String.valueOf(string2) + string;
            }
        }
        return string2;
    }

    @Override
    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_all;
    }

    @Override
    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesExportPage1_choose;
    }

    @Override
    protected void createTransferArea(Composite composite) {
        this.createTransfersList(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.preferences_export_wizard_page");
    }

    @Override
    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesExportPage1_file;
    }

    @Override
    protected PreferenceTransferElement[] getTransfers() {
        PreferenceTransferElement[] preferenceTransferElementArray = super.getTransfers();
        PreferenceTransferElement[] preferenceTransferElementArray2 = new PreferenceTransferElement[preferenceTransferElementArray.length];
        IPreferenceFilter[] iPreferenceFilterArray = new IPreferenceFilter[1];
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < preferenceTransferElementArray.length) {
                PreferenceTransferElement preferenceTransferElement = preferenceTransferElementArray[n2];
                iPreferenceFilterArray[0] = preferenceTransferElement.getFilter();
                IPreferenceFilter[] iPreferenceFilterArray2 = iPreferencesService.matches((IEclipsePreferences)iPreferencesService.getRootNode().node("instance"), iPreferenceFilterArray);
                if (iPreferenceFilterArray2.length > 0) {
                    preferenceTransferElementArray2[n++] = preferenceTransferElement;
                }
                ++n2;
            }
            preferenceTransferElementArray = new PreferenceTransferElement[n];
            System.arraycopy(preferenceTransferElementArray2, 0, preferenceTransferElementArray, 0, n);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log(coreException.getMessage(), coreException);
            return new PreferenceTransferElement[0];
        }
        return preferenceTransferElementArray;
    }

    @Override
    protected boolean transfer(IPreferenceFilter[] iPreferenceFilterArray) {
        block20: {
            File file = new File(this.getDestinationValue());
            if (!this.ensureTargetIsValid(file)) {
                return false;
            }
            FileOutputStream fileOutputStream = null;
            try {
                if (iPreferenceFilterArray.length <= 0) break block20;
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    WorkbenchPlugin.log(fileNotFoundException.getMessage(), fileNotFoundException);
                    MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)fileNotFoundException.getLocalizedMessage(), (int)0x10000000);
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            WorkbenchPlugin.log(iOException.getMessage(), iOException);
                            MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)iOException.getLocalizedMessage(), (int)0x10000000);
                            return false;
                        }
                    }
                    return false;
                }
                IPreferencesService iPreferencesService = Platform.getPreferencesService();
                try {
                    iPreferencesService.exportPreferences(iPreferencesService.getRootNode(), iPreferenceFilterArray, (OutputStream)fileOutputStream);
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log(coreException.getMessage(), coreException);
                    MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)coreException.getLocalizedMessage(), (int)0x10000000);
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            WorkbenchPlugin.log(iOException.getMessage(), iOException);
                            MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)iOException.getLocalizedMessage(), (int)0x10000000);
                            return false;
                        }
                    }
                    return false;
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        WorkbenchPlugin.log(iOException.getMessage(), iOException);
                        MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)iOException.getLocalizedMessage(), (int)0x10000000);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesExportPage1_title;
    }

    @Override
    protected int getFileDialogStyle() {
        return 0x10002000;
    }

    @Override
    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesExportPage1_noPrefFile;
    }

    @Override
    protected boolean shouldSaveTransferAll() {
        return true;
    }
}

