/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.WizardsRegistryReader;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.internal.wizards.AbstractWizardRegistry;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.wizards.IWizardDescriptor;

public abstract class AbstractExtensionWizardRegistry
extends AbstractWizardRegistry
implements IExtensionChangeHandler {
    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        WizardsRegistryReader wizardsRegistryReader = new WizardsRegistryReader(this.getPlugin(), this.getExtensionPoint());
        wizardsRegistryReader.setInitialCollection(this.getWizardElements());
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            wizardsRegistryReader.readElement(iConfigurationElementArray[n]);
            ++n;
        }
        this.setWizardElements(wizardsRegistryReader.getWizardElements());
        this.registerWizards(this.getWizardElements());
        WorkbenchWizardElement[] workbenchWizardElementArray = wizardsRegistryReader.getPrimaryWizards();
        if (workbenchWizardElementArray.length == 0) {
            return;
        }
        IWizardDescriptor[] iWizardDescriptorArray = this.getPrimaryWizards();
        WorkbenchWizardElement[] workbenchWizardElementArray2 = new WorkbenchWizardElement[workbenchWizardElementArray.length + iWizardDescriptorArray.length];
        System.arraycopy(iWizardDescriptorArray, 0, workbenchWizardElementArray2, 0, iWizardDescriptorArray.length);
        System.arraycopy(workbenchWizardElementArray, 0, workbenchWizardElementArray2, iWizardDescriptorArray.length, workbenchWizardElementArray.length);
        this.setPrimaryWizards(workbenchWizardElementArray2);
    }

    @Override
    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    @Override
    protected void doInitialize() {
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        WizardsRegistryReader wizardsRegistryReader = new WizardsRegistryReader(this.getPlugin(), this.getExtensionPoint());
        this.setWizardElements(wizardsRegistryReader.getWizardElements());
        this.setPrimaryWizards(wizardsRegistryReader.getPrimaryWizards());
        this.registerWizards(this.getWizardElements());
    }

    protected abstract String getExtensionPoint();

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint(this.getPlugin(), this.getExtensionPoint());
    }

    protected abstract String getPlugin();

    private void register(IExtension iExtension, Object object) {
        PlatformUI.getWorkbench().getExtensionTracker().registerObject(iExtension, object, 2);
    }

    private void registerWizards(WizardCollectionElement wizardCollectionElement) {
        this.registerWizards(wizardCollectionElement.getWorkbenchWizardElements());
        WizardCollectionElement[] wizardCollectionElementArray = wizardCollectionElement.getCollectionElements();
        int n = 0;
        while (n < wizardCollectionElementArray.length) {
            IConfigurationElement iConfigurationElement = wizardCollectionElementArray[n].getConfigurationElement();
            if (iConfigurationElement != null) {
                this.register(iConfigurationElement.getDeclaringExtension(), wizardCollectionElementArray[n]);
            }
            this.registerWizards(wizardCollectionElementArray[n]);
            ++n;
        }
    }

    private void registerWizards(WorkbenchWizardElement[] workbenchWizardElementArray) {
        int n = 0;
        while (n < workbenchWizardElementArray.length) {
            this.register(workbenchWizardElementArray[n].getConfigurationElement().getDeclaringExtension(), workbenchWizardElementArray[n]);
            ++n;
        }
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        if (!iExtension.getExtensionPointUniqueIdentifier().equals(this.getExtensionPointFilter().getUniqueIdentifier())) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            WorkbenchAdapter workbenchAdapter;
            Object object = objectArray[n];
            if (object instanceof WizardCollectionElement) {
                workbenchAdapter = (WizardCollectionElement)object;
                ((WizardCollectionElement)workbenchAdapter).getParentCollection().remove((IAdaptable)workbenchAdapter);
            } else if (object instanceof WorkbenchWizardElement) {
                workbenchAdapter = (WorkbenchWizardElement)object;
                WizardCollectionElement wizardCollectionElement = ((WorkbenchWizardElement)workbenchAdapter).getCollectionElement();
                if (wizardCollectionElement != null) {
                    wizardCollectionElement.remove((IAdaptable)workbenchAdapter);
                }
                Object[] objectArray2 = this.getPrimaryWizards();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    if (objectArray2[n2] == workbenchAdapter) {
                        Object[] objectArray3 = new WorkbenchWizardElement[objectArray2.length - 1];
                        Util.arrayCopyWithRemoval(objectArray2, objectArray3, n2);
                        objectArray2 = objectArray3;
                        break;
                    }
                    ++n2;
                }
                this.setPrimaryWizards((WorkbenchWizardElement[])objectArray2);
            }
            ++n;
        }
    }
}

