/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class Util {
    public static final SortedMap EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String safeString(String string) {
        if (string != null) {
            return string;
        }
        return ZERO_LENGTH_STRING;
    }

    public static Object getAdapter(Object object, Class clazz) {
        Object object2;
        Object object3;
        Assert.isNotNull((Object)clazz);
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable && (object3 = (object2 = (IAdaptable)object).getAdapter(clazz)) != null) {
            Assert.isTrue((boolean)clazz.isInstance(object3));
            return object3;
        }
        if (!(object instanceof PlatformObject) && (object2 = Platform.getAdapterManager().getAdapter(object, clazz)) != null) {
            return object2;
        }
        return null;
    }

    public static void assertInstance(Object object, Class clazz) {
        Util.assertInstance(object, clazz, false);
    }

    public static void assertInstance(Object object, Class clazz, boolean bl) {
        if (object == null && bl) {
            return;
        }
        if (object == null || clazz == null) {
            throw new NullPointerException();
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static int compare(boolean bl, boolean bl2) {
        return !bl ? (bl2 ? -1 : 0) : 1;
    }

    public static int compare(Comparable comparable, Comparable comparable2) {
        if (comparable == null && comparable2 == null) {
            return 0;
        }
        if (comparable == null) {
            return -1;
        }
        if (comparable2 == null) {
            return 1;
        }
        return comparable.compareTo(comparable2);
    }

    public static int compare(Comparable[] comparableArray, Comparable[] comparableArray2) {
        if (comparableArray == null && comparableArray2 == null) {
            return 0;
        }
        if (comparableArray == null) {
            return -1;
        }
        if (comparableArray2 == null) {
            return 1;
        }
        int n = comparableArray.length;
        int n2 = comparableArray2.length;
        if (n != n2) {
            return n - n2;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = Util.compare(comparableArray[n3], comparableArray2[n3]);
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static int compare(int n, int n2) {
        return n - n2;
    }

    public static int compare(List list, List list2) {
        int n;
        if (list == null && list2 == null) {
            return 0;
        }
        if (list == null) {
            return -1;
        }
        if (list2 == null) {
            return 1;
        }
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            return n2 - n;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Util.compare((Comparable)list.get(n3), (Comparable)list2.get(n3));
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object == object2) {
            return 0;
        }
        return Util.compare(System.identityHashCode(object), System.identityHashCode(object2));
    }

    public static final int compareIdentity(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return System.identityHashCode(object) - System.identityHashCode(object2);
    }

    public static void diff(Map map, Map map2, Set set, Set set2, Set set3) {
        if (map == null || map2 == null || set == null || set2 == null || set3 == null) {
            throw new NullPointerException();
        }
        for (Object k : map.keySet()) {
            if (!map2.containsKey(k)) {
                set.add(k);
                continue;
            }
            if (Util.equals(map.get(k), map2.get(k))) continue;
            set2.add(k);
        }
        for (Object k : map2.keySet()) {
            if (map.containsKey(k)) continue;
            set3.add(k);
        }
    }

    public static void diff(Set set, Set set2, Set set3, Set set4) {
        if (set == null || set2 == null || set3 == null || set4 == null) {
            throw new NullPointerException();
        }
        for (Object e : set) {
            if (set2.contains(e)) continue;
            set3.add(e);
        }
        for (Object e : set2) {
            if (set.contains(e)) continue;
            set4.add(e);
        }
    }

    public static boolean endsWith(List list, List list2, boolean bl) {
        if (list == null || list2 == null) {
            return false;
        }
        int n = list.size();
        int n2 = list2.size();
        if (n2 > n || !bl && n2 == n) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!Util.equals(list.get(n - n3 - 1), list2.get(n2 - n3 - 1))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean endsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n2 - n3 - 1], objectArray2[n - n3 - 1])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object2 != null && object.equals(object2);
    }

    public static final boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            boolean bl;
            Object object = objectArray[n];
            Object object2 = objectArray2[n];
            boolean bl2 = object == null ? object2 == null : (bl = object.equals(object2));
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int hashCode(boolean bl) {
        return bl ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public static int hashCode(int n) {
        return n;
    }

    public static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static Collection safeCopy(Collection collection, Class clazz) {
        return Util.safeCopy(collection, clazz, false);
    }

    public static Collection safeCopy(Collection collection, Class clazz, boolean bl) {
        if (collection == null || clazz == null) {
            throw new NullPointerException();
        }
        collection = Collections.unmodifiableCollection(new ArrayList(collection));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return collection;
    }

    public static List safeCopy(List list, Class clazz) {
        return Util.safeCopy(list, clazz, false);
    }

    public static List safeCopy(List list, Class clazz, boolean bl) {
        if (list == null || clazz == null) {
            throw new NullPointerException();
        }
        list = Collections.unmodifiableList(new ArrayList(list));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return list;
    }

    public static Map safeCopy(Map map, Class clazz, Class clazz2) {
        return Util.safeCopy(map, clazz, clazz2, false, false);
    }

    public static Map safeCopy(Map map, Class clazz, Class clazz2, boolean bl, boolean bl2) {
        if (map == null || clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        map = Collections.unmodifiableMap(new HashMap(map));
        for (Map.Entry entry : map.entrySet()) {
            Util.assertInstance(entry.getKey(), clazz, bl);
            Util.assertInstance(entry.getValue(), clazz2, bl2);
        }
        return map;
    }

    public static Set safeCopy(Set set, Class clazz) {
        return Util.safeCopy(set, clazz, false);
    }

    public static Set safeCopy(Set set, Class clazz, boolean bl) {
        if (set == null || clazz == null) {
            throw new NullPointerException();
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return set;
    }

    public static SortedMap safeCopy(SortedMap sortedMap, Class clazz, Class clazz2) {
        return Util.safeCopy(sortedMap, clazz, clazz2, false, false);
    }

    public static SortedMap safeCopy(SortedMap sortedMap, Class clazz, Class clazz2, boolean bl, boolean bl2) {
        if (sortedMap == null || clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        sortedMap = Collections.unmodifiableSortedMap(new TreeMap(sortedMap));
        for (Map.Entry entry : sortedMap.entrySet()) {
            Util.assertInstance(entry.getKey(), clazz, bl);
            Util.assertInstance(entry.getValue(), clazz2, bl2);
        }
        return sortedMap;
    }

    public static SortedSet safeCopy(SortedSet sortedSet, Class clazz) {
        return Util.safeCopy(sortedSet, clazz, false);
    }

    public static SortedSet safeCopy(SortedSet sortedSet, Class clazz, boolean bl) {
        if (sortedSet == null || clazz == null) {
            throw new NullPointerException();
        }
        sortedSet = Collections.unmodifiableSortedSet(new TreeSet(sortedSet));
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return sortedSet;
    }

    public static boolean startsWith(List list, List list2, boolean bl) {
        if (list == null || list2 == null) {
            return false;
        }
        int n = list.size();
        int n2 = list2.size();
        if (n2 > n || !bl && n2 == n) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!Util.equals(list.get(n3), list2.get(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean startsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n3], objectArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static String translateString(ResourceBundle resourceBundle, String string) {
        return Util.translateString(resourceBundle, string, string, true, true);
    }

    public static String translateString(ResourceBundle resourceBundle, String string, String string2, boolean bl, boolean bl2) {
        block4: {
            if (resourceBundle != null && string != null) {
                try {
                    String string3 = resourceBundle.getString(string);
                    if (string3 != null) {
                        return bl2 ? string3.trim() : string3;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!bl) break block4;
                    WorkbenchPlugin.log(missingResourceException);
                }
            }
        }
        return bl2 ? string2.trim() : string2;
    }

    public static void arrayCopyWithRemoval(Object[] objectArray, Object[] objectArray2, int n) {
        if (objectArray == null || objectArray2 == null || objectArray.length - 1 != objectArray2.length || n < 0 || n >= objectArray.length) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        } else if (n == objectArray.length - 1) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
        } else {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        }
    }

    public static Object[] appendArray(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    private Util() {
    }

    public static String intern(String string) {
        return string == null ? null : string.intern();
    }

    public static String[] getArrayFromList(String string, String string2) {
        if (string == null || string.trim().equals(ZERO_LENGTH_STRING)) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals(ZERO_LENGTH_STRING)) continue;
            arrayList.add(string3);
        }
        return arrayList.isEmpty() ? new String[]{} : arrayList.toArray(new String[arrayList.size()]);
    }

    public static String createList(String string, String string2) {
        return NLS.bind((String)WorkbenchMessages.Util_List, (Object)string, (Object)string2);
    }

    public static String createList(List list) {
        String string = null;
        for (Object e : list) {
            String string2 = e == null ? WorkbenchMessages.Util_listNull : e.toString();
            string = string == null ? string2 : Util.createList(string, string2);
        }
        return Util.safeString(string);
    }

    public static String createList(Object[] objectArray) {
        String string = null;
        int n = 0;
        while (n < objectArray.length) {
            string = string == null ? objectArray[n].toString() : Util.createList(string, objectArray[n].toString());
            ++n;
        }
        return Util.safeString(string);
    }

    public static IWorkbenchWindow getWorkbenchWindowForShell(Shell shell) {
        IWorkbenchWindow iWorkbenchWindow = null;
        while (iWorkbenchWindow == null && shell != null) {
            if (shell.getData() instanceof IWorkbenchWindow) {
                iWorkbenchWindow = (IWorkbenchWindow)shell.getData();
                continue;
            }
            shell = (Shell)shell.getParent();
        }
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return iWorkbenchWindow;
    }

    public static Shell getShellToParentOn() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        IWorkbenchWindow iWorkbenchWindow2 = iWorkbenchWindow == null ? (iWorkbench.getWorkbenchWindowCount() > 0 ? iWorkbench.getWorkbenchWindows()[0] : null) : iWorkbenchWindow;
        return iWorkbenchWindow2 == null ? null : iWorkbenchWindow.getShell();
    }

    public static String[] split(String string, char c) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (string.length() == 0) {
            return new String[]{ZERO_LENGTH_STRING};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(c);
        int n2 = 0;
        while (n != -1) {
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
            n = n2 == string.length() ? -1 : string.indexOf(c, n2);
        }
        if (n2 < string.length()) {
            arrayList.add(string.substring(n2));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        boolean bl = true;
        int n3 = 0;
        while (n3 < stringArray.length && bl) {
            if (stringArray[n3].length() > 0) {
                bl = false;
            }
            ++n3;
        }
        if (bl) {
            return EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    public static String replaceAll(String string, String string2, String string3) {
        return org.eclipse.jface.util.Util.replaceAll((String)string, (String)string2, (String)string3);
    }

    public static Object safeLoadExecutableExtension(IConfigurationElement iConfigurationElement, String string, Class clazz) {
        String string2;
        Object object;
        Object object2 = null;
        try {
            object2 = iConfigurationElement.createExecutableExtension(string);
        }
        catch (CoreException coreException) {
            object = iConfigurationElement.getAttribute(string);
            string2 = "Class load Failure: '" + (String)object + "'";
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string2, (Throwable)coreException);
            WorkbenchPlugin.log(string2, (IStatus)status);
        }
        if (clazz != null && object2 != null && !clazz.isInstance(object2)) {
            String string3 = "Loaded class is of incorrect type: expected(" + clazz.getName() + ") got (" + object2.getClass().getName() + ")";
            object = new IllegalArgumentException(string3);
            string2 = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string3, (Throwable)object);
            WorkbenchPlugin.log(string3, (IStatus)string2);
            object2 = null;
        }
        return object2;
    }
}

