/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class Descriptors {
    private static final String DISPOSE_LIST = "Descriptors.disposeList";
    private static DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            Descriptors.doDispose(disposeEvent.widget);
        }
    };

    private Descriptors() {
    }

    public static void setImage(Item item, ImageDescriptor imageDescriptor) {
        Descriptors.callMethod((Widget)item, "setImage", (DeviceResourceDescriptor)imageDescriptor, Image.class);
    }

    public static void setHotImage(ToolItem toolItem, ImageDescriptor imageDescriptor) {
        Descriptors.callMethod((Widget)toolItem, "setHotImage", (DeviceResourceDescriptor)imageDescriptor, Image.class);
    }

    public static void setDisabledImage(ToolItem toolItem, ImageDescriptor imageDescriptor) {
        Descriptors.callMethod((Widget)toolItem, "setDisabledImage", (DeviceResourceDescriptor)imageDescriptor, Image.class);
    }

    public static void setFont(TableItem tableItem, FontDescriptor fontDescriptor) {
        Descriptors.callMethod((Widget)tableItem, "setFont", (DeviceResourceDescriptor)fontDescriptor, Font.class);
    }

    public static void setBackground(TableItem tableItem, ColorDescriptor colorDescriptor) {
        Descriptors.callMethod((Widget)tableItem, "setBackground", (DeviceResourceDescriptor)colorDescriptor, Color.class);
    }

    public static void setForeground(TableItem tableItem, ColorDescriptor colorDescriptor) {
        Descriptors.callMethod((Widget)tableItem, "setForeground", (DeviceResourceDescriptor)colorDescriptor, Color.class);
    }

    public static void setBackground(Control control, ColorDescriptor colorDescriptor) {
        Descriptors.callMethod((Widget)control, "setBackground", (DeviceResourceDescriptor)colorDescriptor, Color.class);
    }

    public static void setForeground(Control control, ColorDescriptor colorDescriptor) {
        Descriptors.callMethod((Widget)control, "setForeground", (DeviceResourceDescriptor)colorDescriptor, Color.class);
    }

    public static void setImage(Button button, ImageDescriptor imageDescriptor) {
        Descriptors.callMethod((Widget)button, "setImage", (DeviceResourceDescriptor)imageDescriptor, Image.class);
    }

    public static void setImage(Label label, ImageDescriptor imageDescriptor) {
        Descriptors.callMethod((Widget)label, "setImage", (DeviceResourceDescriptor)imageDescriptor, Image.class);
    }

    private static ResourceMethod getResourceMethod(Widget widget, String string, Class clazz) throws NoSuchMethodException {
        ArrayList arrayList;
        Object object2;
        ArrayList arrayList2 = widget.getData(DISPOSE_LIST);
        if (arrayList2 instanceof List) {
            for (Object object2 : (List)arrayList2) {
                if (((ResourceMethod)object2).id != string) continue;
                return object2;
            }
        }
        if (arrayList2 instanceof ResourceMethod) {
            if (((ResourceMethod)((Object)arrayList2)).id == string) {
                return (ResourceMethod)((Object)arrayList2);
            }
            arrayList = new ArrayList();
            arrayList.add(arrayList2);
            arrayList2 = arrayList;
            widget.setData(DISPOSE_LIST, arrayList2);
        }
        arrayList = widget.getClass();
        object2 = ((Class)((Object)arrayList)).getMethod(string, clazz);
        ResourceMethod resourceMethod = new ResourceMethod((Method)object2, string);
        if (arrayList2 == null) {
            widget.setData(DISPOSE_LIST, (Object)resourceMethod);
            widget.addDisposeListener(disposeListener);
        } else {
            ((List)arrayList2).add(resourceMethod);
        }
        return resourceMethod;
    }

    private static void callMethod(Widget widget, String string, DeviceResourceDescriptor deviceResourceDescriptor, Class clazz) {
        ResourceMethod resourceMethod;
        try {
            resourceMethod = Descriptors.getResourceMethod(widget, string, clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            WorkbenchPlugin.log(noSuchMethodException);
            return;
        }
        resourceMethod.invoke(widget, deviceResourceDescriptor);
    }

    private static void doDispose(Widget widget) {
        Object object = widget.getData(DISPOSE_LIST);
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            ResourceMethod[] resourceMethodArray = arrayList.toArray(new ResourceMethod[arrayList.size()]);
            int n = 0;
            while (n < resourceMethodArray.length) {
                ResourceMethod resourceMethod = resourceMethodArray[n];
                resourceMethod.dispose();
                ++n;
            }
        }
        if (object instanceof ResourceMethod) {
            ((ResourceMethod)object).dispose();
        }
    }

    private static final class ResourceMethod {
        Method method;
        DeviceResourceDescriptor oldDescriptor;
        String id;

        ResourceMethod(Method method, String string) {
            this.method = method;
            this.id = string;
        }

        public void invoke(Widget widget, DeviceResourceDescriptor deviceResourceDescriptor) {
            Object object;
            if (deviceResourceDescriptor == this.oldDescriptor) {
                return;
            }
            ResourceManager resourceManager = JFaceResources.getResources((Display)widget.getDisplay());
            try {
                object = deviceResourceDescriptor == null ? null : resourceManager.create(deviceResourceDescriptor);
            }
            catch (DeviceResourceException deviceResourceException) {
                WorkbenchPlugin.log(deviceResourceException);
                return;
            }
            try {
                this.method.invoke((Object)widget, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (IllegalAccessException illegalAccessException) {
                WorkbenchPlugin.log(illegalAccessException);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                WorkbenchPlugin.log(invocationTargetException);
                return;
            }
            if (this.oldDescriptor != null) {
                resourceManager.destroy(this.oldDescriptor);
            }
            this.oldDescriptor = deviceResourceDescriptor;
        }

        public void dispose() {
            if (this.oldDescriptor != null) {
                ResourceManager resourceManager = JFaceResources.getResources();
                resourceManager.destroy(this.oldDescriptor);
                this.oldDescriptor = null;
            }
        }
    }
}

