/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;

public final class ConfigurationElementMemento
implements IMemento {
    private IConfigurationElement configurationElement;

    public ConfigurationElementMemento(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            throw new NullPointerException();
        }
        this.configurationElement = iConfigurationElement;
    }

    @Override
    public IMemento createChild(String string) {
        return null;
    }

    @Override
    public IMemento createChild(String string, String string2) {
        return null;
    }

    @Override
    public IMemento getChild(String string) {
        IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren(string);
        if (iConfigurationElementArray != null && iConfigurationElementArray.length >= 1) {
            return new ConfigurationElementMemento(iConfigurationElementArray[0]);
        }
        return null;
    }

    @Override
    public IMemento[] getChildren() {
        IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren();
        return this.getMementoArray(iConfigurationElementArray);
    }

    @Override
    public IMemento[] getChildren(String string) {
        IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren(string);
        return this.getMementoArray(iConfigurationElementArray);
    }

    private IMemento[] getMementoArray(IConfigurationElement[] iConfigurationElementArray) {
        if (iConfigurationElementArray != null && iConfigurationElementArray.length > 0) {
            IMemento[] iMementoArray = new ConfigurationElementMemento[iConfigurationElementArray.length];
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                iMementoArray[n] = new ConfigurationElementMemento(iConfigurationElementArray[n]);
                ++n;
            }
            return iMementoArray;
        }
        return new IMemento[0];
    }

    @Override
    public Float getFloat(String string) {
        String string2 = this.configurationElement.getAttribute(string);
        if (string2 != null) {
            try {
                return new Float(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Override
    public String getType() {
        return this.configurationElement.getName();
    }

    @Override
    public String getID() {
        return this.configurationElement.getAttribute("IMemento.internal.id");
    }

    @Override
    public Integer getInteger(String string) {
        String string2 = this.configurationElement.getAttribute(string);
        if (string2 != null) {
            try {
                return new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Override
    public String getString(String string) {
        return this.configurationElement.getAttribute(string);
    }

    @Override
    public Boolean getBoolean(String string) {
        String string2 = this.configurationElement.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return Boolean.valueOf(string2);
    }

    @Override
    public String getTextData() {
        return this.configurationElement.getValue();
    }

    @Override
    public String[] getAttributeKeys() {
        return this.configurationElement.getAttributeNames();
    }

    @Override
    public void putFloat(String string, float f) {
    }

    @Override
    public void putInteger(String string, int n) {
    }

    @Override
    public void putMemento(IMemento iMemento) {
    }

    @Override
    public void putString(String string, String string2) {
    }

    @Override
    public void putBoolean(String string, boolean bl) {
    }

    @Override
    public void putTextData(String string) {
    }

    public String getContributorName() {
        return this.configurationElement.getContributor().getName();
    }

    public String getExtensionID() {
        return this.configurationElement.getDeclaringExtension().getUniqueIdentifier();
    }
}

