/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.tweaklets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class Tweaklets {
    private static Map defaults = new HashMap();
    private static Map tweaklets = new HashMap();

    public static void setDefault(TweakKey tweakKey, Object object) {
        defaults.put(tweakKey, object);
    }

    public static Object get(TweakKey tweakKey) {
        Object object = tweaklets.get(tweakKey);
        if (object == null) {
            object = Tweaklets.createTweaklet(tweakKey);
            if (object == null) {
                object = Tweaklets.getDefault(tweakKey);
            }
            Assert.isNotNull(object);
            tweaklets.put(tweakKey, object);
        }
        return object;
    }

    private static Object getDefault(TweakKey tweakKey) {
        return defaults.get(tweakKey);
    }

    private static Object createTweaklet(TweakKey tweakKey) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.internalTweaklets");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (tweakKey.tweakClass.getName().equals(iConfigurationElementArray[n].getAttribute("definition"))) {
                try {
                    Object object = iConfigurationElementArray[n].createExecutableExtension("implementation");
                    tweaklets.put(tweakKey, object);
                    return object;
                }
                catch (CoreException coreException) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(4, "Error with extension " + iConfigurationElementArray[n], (Throwable)coreException), 1);
                }
            }
            ++n;
        }
        return null;
    }

    public static class TweakKey {
        Class tweakClass;

        public TweakKey(Class clazz) {
            this.tweakClass = clazz;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.tweakClass == null ? 0 : this.tweakClass.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TweakKey tweakKey = (TweakKey)object;
            return !(this.tweakClass == null ? tweakKey.tweakClass != null : !this.tweakClass.equals(tweakKey.tweakClass));
        }
    }
}

