/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.tweaklets;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;

public class TabBehaviourMRU
extends TabBehaviour {
    @Override
    public boolean alwaysShowPinAction() {
        return false;
    }

    @Override
    public IEditorReference findReusableEditor(WorkbenchPage workbenchPage) {
        IEditorReference iEditorReference;
        boolean bl = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        if (!bl) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = workbenchPage.getSortedEditors();
        if (iEditorReferenceArray.length < workbenchPage.getEditorReuseThreshold()) {
            return null;
        }
        IEditorReference iEditorReference2 = null;
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            iEditorReference = iEditorReferenceArray[n];
            if (!iEditorReference.isPinned()) {
                if (iEditorReference.isDirty()) {
                    if (iEditorReference2 == null) {
                        iEditorReference2 = iEditorReference;
                    }
                } else {
                    return iEditorReference;
                }
            }
            ++n;
        }
        if (iEditorReference2 == null) {
            return null;
        }
        n = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_DIRTY_EDITORS") ? 1 : 0;
        if (n == 0) {
            return null;
        }
        iEditorReference = new MessageDialog(workbenchPage.getWorkbenchWindow().getShell(), WorkbenchMessages.EditorManager_reuseEditorDialogTitle, null, NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)iEditorReference2.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, WorkbenchMessages.EditorManager_openNewEditorLabel}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        int n2 = iEditorReference.open();
        if (n2 == 0) {
            IEditorPart iEditorPart = iEditorReference2.getEditor(true);
            if (!workbenchPage.getEditorManager().savePart(iEditorPart, iEditorPart, false)) {
                return null;
            }
        } else if (n2 == 2 || n2 == -1) {
            return null;
        }
        return iEditorReference2;
    }

    @Override
    public IEditorReference reuseInternalEditor(WorkbenchPage workbenchPage, EditorManager editorManager, EditorAreaHelper editorAreaHelper, EditorDescriptor editorDescriptor, IEditorInput iEditorInput, IEditorReference iEditorReference) {
        IEditorPart iEditorPart = iEditorReference.getEditor(false);
        if (iEditorPart == null) {
            EditorReference editorReference = new EditorReference(editorManager, iEditorInput, editorDescriptor);
            workbenchPage.closeEditor(iEditorReference, false);
            return editorReference;
        }
        EditorSite editorSite = (EditorSite)iEditorPart.getEditorSite();
        EditorDescriptor editorDescriptor2 = editorSite.getEditorDescriptor();
        if (editorDescriptor.getId().equals(editorDescriptor2.getId()) && iEditorPart instanceof IReusableEditor) {
            Workbench workbench = (Workbench)workbenchPage.getWorkbenchWindow().getWorkbench();
            editorAreaHelper.moveEditor(iEditorPart, -1);
            workbench.getEditorHistory().add(iEditorPart.getEditorInput(), editorSite.getEditorDescriptor());
            workbenchPage.reuseEditor((IReusableEditor)iEditorPart, iEditorInput);
            return iEditorReference;
        }
        EditorReference editorReference = new EditorReference(editorManager, iEditorInput, editorDescriptor);
        iEditorPart.getEditorSite().getPage().closeEditor(iEditorPart, false);
        return editorReference;
    }
}

