/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.Theme;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class WorkbenchThemeManager
extends EventManager
implements IThemeManager {
    private static final String SYSTEM_DEFAULT_THEME = "org.eclipse.ui.ide.systemDefault";
    private static WorkbenchThemeManager instance;
    private ITheme currentTheme;
    private IPropertyChangeListener currentThemeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WorkbenchThemeManager.this.firePropertyChange(propertyChangeEvent);
            if (propertyChangeEvent.getSource() instanceof FontRegistry) {
                JFaceResources.getFontRegistry().put(propertyChangeEvent.getProperty(), (FontData[])propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() instanceof ColorRegistry) {
                JFaceResources.getColorRegistry().put(propertyChangeEvent.getProperty(), (RGB)propertyChangeEvent.getNewValue());
            }
        }
    };
    private ColorRegistry defaultThemeColorRegistry;
    private FontRegistry defaultThemeFontRegistry;
    private IThemeRegistry themeRegistry;
    private Map themes = new HashMap(7);

    public static synchronized WorkbenchThemeManager getInstance() {
        if (instance == null) {
            instance = new WorkbenchThemeManager();
            instance.getCurrentTheme();
        }
        return instance;
    }

    private WorkbenchThemeManager() {
        this.defaultThemeColorRegistry = new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        this.defaultThemeFontRegistry = new FontRegistry(PlatformUI.getWorkbench().getDisplay());
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        for (Object object2 : fontRegistry.getKeySet()) {
            this.defaultThemeFontRegistry.put((String)object2, fontRegistry.getFontData((String)object2));
        }
        Object object = PrefUtil.getAPIPreferenceStore().getDefaultString("CURRENT_THEME_ID");
        if (((String)object).length() == 0) {
            object = "org.eclipse.ui.defaultTheme";
        }
        if (PlatformUI.getWorkbench().getDisplay() != null) {
            Object object2;
            object2 = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable((boolean[])object2){
                private final /* synthetic */ boolean[] val$highContrast;
                {
                    this.val$highContrast = blArray;
                }

                @Override
                public void run() {
                    this.val$highContrast[0] = Display.getCurrent().getHighContrast();
                    Display.getCurrent().addListener(39, new Listener(){

                        public void handleEvent(Event event) {
                            WorkbenchThemeManager.this.updateThemes();
                        }
                    });
                }
            });
            if (object2[0] != false) {
                object = SYSTEM_DEFAULT_THEME;
            }
        }
        PrefUtil.getAPIPreferenceStore().setDefault("CURRENT_THEME_ID", (String)object);
    }

    private void updateThemes() {
        ThemeRegistryReader themeRegistryReader = new ThemeRegistryReader();
        themeRegistryReader.readThemes(Platform.getExtensionRegistry(), (ThemeRegistry)this.getThemeRegistry());
        ThemeElementHelper.populateRegistry(this.getTheme("org.eclipse.ui.defaultTheme"), this.getThemeRegistry().getColors(), PrefUtil.getInternalPreferenceStore());
        IThemeDescriptor[] iThemeDescriptorArray = this.getThemeRegistry().getThemes();
        int n = 0;
        while (n < iThemeDescriptorArray.length) {
            ColorDefinition[] colorDefinitionArray;
            IThemeDescriptor iThemeDescriptor = iThemeDescriptorArray[n];
            ITheme iTheme = (ITheme)this.themes.get(iThemeDescriptor);
            if (iTheme != null && (colorDefinitionArray = iThemeDescriptor.getColors()).length > 0) {
                ThemeElementHelper.populateRegistry(iTheme, colorDefinitionArray, PrefUtil.getInternalPreferenceStore());
            }
            ++n;
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    public void dispose() {
        for (ITheme iTheme : this.themes.values()) {
            iTheme.removePropertyChangeListener(this.currentThemeListener);
            iTheme.dispose();
        }
        this.themes.clear();
    }

    private boolean doSetCurrentTheme(String string) {
        ITheme iTheme = this.currentTheme;
        ITheme iTheme2 = this.getTheme(string);
        if (iTheme != iTheme2 && iTheme2 != null) {
            this.currentTheme = iTheme2;
            return true;
        }
        return false;
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    protected void firePropertyChange(String string, ITheme iTheme, ITheme iTheme2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, (Object)iTheme, (Object)iTheme2);
        this.firePropertyChange(propertyChangeEvent);
    }

    @Override
    public ITheme getCurrentTheme() {
        if (this.currentTheme == null) {
            String string = PrefUtil.getAPIPreferenceStore().getString("CURRENT_THEME_ID");
            if (string == null) {
                this.setCurrentTheme("org.eclipse.ui.defaultTheme");
            } else {
                this.setCurrentTheme(string);
                if (this.currentTheme == null) {
                    this.setCurrentTheme("org.eclipse.ui.defaultTheme");
                    StatusManager.getManager().handle(StatusUtil.newStatus("org.eclipse.ui", "Could not restore current theme: " + string, null));
                }
            }
        }
        return this.currentTheme;
    }

    public ColorRegistry getDefaultThemeColorRegistry() {
        return this.defaultThemeColorRegistry;
    }

    public FontRegistry getDefaultThemeFontRegistry() {
        return this.defaultThemeFontRegistry;
    }

    private ITheme getTheme(IThemeDescriptor iThemeDescriptor) {
        ITheme iTheme = (ITheme)this.themes.get(iThemeDescriptor);
        if (iTheme == null) {
            iTheme = new Theme(iThemeDescriptor);
            this.themes.put(iThemeDescriptor, iTheme);
        }
        return iTheme;
    }

    @Override
    public ITheme getTheme(String string) {
        if (string.equals("org.eclipse.ui.defaultTheme")) {
            return this.getTheme((IThemeDescriptor)null);
        }
        IThemeDescriptor iThemeDescriptor = this.getThemeRegistry().findTheme(string);
        if (iThemeDescriptor == null) {
            return null;
        }
        return this.getTheme(iThemeDescriptor);
    }

    private IThemeRegistry getThemeRegistry() {
        if (this.themeRegistry == null) {
            this.themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        }
        return this.themeRegistry;
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    @Override
    public void setCurrentTheme(String string) {
        ITheme iTheme = this.currentTheme;
        if (WorkbenchThemeManager.getInstance().doSetCurrentTheme(string)) {
            this.firePropertyChange("CHANGE_CURRENT_THEME", iTheme, this.getCurrentTheme());
            if (iTheme != null) {
                iTheme.removePropertyChangeListener(this.currentThemeListener);
            }
            this.currentTheme.addPropertyChangeListener(this.currentThemeListener);
            if (!PrefUtil.getAPIPreferenceStore().getString("CURRENT_THEME_ID").equals(string)) {
                PrefUtil.getAPIPreferenceStore().setValue("CURRENT_THEME_ID", string);
                PrefUtil.saveAPIPrefs();
            }
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            ColorRegistry colorRegistry2 = this.currentTheme.getColorRegistry();
            for (String string2 : colorRegistry2.getKeySet()) {
                colorRegistry.put(string2, colorRegistry2.getRGB(string2));
            }
            colorRegistry = JFaceResources.getFontRegistry();
            colorRegistry2 = this.currentTheme.getFontRegistry();
            for (String string2 : colorRegistry2.getKeySet()) {
                colorRegistry.put(string2, colorRegistry2.getFontData(string2));
            }
        }
    }
}

