/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemePreview;

public class WorkbenchPreview
implements IThemePreview {
    private static int tabPos = PlatformUI.getPreferenceStore().getInt("VIEW_TAB_POSITION");
    private boolean disposed = false;
    private CTabFolder folder;
    private ITheme theme;
    private ToolBar toolBar;
    private CLabel viewMessage;
    private ViewForm viewForm;
    private IPropertyChangeListener fontAndColorListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!WorkbenchPreview.this.disposed) {
                WorkbenchPreview.this.setColorsAndFonts();
                WorkbenchPreview.this.viewForm.layout(true);
            }
        }
    };

    @Override
    public void createControl(Composite composite, ITheme iTheme) {
        this.theme = iTheme;
        this.folder = new CTabFolder(composite, 2048);
        this.folder.setUnselectedCloseVisible(false);
        this.folder.setEnabled(false);
        this.folder.setMaximizeVisible(true);
        this.folder.setMinimizeVisible(true);
        this.viewForm = new ViewForm((Composite)this.folder, 0);
        this.viewForm.marginHeight = 0;
        this.viewForm.marginWidth = 0;
        this.viewForm.verticalSpacing = 0;
        this.viewForm.setBorderVisible(false);
        this.toolBar = new ToolBar((Composite)this.viewForm, 0x800040);
        ToolItem toolItem = new ToolItem(this.toolBar, 8);
        Image image = WorkbenchImages.getImage("IMG_LCL_VIEW_MENU");
        toolItem.setImage(image);
        this.viewForm.setTopRight((Control)this.toolBar);
        this.viewMessage = new CLabel((Composite)this.viewForm, 0);
        this.viewMessage.setText("Etu?");
        this.viewForm.setTopLeft((Control)this.viewMessage);
        CTabItem cTabItem = new CTabItem(this.folder, 64);
        cTabItem.setText("Lorem");
        Label label = new Label((Composite)this.viewForm, 0);
        this.viewForm.setContent((Control)label);
        label.setText("Lorem ipsum dolor sit amet");
        cTabItem = new CTabItem(this.folder, 64);
        cTabItem.setText("Ipsum");
        cTabItem.setControl((Control)this.viewForm);
        cTabItem.setImage(WorkbenchImages.getImage("IMG_TOOL_COPY"));
        this.folder.setSelection(cTabItem);
        cTabItem = new CTabItem(this.folder, 64);
        cTabItem.setText("Dolor");
        cTabItem = new CTabItem(this.folder, 64);
        cTabItem.setText("Sit");
        iTheme.addPropertyChangeListener(this.fontAndColorListener);
        this.setColorsAndFonts();
        this.setTabPosition();
        this.setTabStyle();
    }

    protected void setTabStyle() {
        boolean bl = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
        this.folder.setSimple(bl);
    }

    protected void setTabPosition() {
        tabPos = PlatformUI.getPreferenceStore().getInt("VIEW_TAB_POSITION");
        this.folder.setTabPosition(tabPos);
    }

    private void setColorsAndFonts() {
        this.folder.setSelectionForeground(this.theme.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        this.folder.setForeground(this.theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR"));
        Color[] colorArray = new Color[]{this.theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START"), this.theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END")};
        colorArray[0] = this.theme.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        colorArray[1] = this.theme.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        this.folder.setSelectionBackground(colorArray, new int[]{this.theme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT")}, this.theme.getBoolean("org.eclipse.ui.workbench.ACTIVE_TAB_VERTICAL"));
        this.folder.setFont(this.theme.getFontRegistry().get("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
        this.viewMessage.setFont(this.theme.getFontRegistry().get("org.eclipse.ui.workbench.VIEW_MESSAGE_TEXT_FONT"));
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.theme.removePropertyChangeListener(this.fontAndColorListener);
    }
}

