/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeDescriptor;
import org.eclipse.ui.internal.themes.ThemeElementCategory;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.themes.IColorFactory;

public class ThemeRegistryReader
extends RegistryReader {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(ThemeRegistryReader.class.getName());
    private Collection categoryDefinitions = new HashSet();
    private Collection colorDefinitions = new HashSet();
    private Collection fontDefinitions = new HashSet();
    private ThemeDescriptor themeDescriptor = null;
    private ThemeRegistry themeRegistry;
    private Map dataMap = new HashMap();

    public Collection getCategoryDefinitions() {
        return this.categoryDefinitions;
    }

    public Collection getColorDefinitions() {
        return this.colorDefinitions;
    }

    public Map getData() {
        return this.dataMap;
    }

    public Collection getFontDefinitions() {
        return this.fontDefinitions;
    }

    private ThemeElementCategory readCategory(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("label");
        String string2 = iConfigurationElement.getAttribute("id");
        String string3 = iConfigurationElement.getAttribute("parentId");
        String string4 = null;
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("description");
        if (iConfigurationElementArray.length > 0) {
            string4 = iConfigurationElementArray[0].getValue();
        }
        return new ThemeElementCategory(string, string2, string3, string4, iConfigurationElement.getNamespace(), iConfigurationElement);
    }

    private ColorDefinition readColor(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray;
        String string = iConfigurationElement.getAttribute("label");
        String string2 = iConfigurationElement.getAttribute("id");
        String string3 = iConfigurationElement.getAttribute("defaultsTo");
        String string4 = this.getPlatformSpecificColorValue(iConfigurationElement.getChildren("colorValue"));
        if (string4 == null) {
            string4 = this.getColorValue(iConfigurationElement);
        }
        if (string4 == null && string3 == null || string4 != null && string3 != null) {
            ThemeRegistryReader.logError(iConfigurationElement, RESOURCE_BUNDLE.getString("Colors.badDefault"));
            return null;
        }
        String string5 = iConfigurationElement.getAttribute("categoryId");
        String string6 = null;
        boolean bl = true;
        String string7 = iConfigurationElement.getAttribute("isEditable");
        if (string7 != null) {
            bl = Boolean.valueOf(string7);
        }
        if ((iConfigurationElementArray = iConfigurationElement.getChildren("description")).length > 0) {
            string6 = iConfigurationElementArray[0].getValue();
        }
        return new ColorDefinition(string, string2, string3, string4, string5, bl, string6, iConfigurationElement.getDeclaringExtension().getNamespace());
    }

    private String getColorValue(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            return null;
        }
        String string = iConfigurationElement.getAttribute("value");
        if (string == null) {
            string = this.checkColorFactory(iConfigurationElement);
        }
        return string;
    }

    private String getPlatformSpecificColorValue(IConfigurationElement[] iConfigurationElementArray) {
        return this.getColorValue(this.getBestPlatformMatch(iConfigurationElementArray));
    }

    private IConfigurationElement getBestPlatformMatch(IConfigurationElement[] iConfigurationElementArray) {
        IConfigurationElement iConfigurationElement = null;
        String string = Platform.getOS();
        String string2 = Platform.getWS();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            String string3 = iConfigurationElement2.getAttribute("os");
            String string4 = iConfigurationElement2.getAttribute("ws");
            if (string.equalsIgnoreCase(string3)) {
                if (string2.equalsIgnoreCase(string4)) {
                    return iConfigurationElement2;
                }
                iConfigurationElement = iConfigurationElement2;
            } else if (string2.equalsIgnoreCase(string4)) {
                iConfigurationElement = iConfigurationElement2;
            }
            ++n;
        }
        return iConfigurationElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean readElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        if (this.themeDescriptor == null && string.equals("colorDefinition")) {
            ColorDefinition colorDefinition = this.readColor(iConfigurationElement);
            if (colorDefinition == null) return true;
            if (this.colorDefinitions.contains(colorDefinition)) return true;
            this.colorDefinitions.add(colorDefinition);
            this.themeRegistry.add(colorDefinition);
            return true;
        }
        if (this.themeDescriptor != null && string.equals("colorOverride")) {
            ColorDefinition colorDefinition = this.readColor(iConfigurationElement);
            if (colorDefinition == null) return true;
            this.themeDescriptor.add(colorDefinition);
            return true;
        }
        if (this.themeDescriptor == null && string.equals("fontDefinition")) {
            FontDefinition fontDefinition = this.readFont(iConfigurationElement);
            if (fontDefinition == null) return true;
            if (this.fontDefinitions.contains(fontDefinition)) return true;
            this.fontDefinitions.add(fontDefinition);
            this.themeRegistry.add(fontDefinition);
            return true;
        }
        if (this.themeDescriptor != null && string.equals("fontOverride")) {
            FontDefinition fontDefinition = this.readFont(iConfigurationElement);
            if (fontDefinition == null) return true;
            this.themeDescriptor.add(fontDefinition);
            return true;
        }
        if (this.themeDescriptor == null && string.equals("themeElementCategory")) {
            ThemeElementCategory themeElementCategory = this.readCategory(iConfigurationElement);
            if (themeElementCategory == null) return true;
            if (this.categoryDefinitions.contains(themeElementCategory)) return true;
            this.categoryDefinitions.add(themeElementCategory);
            this.themeRegistry.add(themeElementCategory);
            return true;
        }
        if (iConfigurationElement.getName().equals("theme")) {
            if (this.themeDescriptor != null) {
                ThemeRegistryReader.logError(iConfigurationElement, RESOURCE_BUNDLE.getString("Themes.badNesting"));
                return false;
            }
            this.themeDescriptor = this.readTheme(iConfigurationElement);
            if (this.themeDescriptor == null) return true;
            this.readElementChildren(iConfigurationElement);
            this.themeDescriptor = null;
            return true;
        }
        if (this.themeDescriptor != null && string.equals("description")) {
            this.themeDescriptor.setDescription(iConfigurationElement.getValue());
            return true;
        }
        if (!string.equals("data")) {
            if (!string.equals("categoryPresentationBinding")) return false;
            String string2 = iConfigurationElement.getAttribute("categoryId");
            String string3 = iConfigurationElement.getAttribute("presentationId");
            this.themeRegistry.addCategoryPresentationBinding(string2, string3);
            return true;
        }
        String string4 = iConfigurationElement.getAttribute("name");
        String string5 = iConfigurationElement.getAttribute("value");
        if (string4 == null || string5 == null) {
            ThemeRegistryReader.logError(iConfigurationElement, RESOURCE_BUNDLE.getString("Data.badData"));
            return true;
        }
        if (this.themeDescriptor != null) {
            this.themeDescriptor.setData(string4, string5);
            return true;
        }
        this.themeRegistry.setData(string4, string5);
        if (this.dataMap.containsKey(string4)) return true;
        this.dataMap.put(string4, string5);
        return true;
    }

    private FontDefinition readFont(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("label");
        String string2 = iConfigurationElement.getAttribute("id");
        String string3 = iConfigurationElement.getAttribute("defaultsTo");
        String string4 = this.getPlatformSpecificFontValue(iConfigurationElement.getChildren("fontValue"));
        if (string4 == null) {
            string4 = iConfigurationElement.getAttribute("value");
        }
        if (string4 != null && string3 != null) {
            ThemeRegistryReader.logError(iConfigurationElement, RESOURCE_BUNDLE.getString("Fonts.badDefault"));
            return null;
        }
        String string5 = iConfigurationElement.getAttribute("categoryId");
        boolean bl = true;
        String string6 = iConfigurationElement.getAttribute("isEditable");
        if (string6 != null) {
            bl = Boolean.valueOf(string6);
        }
        String string7 = null;
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("description");
        if (iConfigurationElementArray.length > 0) {
            string7 = iConfigurationElementArray[0].getValue();
        }
        return new FontDefinition(string, string2, string3, string4, string5, bl, string7);
    }

    private String getPlatformSpecificFontValue(IConfigurationElement[] iConfigurationElementArray) {
        return this.getFontValue(this.getBestPlatformMatch(iConfigurationElementArray));
    }

    private String getFontValue(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            return null;
        }
        return iConfigurationElement.getAttribute("value");
    }

    private String checkColorFactory(IConfigurationElement iConfigurationElement) {
        String string = null;
        if (iConfigurationElement.getAttribute("colorFactory") != null || iConfigurationElement.getChildren("colorFactory").length > 0) {
            try {
                IColorFactory iColorFactory = (IColorFactory)iConfigurationElement.createExecutableExtension("colorFactory");
                string = StringConverter.asString((RGB)iColorFactory.createColor());
            }
            catch (Exception exception) {
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("Colors.badFactory"), WorkbenchPlugin.getStatus(exception));
            }
        }
        return string;
    }

    protected ThemeDescriptor readTheme(IConfigurationElement iConfigurationElement) {
        ThemeDescriptor themeDescriptor = null;
        String string = iConfigurationElement.getAttribute("id");
        if (string == null) {
            return null;
        }
        themeDescriptor = (ThemeDescriptor)this.themeRegistry.findTheme(string);
        if (themeDescriptor == null) {
            themeDescriptor = new ThemeDescriptor(string);
            this.themeRegistry.add(themeDescriptor);
        }
        themeDescriptor.extractName(iConfigurationElement);
        return themeDescriptor;
    }

    public void readThemes(IExtensionRegistry iExtensionRegistry, ThemeRegistry themeRegistry) {
        this.setRegistry(themeRegistry);
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "themes");
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "fontDefinitions");
    }

    public void setRegistry(ThemeRegistry themeRegistry) {
        this.themeRegistry = themeRegistry;
    }
}

