/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementCategory;

public class ThemeRegistry
implements IThemeRegistry {
    private List themes = new ArrayList();
    private List colors = new ArrayList();
    private List fonts = new ArrayList();
    private List categories = new ArrayList();
    private Map dataMap = new HashMap();
    private Map categoryBindingMap = new HashMap();

    void add(IThemeDescriptor iThemeDescriptor) {
        if (this.findTheme(iThemeDescriptor.getId()) != null) {
            return;
        }
        this.themes.add(iThemeDescriptor);
    }

    void add(ColorDefinition colorDefinition) {
        this.addOrReplaceDescriptor(this.colors, colorDefinition);
    }

    @Override
    public ThemeElementCategory findCategory(String string) {
        return (ThemeElementCategory)this.findDescriptor(this.getCategories(), string);
    }

    @Override
    public ColorDefinition findColor(String string) {
        return (ColorDefinition)this.findDescriptor(this.getColors(), string);
    }

    @Override
    public IThemeDescriptor findTheme(String string) {
        return (IThemeDescriptor)this.findDescriptor(this.getThemes(), string);
    }

    private IThemeElementDefinition findDescriptor(IThemeElementDefinition[] iThemeElementDefinitionArray, String string) {
        int n = Arrays.binarySearch(iThemeElementDefinitionArray, string, ID_COMPARATOR);
        if (n < 0) {
            return null;
        }
        return iThemeElementDefinitionArray[n];
    }

    private IThemeElementDefinition addOrReplaceDescriptor(List list, IThemeElementDefinition iThemeElementDefinition) {
        String string = iThemeElementDefinition.getId();
        int n = 0;
        while (n < list.size()) {
            IThemeElementDefinition iThemeElementDefinition2 = (IThemeElementDefinition)list.get(n);
            if (iThemeElementDefinition2.getId().equals(string)) {
                list.remove(n);
                list.add(iThemeElementDefinition);
                return iThemeElementDefinition2;
            }
            ++n;
        }
        list.add(iThemeElementDefinition);
        return null;
    }

    @Override
    public IThemeDescriptor[] getThemes() {
        int n = this.themes.size();
        IThemeDescriptor[] iThemeDescriptorArray = new IThemeDescriptor[n];
        this.themes.toArray(iThemeDescriptorArray);
        Arrays.sort(iThemeDescriptorArray, ID_COMPARATOR);
        return iThemeDescriptorArray;
    }

    @Override
    public ColorDefinition[] getColors() {
        int n = this.colors.size();
        ColorDefinition[] colorDefinitionArray = new ColorDefinition[n];
        this.colors.toArray(colorDefinitionArray);
        Arrays.sort(colorDefinitionArray, ID_COMPARATOR);
        return colorDefinitionArray;
    }

    @Override
    public ColorDefinition[] getColorsFor(String string) {
        IThemeElementDefinition[] iThemeElementDefinitionArray = this.getColors();
        if (string.equals("org.eclipse.ui.defaultTheme")) {
            return iThemeElementDefinitionArray;
        }
        IThemeDescriptor iThemeDescriptor = this.findTheme(string);
        IThemeElementDefinition[] iThemeElementDefinitionArray2 = iThemeDescriptor.getColors();
        return (ColorDefinition[])this.overlay(iThemeElementDefinitionArray, iThemeElementDefinitionArray2);
    }

    @Override
    public FontDefinition[] getFontsFor(String string) {
        IThemeElementDefinition[] iThemeElementDefinitionArray = this.getFonts();
        if (string.equals("org.eclipse.ui.defaultTheme")) {
            return iThemeElementDefinitionArray;
        }
        IThemeDescriptor iThemeDescriptor = this.findTheme(string);
        IThemeElementDefinition[] iThemeElementDefinitionArray2 = iThemeDescriptor.getFonts();
        return (FontDefinition[])this.overlay(iThemeElementDefinitionArray, iThemeElementDefinitionArray2);
    }

    private IThemeElementDefinition[] overlay(IThemeElementDefinition[] iThemeElementDefinitionArray, IThemeElementDefinition[] iThemeElementDefinitionArray2) {
        int n = 0;
        while (n < iThemeElementDefinitionArray2.length) {
            int n2 = Arrays.binarySearch(iThemeElementDefinitionArray, iThemeElementDefinitionArray2[n], IThemeRegistry.ID_COMPARATOR);
            if (n2 >= 0) {
                iThemeElementDefinitionArray[n2] = this.overlay(iThemeElementDefinitionArray[n2], iThemeElementDefinitionArray2[n]);
            }
            ++n;
        }
        return iThemeElementDefinitionArray;
    }

    private IThemeElementDefinition overlay(IThemeElementDefinition iThemeElementDefinition, IThemeElementDefinition iThemeElementDefinition2) {
        if (iThemeElementDefinition instanceof ColorDefinition) {
            ColorDefinition colorDefinition = (ColorDefinition)iThemeElementDefinition;
            ColorDefinition colorDefinition2 = (ColorDefinition)iThemeElementDefinition2;
            return new ColorDefinition(colorDefinition, colorDefinition2.getValue());
        }
        if (iThemeElementDefinition instanceof FontDefinition) {
            FontDefinition fontDefinition = (FontDefinition)iThemeElementDefinition;
            FontDefinition fontDefinition2 = (FontDefinition)iThemeElementDefinition2;
            return new FontDefinition(fontDefinition, fontDefinition2.getValue());
        }
        return null;
    }

    void add(FontDefinition fontDefinition) {
        if (this.findFont(fontDefinition.getId()) != null) {
            return;
        }
        this.fonts.add(fontDefinition);
    }

    @Override
    public FontDefinition[] getFonts() {
        int n = this.fonts.size();
        FontDefinition[] fontDefinitionArray = new FontDefinition[n];
        this.fonts.toArray(fontDefinitionArray);
        Arrays.sort(fontDefinitionArray, ID_COMPARATOR);
        return fontDefinitionArray;
    }

    @Override
    public FontDefinition findFont(String string) {
        return (FontDefinition)this.findDescriptor(this.getFonts(), string);
    }

    void add(ThemeElementCategory themeElementCategory) {
        if (this.findCategory(themeElementCategory.getId()) != null) {
            return;
        }
        this.categories.add(themeElementCategory);
    }

    @Override
    public ThemeElementCategory[] getCategories() {
        int n = this.categories.size();
        ThemeElementCategory[] themeElementCategoryArray = new ThemeElementCategory[n];
        this.categories.toArray(themeElementCategoryArray);
        Arrays.sort(themeElementCategoryArray, ID_COMPARATOR);
        return themeElementCategoryArray;
    }

    void setData(String string, String string2) {
        if (this.dataMap.containsKey(string)) {
            return;
        }
        this.dataMap.put(string, string2);
    }

    @Override
    public Map getData() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    public void addData(Map map) {
        for (Object k : map.keySet()) {
            if (this.dataMap.containsKey(k)) continue;
            this.dataMap.put(k, map.get(k));
        }
    }

    public void addCategoryPresentationBinding(String string, String string2) {
        HashSet<String> hashSet = (HashSet<String>)this.categoryBindingMap.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.categoryBindingMap.put(string, hashSet);
        }
        hashSet.add(string2);
    }

    @Override
    public Set getPresentationsBindingsFor(ThemeElementCategory themeElementCategory) {
        return (Set)this.categoryBindingMap.get(themeElementCategory.getId());
    }
}

