/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.Theme;
import org.eclipse.ui.themes.ITheme;

public final class ThemeElementHelper {
    public static void populateRegistry(ITheme iTheme, FontDefinition[] fontDefinitionArray, IPreferenceStore iPreferenceStore) {
        FontDefinition[] fontDefinitionArray2 = null;
        FontDefinition[] fontDefinitionArray3 = null;
        if (!iTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            fontDefinitionArray = ThemeElementHelper.addDefaulted(fontDefinitionArray);
            if (iPreferenceStore != null) {
                fontDefinitionArray3 = ThemeElementHelper.getDefaults(fontDefinitionArray);
            }
        }
        fontDefinitionArray2 = new FontDefinition[fontDefinitionArray.length];
        System.arraycopy(fontDefinitionArray, 0, fontDefinitionArray2, 0, fontDefinitionArray.length);
        Arrays.sort(fontDefinitionArray2, new IThemeRegistry.HierarchyComparator(fontDefinitionArray));
        int n = 0;
        while (n < fontDefinitionArray2.length) {
            FontDefinition fontDefinition = fontDefinitionArray2[n];
            ThemeElementHelper.installFont(fontDefinition, iTheme, iPreferenceStore, true);
            ++n;
        }
        if (fontDefinitionArray3 != null) {
            n = 0;
            while (n < fontDefinitionArray3.length) {
                ThemeElementHelper.installFont(fontDefinitionArray3[n], iTheme, iPreferenceStore, false);
                ++n;
            }
        }
    }

    private static FontDefinition[] addDefaulted(FontDefinition[] fontDefinitionArray) {
        IThemeRegistry iThemeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = iThemeRegistry.getFonts();
        SortedSet sortedSet = ThemeElementHelper.addDefaulted(fontDefinitionArray, iHierarchalThemeElementDefinitionArray);
        return sortedSet.toArray(new FontDefinition[sortedSet.size()]);
    }

    private static void installFont(FontDefinition fontDefinition, ITheme iTheme, IPreferenceStore iPreferenceStore, boolean bl) {
        FontRegistry fontRegistry = iTheme.getFontRegistry();
        String string = fontDefinition.getId();
        String string2 = ThemeElementHelper.createPreferenceKey(iTheme, string);
        FontData[] fontDataArray = iPreferenceStore != null ? PreferenceConverter.getFontDataArray((IPreferenceStore)iPreferenceStore, (String)string2) : null;
        FontData[] fontDataArray2 = null;
        if (fontDefinition.getValue() != null) {
            fontDataArray2 = fontDefinition.getValue();
        } else if (fontDefinition.getDefaultsTo() != null) {
            fontDataArray2 = fontRegistry.filterData(fontRegistry.getFontData(fontDefinition.getDefaultsTo()), PlatformUI.getWorkbench().getDisplay());
        } else {
            Display display = PlatformUI.getWorkbench().getDisplay();
            FontData[] fontDataArray3 = JFaceResources.getFontRegistry().getFontData(display.getHighContrast() ? "org.eclipse.jface.defaultfont" : string);
            fontDataArray2 = fontRegistry.bestDataArray(fontDataArray3, display);
        }
        if (bl) {
            if (fontDataArray == null || fontDataArray == PreferenceConverter.FONTDATA_ARRAY_DEFAULT_DEFAULT) {
                fontDataArray = fontDataArray2;
            }
            if (fontDataArray != null) {
                fontRegistry.put(string, fontDataArray);
            }
        }
        if (fontDataArray2 != null && iPreferenceStore != null) {
            PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)string2, (FontData[])fontDataArray2);
        }
    }

    public static void populateRegistry(ITheme iTheme, ColorDefinition[] colorDefinitionArray, IPreferenceStore iPreferenceStore) {
        ColorDefinition[] colorDefinitionArray2 = null;
        ColorDefinition[] colorDefinitionArray3 = null;
        if (!iTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            colorDefinitionArray = ThemeElementHelper.addDefaulted(colorDefinitionArray);
            if (iPreferenceStore != null) {
                colorDefinitionArray3 = ThemeElementHelper.getDefaults(colorDefinitionArray);
            }
        }
        colorDefinitionArray2 = new ColorDefinition[colorDefinitionArray.length];
        System.arraycopy(colorDefinitionArray, 0, colorDefinitionArray2, 0, colorDefinitionArray.length);
        Arrays.sort(colorDefinitionArray2, new IThemeRegistry.HierarchyComparator(colorDefinitionArray));
        int n = 0;
        while (n < colorDefinitionArray2.length) {
            ColorDefinition colorDefinition = colorDefinitionArray2[n];
            ThemeElementHelper.installColor(colorDefinition, iTheme, iPreferenceStore, true);
            ++n;
        }
        if (colorDefinitionArray3 != null) {
            n = 0;
            while (n < colorDefinitionArray3.length) {
                ThemeElementHelper.installColor(colorDefinitionArray3[n], iTheme, iPreferenceStore, false);
                ++n;
            }
        }
    }

    private static ColorDefinition[] getDefaults(ColorDefinition[] colorDefinitionArray) {
        IThemeRegistry iThemeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        ColorDefinition[] colorDefinitionArray2 = iThemeRegistry.getColors();
        TreeSet<ColorDefinition> treeSet = new TreeSet<ColorDefinition>(IThemeRegistry.ID_COMPARATOR);
        treeSet.addAll(Arrays.asList(colorDefinitionArray2));
        treeSet.removeAll(Arrays.asList(colorDefinitionArray));
        return treeSet.toArray(new ColorDefinition[treeSet.size()]);
    }

    private static FontDefinition[] getDefaults(FontDefinition[] fontDefinitionArray) {
        IThemeRegistry iThemeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        FontDefinition[] fontDefinitionArray2 = iThemeRegistry.getFonts();
        TreeSet<FontDefinition> treeSet = new TreeSet<FontDefinition>(IThemeRegistry.ID_COMPARATOR);
        treeSet.addAll(Arrays.asList(fontDefinitionArray2));
        treeSet.removeAll(Arrays.asList(fontDefinitionArray));
        return treeSet.toArray(new FontDefinition[treeSet.size()]);
    }

    private static ColorDefinition[] addDefaulted(ColorDefinition[] colorDefinitionArray) {
        IThemeRegistry iThemeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = iThemeRegistry.getColors();
        SortedSet sortedSet = ThemeElementHelper.addDefaulted(colorDefinitionArray, iHierarchalThemeElementDefinitionArray);
        return sortedSet.toArray(new ColorDefinition[sortedSet.size()]);
    }

    private static SortedSet addDefaulted(IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray, IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray2) {
        TreeSet<IHierarchalThemeElementDefinition> treeSet = new TreeSet<IHierarchalThemeElementDefinition>(IThemeRegistry.ID_COMPARATOR);
        treeSet.addAll(Arrays.asList(iHierarchalThemeElementDefinitionArray));
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray3 = new IHierarchalThemeElementDefinition[iHierarchalThemeElementDefinitionArray2.length];
        System.arraycopy(iHierarchalThemeElementDefinitionArray2, 0, iHierarchalThemeElementDefinitionArray3, 0, iHierarchalThemeElementDefinitionArray2.length);
        Arrays.sort(iHierarchalThemeElementDefinitionArray2, new IThemeRegistry.HierarchyComparator(iHierarchalThemeElementDefinitionArray3));
        int n = 0;
        while (n < iHierarchalThemeElementDefinitionArray2.length) {
            IHierarchalThemeElementDefinition iHierarchalThemeElementDefinition = iHierarchalThemeElementDefinitionArray2[n];
            if (iHierarchalThemeElementDefinition.getDefaultsTo() != null && treeSet.contains(iHierarchalThemeElementDefinition.getDefaultsTo())) {
                treeSet.add(iHierarchalThemeElementDefinition);
            }
            ++n;
        }
        return treeSet;
    }

    private static void installColor(ColorDefinition colorDefinition, ITheme iTheme, IPreferenceStore iPreferenceStore, boolean bl) {
        RGB rGB;
        RGB rGB2;
        ColorRegistry colorRegistry = iTheme.getColorRegistry();
        String string = colorDefinition.getId();
        String string2 = ThemeElementHelper.createPreferenceKey(iTheme, string);
        RGB rGB3 = iPreferenceStore != null ? PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string2) : null;
        RGB rGB4 = rGB2 = colorDefinition.getValue() != null ? colorDefinition.getValue() : colorRegistry.getRGB(colorDefinition.getDefaultsTo());
        if (rGB2 == null) {
            rGB2 = PreferenceConverter.COLOR_DEFAULT_DEFAULT;
        }
        if (rGB3 == null || rGB3 == PreferenceConverter.COLOR_DEFAULT_DEFAULT) {
            rGB3 = rGB2;
        }
        RGB rGB5 = rGB = !iPreferenceStore.isDefault(string2) ? rGB3 : rGB2;
        if (bl) {
            colorRegistry.put(string, rGB);
        }
        if (iPreferenceStore != null) {
            PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)string2, (RGB)rGB2);
        }
    }

    public static String createPreferenceKey(ITheme iTheme, String string) {
        String string2 = iTheme.getId();
        if (string2.equals("org.eclipse.ui.defaultTheme")) {
            return string;
        }
        return String.valueOf(string2) + '.' + string;
    }

    public static String[] splitPropertyName(Theme theme, String string) {
        IThemeDescriptor[] iThemeDescriptorArray = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        int n = 0;
        while (n < iThemeDescriptorArray.length) {
            IThemeDescriptor iThemeDescriptor = iThemeDescriptorArray[n];
            String string2 = iThemeDescriptor.getId();
            if (string.startsWith(String.valueOf(string2) + '.')) {
                return new String[]{string.substring(0, string2.length()), string.substring(string2.length() + 1)};
            }
            ++n;
        }
        return new String[]{"org.eclipse.ui.defaultTheme", string};
    }

    private ThemeElementHelper() {
    }
}

