/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;

public class ThemeDescriptor
implements IThemeDescriptor {
    public static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private Collection colors = new HashSet();
    private String description;
    private Collection fonts = new HashSet();
    private String id;
    private String name;
    private Map dataMap = new HashMap();

    public ThemeDescriptor(String string) {
        this.id = string;
    }

    void add(ColorDefinition colorDefinition) {
        if (this.colors.contains(colorDefinition)) {
            this.colors.remove(colorDefinition);
        }
        this.colors.add(colorDefinition);
    }

    void add(FontDefinition fontDefinition) {
        if (this.fonts.contains(fontDefinition)) {
            return;
        }
        this.fonts.add(fontDefinition);
    }

    void setData(String string, Object object) {
        if (this.dataMap.containsKey(string)) {
            return;
        }
        this.dataMap.put(string, object);
    }

    @Override
    public ColorDefinition[] getColors() {
        ColorDefinition[] colorDefinitionArray = this.colors.toArray(new ColorDefinition[this.colors.size()]);
        Arrays.sort(colorDefinitionArray, IThemeRegistry.ID_COMPARATOR);
        return colorDefinitionArray;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FontDefinition[] getFonts() {
        FontDefinition[] fontDefinitionArray = this.fonts.toArray(new FontDefinition[this.fonts.size()]);
        Arrays.sort(fontDefinitionArray, IThemeRegistry.ID_COMPARATOR);
        return fontDefinitionArray;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.getId();
        }
        return this.name;
    }

    void extractName(IConfigurationElement iConfigurationElement) {
        if (this.name == null) {
            this.name = iConfigurationElement.getAttribute(ATT_NAME);
        }
    }

    void setDescription(String string) {
        if (this.description == null) {
            this.description = string;
        }
    }

    @Override
    public Map getData() {
        return Collections.unmodifiableMap(this.dataMap);
    }
}

