/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.internal.themes.CascadingMap;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.themes.ITheme;

public class Theme
extends EventManager
implements ITheme {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(Theme.class.getName());
    private CascadingColorRegistry themeColorRegistry;
    private CascadingFontRegistry themeFontRegistry;
    private IThemeDescriptor descriptor;
    private IPropertyChangeListener themeListener;
    private CascadingMap dataMap;
    private ThemeRegistry themeRegistry = (ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry();
    private IPropertyChangeListener propertyListener;

    public Theme(IThemeDescriptor iThemeDescriptor) {
        this.descriptor = iThemeDescriptor;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iThemeDescriptor != null) {
            ITheme iTheme = iWorkbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme");
            ColorDefinition[] colorDefinitionArray = this.descriptor.getColors();
            this.themeColorRegistry = new CascadingColorRegistry(iTheme.getColorRegistry());
            if (colorDefinitionArray.length > 0) {
                ThemeElementHelper.populateRegistry((ITheme)this, colorDefinitionArray, PrefUtil.getInternalPreferenceStore());
            }
            FontDefinition[] fontDefinitionArray = this.descriptor.getFonts();
            this.themeFontRegistry = new CascadingFontRegistry(iTheme.getFontRegistry());
            if (fontDefinitionArray.length > 0) {
                ThemeElementHelper.populateRegistry((ITheme)this, fontDefinitionArray, PrefUtil.getInternalPreferenceStore());
            }
            this.dataMap = new CascadingMap(((ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry()).getData(), iThemeDescriptor.getData());
        }
        this.getColorRegistry().addListener(this.getCascadeListener());
        this.getFontRegistry().addListener(this.getCascadeListener());
        PrefUtil.getInternalPreferenceStore().addPropertyChangeListener(this.getPropertyListener());
    }

    private IPropertyChangeListener getPropertyListener() {
        if (this.propertyListener == null) {
            this.propertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String[] stringArray = ThemeElementHelper.splitPropertyName(Theme.this, propertyChangeEvent.getProperty());
                    String string = stringArray[1];
                    String string2 = stringArray[0];
                    if (string.equals("CURRENT_THEME_ID")) {
                        return;
                    }
                    try {
                        String string3 = Theme.this.getId();
                        if (Util.equals(string3, string2)) {
                            if (Theme.this.getFontRegistry().hasValueFor(string)) {
                                FontData[] fontDataArray = PreferenceConverter.basicGetFontData((String)((String)propertyChangeEvent.getNewValue()));
                                Theme.this.getFontRegistry().put(string, fontDataArray);
                                this.processDefaultsTo(string, fontDataArray);
                                return;
                            }
                            if (Theme.this.getColorRegistry().hasValueFor(string)) {
                                RGB rGB = StringConverter.asRGB((String)((String)propertyChangeEvent.getNewValue()));
                                Theme.this.getColorRegistry().put(string, rGB);
                                this.processDefaultsTo(string, rGB);
                                return;
                            }
                        }
                    }
                    catch (DataFormatException dataFormatException) {}
                }

                private void processDefaultsTo(String string, FontData[] fontDataArray) {
                    FontDefinition[] fontDefinitionArray = WorkbenchPlugin.getDefault().getThemeRegistry().getFontsFor(Theme.this.getId());
                    int n = 0;
                    while (n < fontDefinitionArray.length) {
                        IPreferenceStore iPreferenceStore;
                        String string2 = fontDefinitionArray[n].getDefaultsTo();
                        if (string2 != null && string2.equals(string) && (iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore()).isDefault(ThemeElementHelper.createPreferenceKey(Theme.this, fontDefinitionArray[n].getId()))) {
                            Theme.this.getFontRegistry().put(fontDefinitionArray[n].getId(), fontDataArray);
                            this.processDefaultsTo(fontDefinitionArray[n].getId(), fontDataArray);
                        }
                        ++n;
                    }
                }

                private void processDefaultsTo(String string, RGB rGB) {
                    ColorDefinition[] colorDefinitionArray = WorkbenchPlugin.getDefault().getThemeRegistry().getColorsFor(Theme.this.getId());
                    int n = 0;
                    while (n < colorDefinitionArray.length) {
                        IPreferenceStore iPreferenceStore;
                        String string2 = colorDefinitionArray[n].getDefaultsTo();
                        if (string2 != null && string2.equals(string) && (iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore()).isDefault(ThemeElementHelper.createPreferenceKey(Theme.this, colorDefinitionArray[n].getId()))) {
                            Theme.this.getColorRegistry().put(colorDefinitionArray[n].getId(), rGB);
                            this.processDefaultsTo(colorDefinitionArray[n].getId(), rGB);
                        }
                        ++n;
                    }
                }
            };
        }
        return this.propertyListener;
    }

    private IPropertyChangeListener getCascadeListener() {
        if (this.themeListener == null) {
            this.themeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Theme.this.firePropertyChange(propertyChangeEvent);
                }
            };
        }
        return this.themeListener;
    }

    @Override
    public ColorRegistry getColorRegistry() {
        if (this.themeColorRegistry != null) {
            return this.themeColorRegistry;
        }
        return WorkbenchThemeManager.getInstance().getDefaultThemeColorRegistry();
    }

    @Override
    public FontRegistry getFontRegistry() {
        if (this.themeFontRegistry != null) {
            return this.themeFontRegistry;
        }
        return WorkbenchThemeManager.getInstance().getDefaultThemeFontRegistry();
    }

    @Override
    public void dispose() {
        if (this.themeColorRegistry != null) {
            this.themeColorRegistry.removeListener(this.themeListener);
            this.themeColorRegistry.dispose();
        }
        if (this.themeFontRegistry != null) {
            this.themeFontRegistry.removeListener(this.themeListener);
            this.themeFontRegistry.dispose();
        }
        PrefUtil.getInternalPreferenceStore().removePropertyChangeListener(this.getPropertyListener());
    }

    @Override
    public String getId() {
        return this.descriptor == null ? "org.eclipse.ui.defaultTheme" : this.descriptor.getId();
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    @Override
    public String getLabel() {
        return this.descriptor == null ? RESOURCE_BUNDLE.getString("DefaultTheme.label") : this.descriptor.getName();
    }

    @Override
    public String getString(String string) {
        if (this.dataMap != null) {
            return (String)this.dataMap.get(string);
        }
        return (String)this.themeRegistry.getData().get(string);
    }

    @Override
    public Set keySet() {
        if (this.dataMap != null) {
            return this.dataMap.keySet();
        }
        return this.themeRegistry.getData().keySet();
    }

    @Override
    public int getInt(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public boolean getBoolean(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(this.getString(string));
    }
}

