/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.themes.ColorUtil;
import org.eclipse.ui.themes.IColorFactory;

public class RGBContrastFactory
implements IColorFactory,
IExecutableExtension {
    private String fg;
    private String bg1;
    private String bg2;

    double voltage_to_intensity_srgb(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        if (d <= 0.04045) {
            return d / 12.92;
        }
        return Math.pow((d + 0.055) / 1.055, 2.4);
    }

    double lightness(RGB rGB) {
        double d = this.voltage_to_intensity_srgb((double)rGB.red / 255.0);
        double d2 = this.voltage_to_intensity_srgb((double)rGB.green / 255.0);
        double d3 = this.voltage_to_intensity_srgb((double)rGB.blue / 255.0);
        double d4 = 0.3139 * d + 0.6395 * d2 + 0.0466 * d3;
        double d5 = 0.1516 * d + 0.7482 * d2 + 0.1 * d3;
        double d6 = 0.0177 * d + 0.1095 * d2 + 0.8729 * d3;
        double d7 = d4 < 0.0 ? -Math.pow(-d4, 0.43) : Math.pow(d4, 0.43);
        double d8 = d5 < 0.0 ? -Math.pow(-d5, 0.43) : Math.pow(d5, 0.43);
        double d9 = d6 < 0.0 ? -Math.pow(-d6, 0.43) : Math.pow(d6, 0.43);
        return 0.4 * d7 + 0.4 * d8 + 0.2 * d9;
    }

    @Override
    public RGB createColor() {
        RGB rGB = this.fg != null ? ColorUtil.getColorValue(this.fg) : new RGB(255, 255, 255);
        RGB rGB2 = this.bg1 != null ? ColorUtil.getColorValue(this.bg1) : new RGB(0, 0, 0);
        RGB rGB3 = this.bg2 != null ? ColorUtil.getColorValue(this.bg2) : new RGB(0, 0, 0);
        double d = this.lightness(rGB);
        double d2 = this.lightness(rGB2);
        double d3 = this.lightness(rGB3);
        if (Math.abs(d2 - d) > Math.abs(d3 - d)) {
            return rGB2;
        }
        return rGB3;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            this.fg = (String)hashtable.get("foreground");
            this.bg1 = (String)hashtable.get("background1");
            this.bg2 = (String)hashtable.get("background2");
        }
    }
}

