/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.themes.ColorUtil;
import org.eclipse.ui.themes.IColorFactory;

public class LightColorFactory
implements IColorFactory,
IExecutableExtension {
    protected static final RGB white = ColorUtil.getColorValue("COLOR_WHITE");
    protected static final RGB black = ColorUtil.getColorValue("COLOR_BLACK");
    String baseColorName;
    String definitionId;

    public static RGB createHighlightStartColor(RGB rGB) {
        return ColorUtil.blend(white, rGB);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            this.definitionId = (String)hashtable.get("definitionId");
            this.baseColorName = this.definitionId.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START") ? "255, 255, 255" : (this.definitionId.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END") ? "241, 241, 241" : (String)hashtable.get("base"));
        }
    }

    protected int valuesInRange(RGB rGB, int n, int n2) {
        int n3 = 0;
        if (rGB.red >= n && rGB.red <= n2) {
            ++n3;
        }
        if (rGB.blue >= n && rGB.blue <= n2) {
            ++n3;
        }
        if (rGB.green >= n && rGB.green <= n2) {
            ++n3;
        }
        return n3;
    }

    private RGB getLightenedColor(RGB rGB) {
        if (this.valuesInRange(rGB, 180, 255) >= 2) {
            return rGB;
        }
        if (this.valuesInRange(rGB, 100, 179) >= 2) {
            return ColorUtil.blend(white, rGB, 40);
        }
        if (this.valuesInRange(rGB, 0, 99) >= 2) {
            return ColorUtil.blend(white, rGB, 60);
        }
        return ColorUtil.blend(white, rGB, 30);
    }

    private RGB getActiveFocusStartColor() {
        if (Display.getCurrent().getDepth() < 15) {
            return this.getActiveFocusEndColor();
        }
        RGB rGB = ColorUtil.blend(white, this.getActiveFocusEndColor(), 75);
        return rGB;
    }

    private RGB getActiveFocusEndColor() {
        if (Display.getCurrent().getDepth() < 15) {
            return ColorUtil.getColorValue(this.baseColorName);
        }
        return this.getLightenedColor(ColorUtil.getColorValue(this.baseColorName));
    }

    private RGB getActiveFocusTextColor() {
        if (Display.getCurrent().getDepth() < 15) {
            return ColorUtil.getColorValue(this.baseColorName);
        }
        return ColorUtil.getColorValue("COLOR_BLACK");
    }

    private RGB getActiveNofocusStartColor() {
        RGB rGB = ColorUtil.getColorValue(this.baseColorName);
        if (Display.getCurrent().getDepth() < 15) {
            return rGB;
        }
        return ColorUtil.blend(white, rGB, 40);
    }

    @Override
    public RGB createColor() {
        if (this.baseColorName == null || this.definitionId == null) {
            return white;
        }
        if (this.definitionId.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START")) {
            return this.getActiveFocusStartColor();
        }
        if (this.definitionId.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END")) {
            return this.getActiveFocusEndColor();
        }
        if (this.definitionId.equals("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR")) {
            return this.getActiveFocusTextColor();
        }
        if (this.definitionId.equals("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_START")) {
            return this.getActiveNofocusStartColor();
        }
        return white;
    }
}

