/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeElementDefinition;
import org.eclipse.ui.internal.themes.ThemeElementCategory;

public interface IThemeRegistry {
    public static final Comparator ID_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            String string = this.getCompareString(object);
            String string2 = this.getCompareString(object2);
            return string.compareTo(string2);
        }

        private String getCompareString(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof IThemeElementDefinition) {
                return ((IThemeElementDefinition)object).getId();
            }
            return "";
        }
    };

    public ThemeElementCategory findCategory(String var1);

    public ColorDefinition findColor(String var1);

    public FontDefinition findFont(String var1);

    public IThemeDescriptor findTheme(String var1);

    public ThemeElementCategory[] getCategories();

    public ColorDefinition[] getColors();

    public ColorDefinition[] getColorsFor(String var1);

    public FontDefinition[] getFontsFor(String var1);

    public FontDefinition[] getFonts();

    public IThemeDescriptor[] getThemes();

    public Map getData();

    public Set getPresentationsBindingsFor(ThemeElementCategory var1);

    public static class HierarchyComparator
    implements Comparator {
        private IHierarchalThemeElementDefinition[] definitions;

        public HierarchyComparator(IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray) {
            this.definitions = iHierarchalThemeElementDefinitionArray;
        }

        public int compare(Object object, Object object2) {
            String string;
            String string2 = object == null ? null : ((IHierarchalThemeElementDefinition)object).getDefaultsTo();
            String string3 = string = object2 == null ? null : ((IHierarchalThemeElementDefinition)object2).getDefaultsTo();
            if (string2 == null && string == null) {
                return 0;
            }
            if (string2 == null) {
                return -1;
            }
            if (string == null) {
                return 1;
            }
            return this.compare(this.getDefaultsTo(string2), this.getDefaultsTo(string));
        }

        private IHierarchalThemeElementDefinition getDefaultsTo(String string) {
            int n = Arrays.binarySearch(this.definitions, string, ID_COMPARATOR);
            if (n >= 0) {
                return this.definitions[n];
            }
            return null;
        }
    }
}

