/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IEditable;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;

public class FontDefinition
implements IHierarchalThemeElementDefinition,
ICategorizedThemeElementDefinition,
IEditable {
    private String label;
    private String id;
    private String defaultsTo;
    private String categoryId;
    private String description;
    private String value;
    private boolean isEditable;
    private FontData[] parsedValue;

    public FontDefinition(String string, String string2, String string3, String string4, String string5, boolean bl, String string6) {
        this.label = string;
        this.id = string2;
        this.defaultsTo = string3;
        this.value = string4;
        this.categoryId = string5;
        this.description = string6;
        this.isEditable = bl;
    }

    public FontDefinition(FontDefinition fontDefinition, FontData[] fontDataArray) {
        this.label = fontDefinition.getName();
        this.id = fontDefinition.getId();
        this.categoryId = fontDefinition.getCategoryId();
        this.description = fontDefinition.getDescription();
        this.isEditable = fontDefinition.isEditable();
        this.parsedValue = fontDataArray;
    }

    @Override
    public String getDefaultsTo() {
        return this.defaultsTo;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.label;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCategoryId() {
        return this.categoryId;
    }

    public FontData[] getValue() {
        if (this.value == null) {
            return null;
        }
        if (this.parsedValue == null) {
            this.parsedValue = JFaceResources.getFontRegistry().filterData(StringConverter.asFontDataArray((String)this.value), PlatformUI.getWorkbench().getDisplay());
        }
        return this.parsedValue;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean equals(Object object) {
        if (object instanceof FontDefinition) {
            return this.getId().equals(((FontDefinition)object).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

