/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.internal.themes.CascadingTheme;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementCategory;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.themes.IThemePreview;

public final class ColorsAndFontsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String SELECTED_ELEMENT_PREF = "ColorsAndFontsPreferencePage.selectedElement";
    private static final String EXPANDED_ELEMENTS_PREF = "ColorsAndFontsPreferencePage.expandedCategories";
    private static final String EXPANDED_ELEMENTS_TOKEN = "\t";
    private static final char MARKER_CATEGORY = 'T';
    private static final char MARKER_COLOR = 'C';
    private static final char MARKER_FONT = 'F';
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(ColorsAndFontsPreferencePage.class.getName());
    private Map categoryMap = new HashMap(7);
    private Font appliedDialogFont;
    private Map colorPreferencesToSet = new HashMap(7);
    private CascadingColorRegistry colorRegistry;
    private Map colorValuesToSet = new HashMap(7);
    private Composite defaultColorPreview;
    private Composite defaultFontPreview;
    private Composite defaultNoPreview;
    private Font currentFont;
    private Color currentColor;
    private Canvas colorSampler;
    private Canvas fontSampler;
    private String fontSampleText;
    private List dialogFontWidgets = new ArrayList();
    private Button fontChangeButton;
    private Button editDefaultButton;
    private Button goToDefaultButton;
    private Map fontPreferencesToSet = new HashMap(7);
    private CascadingFontRegistry fontRegistry;
    private Button fontResetButton;
    private Button fontSystemButton;
    private Map fontValuesToSet = new HashMap(7);
    private Composite previewComposite;
    private Map previewMap = new HashMap(7);
    private Set previewSet = new HashSet(7);
    private StackLayout stackLayout;
    private final IThemeRegistry themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
    private ITheme currentTheme;
    private PresentationLabelProvider labelProvider;
    private CascadingTheme cascadingTheme;
    private IPropertyChangeListener themeChangeListener;
    private Workbench workbench;
    private FilteredTree tree;
    private Text descriptionText;

    public void applyData(Object object) {
        String string;
        ColorDefinition colorDefinition;
        if (this.tree == null || !(object instanceof String)) {
            return;
        }
        ThemeRegistry themeRegistry = (ThemeRegistry)this.tree.getViewer().getInput();
        String string2 = (String)object;
        if (string2.startsWith("selectCategory:")) {
            String string3 = string2.substring(15);
            ThemeElementCategory themeElementCategory = themeRegistry.findCategory(string3);
            if (themeElementCategory != null) {
                this.selectAndReveal(themeElementCategory);
                this.tree.getViewer().expandToLevel((Object)themeElementCategory, 1);
            }
        } else if (string2.startsWith("selectFont:")) {
            String string4 = string2.substring(11);
            FontDefinition fontDefinition = themeRegistry.findFont(string4);
            if (fontDefinition != null) {
                this.selectAndReveal(fontDefinition);
            }
        } else if (string2.startsWith("selectColor:") && (colorDefinition = themeRegistry.findColor(string = string2.substring(12))) != null) {
            this.selectAndReveal(colorDefinition);
        }
    }

    private void selectAndReveal(Object object) {
        TreeViewer treeViewer = this.tree.getViewer();
        treeViewer.setSelection((ISelection)new StructuredSelection(object), false);
        treeViewer.reveal(object);
        treeViewer.getTree().setFocus();
    }

    private static boolean equals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private Button createButton(Composite composite, String string) {
        Button button = new Button(composite, 0x1000008);
        button.setText(string);
        this.myApplyDialogFont((Control)button);
        this.setButtonLayoutData(button);
        button.setEnabled(false);
        return button;
    }

    private Label createSeparator(Composite composite) {
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.font_preference_page_context");
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ColorsAndFontsPreferencePage.this.appliedDialogFont != null) {
                    ColorsAndFontsPreferencePage.this.appliedDialogFont.dispose();
                }
            }
        });
        SashForm sashForm = new SashForm(composite, 512);
        GridData gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 2;
        Label label = new Label(composite2, 16384);
        label.setText(RESOURCE_BUNDLE.getString("colorsAndFonts"));
        this.myApplyDialogFont((Control)label);
        label.setLayoutData((Object)gridData2);
        this.createTree(composite2);
        Composite composite3 = new Composite(composite2, 0);
        gridData2 = new GridData(1040);
        composite3.setLayoutData((Object)gridData2);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        Label label2 = new Label(composite3, 0);
        GridData gridData3 = new GridData(128);
        gridData3.heightHint = this.convertVerticalDLUsToPixels(12);
        label2.setLayoutData((Object)gridData3);
        this.fontChangeButton = this.createButton(composite3, RESOURCE_BUNDLE.getString("openChange"));
        this.fontSystemButton = this.createButton(composite3, WorkbenchMessages.FontsPreference_useSystemFont);
        this.fontResetButton = this.createButton(composite3, RESOURCE_BUNDLE.getString("reset"));
        this.createSeparator(composite3);
        this.editDefaultButton = this.createButton(composite3, RESOURCE_BUNDLE.getString("editDefault"));
        this.goToDefaultButton = this.createButton(composite3, RESOURCE_BUNDLE.getString("goToDefault"));
        this.createDescriptionControl(composite2);
        Composite composite4 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginTop = 7;
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        composite4.setFont(composite.getFont());
        composite4.setLayout((Layout)gridLayout2);
        Composite composite5 = new Composite(composite4, 0);
        GridData gridData4 = new GridData(1808);
        composite5.setLayoutData((Object)gridData4);
        GridLayout gridLayout3 = new GridLayout(1, true);
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        composite5.setLayout((Layout)gridLayout3);
        Label label3 = new Label(composite5, 16384);
        label3.setText(RESOURCE_BUNDLE.getString("preview"));
        this.myApplyDialogFont((Control)label3);
        this.previewComposite = new Composite(composite5, 0);
        this.previewComposite.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.previewComposite.setLayout((Layout)this.stackLayout);
        this.defaultFontPreview = this.createFontPreviewControl();
        this.defaultColorPreview = this.createColorPreviewControl();
        this.defaultNoPreview = this.createNoPreviewControl();
        this.hookListeners();
        this.updateTreeSelection(this.tree.getViewer().getSelection());
        sashForm.setWeights(new int[]{75, 25});
        return sashForm;
    }

    private void createTree(Composite composite) {
        this.labelProvider = new PresentationLabelProvider();
        PatternFilter patternFilter = new PatternFilter(){

            @Override
            protected boolean isLeafMatch(Viewer viewer, Object object) {
                if (super.isLeafMatch(viewer, object)) {
                    return true;
                }
                String string = null;
                if (object instanceof ICategorizedThemeElementDefinition) {
                    string = ((ICategorizedThemeElementDefinition)object).getDescription();
                }
                return string != null ? this.wordMatches(string) : false;
            }
        };
        patternFilter.setIncludeLeadingWildcard(true);
        this.tree = new FilteredTree(composite, 2820, patternFilter, true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = Math.max(285, this.convertWidthInCharsToPixels(30));
        gridData.heightHint = Math.max(175, this.convertHeightInCharsToPixels(10));
        this.tree.setLayoutData(gridData);
        this.myApplyDialogFont(this.tree.getViewer().getControl());
        Text text = this.tree.getFilterControl();
        if (text != null) {
            this.myApplyDialogFont((Control)text);
        }
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tree.getViewer().setContentProvider((IContentProvider)new ThemeContentProvider());
        this.tree.getViewer().setComparator(new ViewerComparator(){

            public int category(Object object) {
                if (object instanceof ThemeElementCategory) {
                    return 0;
                }
                return 1;
            }
        });
        this.tree.getViewer().setInput((Object)WorkbenchPlugin.getDefault().getThemeRegistry());
        this.tree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if (ColorsAndFontsPreferencePage.this.tree.getViewer().isExpandable(object)) {
                    ColorsAndFontsPreferencePage.this.tree.getViewer().setExpandedState(object, !ColorsAndFontsPreferencePage.this.tree.getViewer().getExpandedState(object));
                }
                if (object instanceof FontDefinition) {
                    ColorsAndFontsPreferencePage.this.editFont(ColorsAndFontsPreferencePage.this.tree.getDisplay());
                } else if (object instanceof ColorDefinition) {
                    ColorsAndFontsPreferencePage.this.editColor(ColorsAndFontsPreferencePage.this.tree.getDisplay());
                }
                ColorsAndFontsPreferencePage.this.updateControls();
            }
        });
        this.restoreTreeExpansion();
        this.restoreTreeSelection();
    }

    public void dispose() {
        super.dispose();
        this.workbench.getThemeManager().removePropertyChangeListener(this.themeChangeListener);
        this.clearPreviews();
        this.colorRegistry.dispose();
        this.fontRegistry.dispose();
    }

    private void clearPreviews() {
        if (this.cascadingTheme != null) {
            this.cascadingTheme.dispose();
        }
        for (IThemePreview iThemePreview : this.previewSet) {
            try {
                iThemePreview.dispose();
            }
            catch (RuntimeException runtimeException) {
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("errorDisposePreviewLog"), StatusUtil.newStatus(4, runtimeException.getMessage(), (Throwable)runtimeException));
            }
        }
        this.previewSet.clear();
    }

    private ColorDefinition getColorAncestor(ColorDefinition colorDefinition) {
        String string = colorDefinition.getDefaultsTo();
        if (string == null) {
            return null;
        }
        return this.themeRegistry.findColor(string);
    }

    private RGB getColorAncestorValue(ColorDefinition colorDefinition) {
        ColorDefinition colorDefinition2 = this.getColorAncestor(colorDefinition);
        if (colorDefinition2 == null) {
            return null;
        }
        return this.getColorValue(colorDefinition2);
    }

    private RGB getColorValue(ColorDefinition colorDefinition) {
        String string = colorDefinition.getId();
        RGB rGB = (RGB)this.colorPreferencesToSet.get(string);
        if (rGB == null && (rGB = (RGB)this.colorValuesToSet.get(string)) == null) {
            rGB = this.currentTheme.getColorRegistry().getRGB(string);
        }
        return rGB;
    }

    private ColorDefinition[] getDescendantColors(ColorDefinition colorDefinition) {
        ArrayList<ColorDefinition> arrayList = new ArrayList<ColorDefinition>(5);
        String string = colorDefinition.getId();
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = this.themeRegistry.getColors();
        ColorDefinition[] colorDefinitionArray = new ColorDefinition[iHierarchalThemeElementDefinitionArray.length];
        System.arraycopy(iHierarchalThemeElementDefinitionArray, 0, colorDefinitionArray, 0, colorDefinitionArray.length);
        Arrays.sort(colorDefinitionArray, new IThemeRegistry.HierarchyComparator(iHierarchalThemeElementDefinitionArray));
        int n = 0;
        while (n < colorDefinitionArray.length) {
            if (string.equals(colorDefinitionArray[n].getDefaultsTo())) {
                arrayList.add(colorDefinitionArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ColorDefinition[arrayList.size()]);
    }

    private FontDefinition[] getDescendantFonts(FontDefinition fontDefinition) {
        ArrayList<FontDefinition> arrayList = new ArrayList<FontDefinition>(5);
        String string = fontDefinition.getId();
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = this.themeRegistry.getFonts();
        FontDefinition[] fontDefinitionArray = new FontDefinition[iHierarchalThemeElementDefinitionArray.length];
        System.arraycopy(iHierarchalThemeElementDefinitionArray, 0, fontDefinitionArray, 0, fontDefinitionArray.length);
        Arrays.sort(fontDefinitionArray, new IThemeRegistry.HierarchyComparator(iHierarchalThemeElementDefinitionArray));
        int n = 0;
        while (n < fontDefinitionArray.length) {
            if (string.equals(fontDefinitionArray[n].getDefaultsTo())) {
                arrayList.add(fontDefinitionArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new FontDefinition[arrayList.size()]);
    }

    private FontDefinition getFontAncestor(FontDefinition fontDefinition) {
        String string = fontDefinition.getDefaultsTo();
        if (string == null) {
            return null;
        }
        return this.themeRegistry.findFont(string);
    }

    private FontData[] getFontAncestorValue(FontDefinition fontDefinition) {
        FontDefinition fontDefinition2 = this.getFontAncestor(fontDefinition);
        if (fontDefinition2 == null) {
            return PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)ThemeElementHelper.createPreferenceKey(this.currentTheme, fontDefinition.getId()));
        }
        return this.getFontValue(fontDefinition2);
    }

    protected FontData[] getFontValue(FontDefinition fontDefinition) {
        String string = fontDefinition.getId();
        FontData[] fontDataArray = (FontData[])this.fontPreferencesToSet.get(string);
        if (fontDataArray == null && (fontDataArray = (FontData[])this.fontValuesToSet.get(string)) == null) {
            fontDataArray = this.currentTheme.getFontRegistry().getFontData(string);
        }
        return fontDataArray;
    }

    protected ColorDefinition getSelectedColorDefinition() {
        Object object = ((IStructuredSelection)this.tree.getViewer().getSelection()).getFirstElement();
        if (object instanceof ColorDefinition) {
            return (ColorDefinition)object;
        }
        return null;
    }

    protected FontDefinition getSelectedFontDefinition() {
        Object object = ((IStructuredSelection)this.tree.getViewer().getSelection()).getFirstElement();
        if (object instanceof FontDefinition) {
            return (FontDefinition)object;
        }
        return null;
    }

    protected boolean isFontSelected() {
        Object object = ((IStructuredSelection)this.tree.getViewer().getSelection()).getFirstElement();
        return object instanceof FontDefinition;
    }

    protected boolean isColorSelected() {
        Object object = ((IStructuredSelection)this.tree.getViewer().getSelection()).getFirstElement();
        return object instanceof ColorDefinition;
    }

    private void hookListeners() {
        TreeViewer treeViewer = this.tree.getViewer();
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ColorsAndFontsPreferencePage.this.updateTreeSelection(selectionChangedEvent.getSelection());
            }
        });
        this.fontChangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Display display = selectionEvent.display;
                if (ColorsAndFontsPreferencePage.this.isFontSelected()) {
                    ColorsAndFontsPreferencePage.this.editFont(display);
                } else if (ColorsAndFontsPreferencePage.this.isColorSelected()) {
                    ColorsAndFontsPreferencePage.this.editColor(display);
                }
                ColorsAndFontsPreferencePage.this.updateControls();
            }
        });
        this.fontResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ColorsAndFontsPreferencePage.this.isFontSelected()) {
                    ColorsAndFontsPreferencePage.this.resetFont(ColorsAndFontsPreferencePage.this.getSelectedFontDefinition(), false);
                } else if (ColorsAndFontsPreferencePage.this.isColorSelected()) {
                    ColorsAndFontsPreferencePage.this.resetColor(ColorsAndFontsPreferencePage.this.getSelectedColorDefinition(), false);
                }
                ColorsAndFontsPreferencePage.this.updateControls();
            }
        });
        this.fontSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontDefinition fontDefinition = ColorsAndFontsPreferencePage.this.getSelectedFontDefinition();
                if (fontDefinition == null) {
                    return;
                }
                FontData[] fontDataArray = JFaceResources.getDefaultFont().getFontData();
                ColorsAndFontsPreferencePage.this.setFontPreferenceValue(fontDefinition, fontDataArray);
                ColorsAndFontsPreferencePage.this.updateControls();
            }
        });
        this.editDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Display display = selectionEvent.display;
                FontDefinition fontDefinition = ColorsAndFontsPreferencePage.this.getSelectedFontDefinition();
                if (fontDefinition != null) {
                    String string = fontDefinition.getDefaultsTo();
                    FontDefinition fontDefinition2 = ColorsAndFontsPreferencePage.this.themeRegistry.findFont(string);
                    ColorsAndFontsPreferencePage.this.editFont(fontDefinition2, display);
                } else {
                    ColorDefinition colorDefinition = ColorsAndFontsPreferencePage.this.getSelectedColorDefinition();
                    if (colorDefinition != null) {
                        String string = colorDefinition.getDefaultsTo();
                        ColorDefinition colorDefinition2 = ColorsAndFontsPreferencePage.this.themeRegistry.findColor(string);
                        ColorsAndFontsPreferencePage.this.editColor(colorDefinition2, display);
                    }
                }
                ColorsAndFontsPreferencePage.this.updateControls();
            }
        });
        this.goToDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FontDefinition fontDefinition = ColorsAndFontsPreferencePage.this.getSelectedFontDefinition();
                if (fontDefinition != null) {
                    String string = fontDefinition.getDefaultsTo();
                    FontDefinition fontDefinition2 = ColorsAndFontsPreferencePage.this.themeRegistry.findFont(string);
                    ColorsAndFontsPreferencePage.this.selectAndReveal(fontDefinition2);
                } else {
                    ColorDefinition colorDefinition = ColorsAndFontsPreferencePage.this.getSelectedColorDefinition();
                    if (colorDefinition != null) {
                        String string = colorDefinition.getDefaultsTo();
                        ColorDefinition colorDefinition2 = ColorsAndFontsPreferencePage.this.themeRegistry.findColor(string);
                        ColorsAndFontsPreferencePage.this.selectAndReveal(colorDefinition2);
                    }
                }
                ColorsAndFontsPreferencePage.this.updateControls();
            }
        });
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.workbench = (Workbench)iWorkbench;
        this.setPreferenceStore(PrefUtil.getInternalPreferenceStore());
        final IThemeManager iThemeManager = iWorkbench.getThemeManager();
        this.themeChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("CHANGE_CURRENT_THEME")) {
                    ColorsAndFontsPreferencePage.this.updateThemeInfo(iThemeManager);
                    ColorsAndFontsPreferencePage.this.refreshCategory();
                    ColorsAndFontsPreferencePage.this.tree.getViewer().refresh();
                }
            }
        };
        iThemeManager.addPropertyChangeListener(this.themeChangeListener);
        this.updateThemeInfo(iThemeManager);
    }

    private void updateThemeInfo(IThemeManager iThemeManager) {
        this.clearPreviews();
        this.categoryMap.clear();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.colorRegistry != null) {
            this.colorRegistry.dispose();
        }
        if (this.fontRegistry != null) {
            this.fontRegistry.dispose();
        }
        this.currentTheme = iThemeManager.getCurrentTheme();
        this.colorRegistry = new CascadingColorRegistry(this.currentTheme.getColorRegistry());
        this.fontRegistry = new CascadingFontRegistry(this.currentTheme.getFontRegistry());
        this.fontPreferencesToSet.clear();
        this.fontValuesToSet.clear();
        this.colorPreferencesToSet.clear();
        this.colorValuesToSet.clear();
        if (this.labelProvider != null) {
            this.labelProvider.hookListeners();
        }
    }

    private boolean isDefault(ColorDefinition colorDefinition) {
        String string = colorDefinition.getId();
        return this.colorPreferencesToSet.containsKey(string) ? (colorDefinition.getValue() != null ? this.colorPreferencesToSet.get(string).equals(colorDefinition.getValue()) : this.colorPreferencesToSet.get(string).equals(this.getColorAncestorValue(colorDefinition))) : (this.colorValuesToSet.containsKey(string) ? (colorDefinition.getValue() != null ? this.colorValuesToSet.get(string).equals(colorDefinition.getValue()) : this.colorValuesToSet.get(string).equals(this.getColorAncestorValue(colorDefinition))) : (colorDefinition.getValue() != null ? this.getPreferenceStore().isDefault(ThemeElementHelper.createPreferenceKey(this.currentTheme, string)) : this.getColorValue(colorDefinition).equals((Object)this.getColorAncestorValue(colorDefinition))));
    }

    private boolean isDefault(FontDefinition fontDefinition) {
        String string = fontDefinition.getId();
        if (this.fontPreferencesToSet.containsKey(string)) {
            if (fontDefinition.getValue() != null) {
                if (Arrays.equals((FontData[])this.fontPreferencesToSet.get(string), fontDefinition.getValue())) {
                    return true;
                }
            } else {
                Object[] objectArray = this.getFontAncestorValue(fontDefinition);
                if (Arrays.equals((FontData[])this.fontPreferencesToSet.get(string), objectArray)) {
                    return true;
                }
            }
        } else if (this.fontValuesToSet.containsKey(string)) {
            if (fontDefinition.getValue() != null) {
                if (Arrays.equals((FontData[])this.fontValuesToSet.get(string), fontDefinition.getValue())) {
                    return true;
                }
            } else {
                Object[] objectArray = this.getFontAncestorValue(fontDefinition);
                if (Arrays.equals((FontData[])this.fontValuesToSet.get(string), objectArray)) {
                    return true;
                }
            }
        } else if (fontDefinition.getValue() != null) {
            if (this.getPreferenceStore().isDefault(ThemeElementHelper.createPreferenceKey(this.currentTheme, string))) {
                return true;
            }
        } else {
            Object[] objectArray = this.getFontAncestorValue(fontDefinition);
            if (objectArray == null) {
                return true;
            }
            if (Arrays.equals(this.getFontValue(fontDefinition), objectArray)) {
                return true;
            }
        }
        return false;
    }

    private void myApplyDialogFont(Control control) {
        control.setFont(JFaceResources.getDialogFont());
        this.dialogFontWidgets.add(control);
    }

    protected void performApply() {
        super.performApply();
        Font font = this.appliedDialogFont;
        FontDefinition fontDefinition = this.themeRegistry.findFont("org.eclipse.jface.dialogfont");
        if (fontDefinition == null) {
            return;
        }
        FontData[] fontDataArray = this.getFontValue(fontDefinition);
        this.appliedDialogFont = new Font((Device)this.getControl().getDisplay(), fontDataArray);
        this.updateForDialogFontChange(this.appliedDialogFont);
        this.getApplyButton().setFont(this.appliedDialogFont);
        this.getDefaultsButton().setFont(this.appliedDialogFont);
        if (font != null) {
            font.dispose();
        }
    }

    private void performColorDefaults() {
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = this.themeRegistry.getColors();
        ColorDefinition[] colorDefinitionArray = new ColorDefinition[iHierarchalThemeElementDefinitionArray.length];
        System.arraycopy(iHierarchalThemeElementDefinitionArray, 0, colorDefinitionArray, 0, iHierarchalThemeElementDefinitionArray.length);
        Arrays.sort(colorDefinitionArray, new IThemeRegistry.HierarchyComparator(iHierarchalThemeElementDefinitionArray));
        int n = 0;
        while (n < colorDefinitionArray.length) {
            this.resetColor(colorDefinitionArray[n], true);
            ++n;
        }
    }

    private boolean performColorOk() {
        for (String string : this.colorPreferencesToSet.keySet()) {
            String string2;
            String string3 = ThemeElementHelper.createPreferenceKey(this.currentTheme, string);
            RGB rGB = (RGB)this.colorPreferencesToSet.get(string);
            String string4 = StringConverter.asString((RGB)rGB);
            if (string4.equals(string2 = this.getPreferenceStore().getString(string3))) continue;
            this.getPreferenceStore().setValue(string3, string4);
        }
        this.colorValuesToSet.clear();
        this.colorPreferencesToSet.clear();
        return true;
    }

    protected void performDefaults() {
        this.performColorDefaults();
        this.performFontDefaults();
        this.updateControls();
        this.tree.getViewer().refresh();
    }

    private void performFontDefaults() {
        IHierarchalThemeElementDefinition[] iHierarchalThemeElementDefinitionArray = this.themeRegistry.getFonts();
        FontDefinition[] fontDefinitionArray = new FontDefinition[iHierarchalThemeElementDefinitionArray.length];
        System.arraycopy(iHierarchalThemeElementDefinitionArray, 0, fontDefinitionArray, 0, iHierarchalThemeElementDefinitionArray.length);
        Arrays.sort(fontDefinitionArray, new IThemeRegistry.HierarchyComparator(iHierarchalThemeElementDefinitionArray));
        int n = 0;
        while (n < fontDefinitionArray.length) {
            this.resetFont(fontDefinitionArray[n], true);
            ++n;
        }
    }

    private boolean performFontOk() {
        for (String string : this.fontPreferencesToSet.keySet()) {
            String string2;
            String string3 = ThemeElementHelper.createPreferenceKey(this.currentTheme, string);
            FontData[] fontDataArray = (FontData[])this.fontPreferencesToSet.get(string);
            String string4 = PreferenceConverter.getStoredRepresentation((FontData[])fontDataArray);
            if (string4.equals(string2 = this.getPreferenceStore().getString(string3))) continue;
            this.getPreferenceStore().setValue(string3, string4);
        }
        this.fontValuesToSet.clear();
        this.fontPreferencesToSet.clear();
        return true;
    }

    public void performHelp() {
        Program.launch((String)"http://www.deltawalker.com/preferences/general-colors-fonts.jsp");
    }

    public boolean performOk() {
        boolean bl;
        this.saveTreeExpansion();
        this.saveTreeSelection();
        boolean bl2 = bl = this.performColorOk() && this.performFontOk();
        if (bl) {
            PrefUtil.savePrefs();
        }
        return bl;
    }

    private void refreshCategory() {
        this.updateControls();
    }

    private boolean resetColor(ColorDefinition colorDefinition, boolean bl) {
        RGB rGB;
        if ((bl || !this.isDefault(colorDefinition)) && (rGB = colorDefinition.getValue() != null ? colorDefinition.getValue() : this.getColorAncestorValue(colorDefinition)) != null) {
            this.setColorPreferenceValue(colorDefinition, rGB);
            this.setRegistryValue(colorDefinition, rGB);
            return true;
        }
        return false;
    }

    protected boolean resetFont(FontDefinition fontDefinition, boolean bl) {
        FontData[] fontDataArray;
        if ((bl || !this.isDefault(fontDefinition)) && (fontDataArray = !bl && fontDefinition.getDefaultsTo() != null ? this.getFontAncestorValue(fontDefinition) : PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)ThemeElementHelper.createPreferenceKey(this.currentTheme, fontDefinition.getId()))) != null) {
            this.setFontPreferenceValue(fontDefinition, fontDataArray);
            return true;
        }
        return false;
    }

    protected void setColorPreferenceValue(ColorDefinition colorDefinition, RGB rGB) {
        this.setDescendantRegistryValues(colorDefinition, rGB);
        this.colorPreferencesToSet.put(colorDefinition.getId(), rGB);
    }

    private void setDescendantRegistryValues(ColorDefinition colorDefinition, RGB rGB) {
        ColorDefinition[] colorDefinitionArray = this.getDescendantColors(colorDefinition);
        int n = 0;
        while (n < colorDefinitionArray.length) {
            if (this.isDefault(colorDefinitionArray[n])) {
                this.setDescendantRegistryValues(colorDefinitionArray[n], rGB);
                this.setRegistryValue(colorDefinitionArray[n], rGB);
                this.colorValuesToSet.put(colorDefinitionArray[n].getId(), rGB);
            }
            ++n;
        }
    }

    private void setDescendantRegistryValues(FontDefinition fontDefinition, FontData[] fontDataArray) {
        FontDefinition[] fontDefinitionArray = this.getDescendantFonts(fontDefinition);
        int n = 0;
        while (n < fontDefinitionArray.length) {
            if (this.isDefault(fontDefinitionArray[n])) {
                this.setDescendantRegistryValues(fontDefinitionArray[n], fontDataArray);
                this.setRegistryValue(fontDefinitionArray[n], fontDataArray);
                this.fontValuesToSet.put(fontDefinitionArray[n].getId(), fontDataArray);
                this.fontPreferencesToSet.remove(fontDefinitionArray[n].getId());
            }
            ++n;
        }
    }

    protected void setFontPreferenceValue(FontDefinition fontDefinition, FontData[] fontDataArray) {
        this.setDescendantRegistryValues(fontDefinition, fontDataArray);
        this.fontPreferencesToSet.put(fontDefinition.getId(), fontDataArray);
        this.setRegistryValue(fontDefinition, fontDataArray);
    }

    protected void setRegistryValue(ColorDefinition colorDefinition, RGB rGB) {
        this.colorRegistry.put(colorDefinition.getId(), rGB);
    }

    protected void setRegistryValue(FontDefinition fontDefinition, FontData[] fontDataArray) {
        this.fontRegistry.put(fontDefinition.getId(), fontDataArray);
    }

    private IThemePreview getThemePreview(ThemeElementCategory themeElementCategory) throws CoreException {
        int n;
        IThemePreview iThemePreview = themeElementCategory.createPreview();
        if (iThemePreview != null) {
            return iThemePreview;
        }
        if (themeElementCategory.getParentId() != null && (n = Arrays.binarySearch(this.themeRegistry.getCategories(), themeElementCategory.getParentId(), IThemeRegistry.ID_COMPARATOR)) >= 0) {
            return this.getThemePreview(this.themeRegistry.getCategories()[n]);
        }
        return null;
    }

    private ITheme getCascadingTheme() {
        if (this.cascadingTheme == null) {
            this.cascadingTheme = new CascadingTheme(this.currentTheme, this.colorRegistry, this.fontRegistry);
        }
        return this.cascadingTheme;
    }

    private void updateForDialogFontChange(Font font) {
        Iterator iterator = this.dialogFontWidgets.iterator();
        while (iterator.hasNext()) {
            ((Control)iterator.next()).setFont(font);
        }
        this.labelProvider.clearFontCacheAndUpdate();
    }

    private void updateTreeSelection(ISelection iSelection) {
        String string;
        ThemeElementCategory themeElementCategory = null;
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object instanceof ThemeElementCategory) {
            themeElementCategory = (ThemeElementCategory)object;
        } else if (object instanceof ColorDefinition) {
            string = ((ColorDefinition)object).getCategoryId();
            themeElementCategory = WorkbenchPlugin.getDefault().getThemeRegistry().findCategory(string);
        } else if (object instanceof FontDefinition) {
            string = ((FontDefinition)object).getCategoryId();
            themeElementCategory = WorkbenchPlugin.getDefault().getThemeRegistry().findCategory(string);
        }
        string = null;
        if (themeElementCategory != null && (string = (Composite)this.previewMap.get(themeElementCategory)) == null) {
            try {
                IThemePreview iThemePreview = this.getThemePreview(themeElementCategory);
                if (iThemePreview != null) {
                    string = new Composite(this.previewComposite, 0);
                    string.setLayout((Layout)new FillLayout());
                    ITheme iTheme = this.getCascadingTheme();
                    iThemePreview.createControl((Composite)string, iTheme);
                    this.previewSet.add(iThemePreview);
                    this.previewMap.put(themeElementCategory, string);
                }
            }
            catch (CoreException coreException) {
                string = new Composite(this.previewComposite, 0);
                string.setLayout((Layout)new FillLayout());
                this.myApplyDialogFont((Control)string);
                Text text = new Text((Composite)string, 72);
                text.setText(RESOURCE_BUNDLE.getString("errorCreatingPreview"));
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("errorCreatePreviewLog"), StatusUtil.newStatus(4, coreException.getMessage(), (Throwable)coreException));
            }
        }
        if (string == null) {
            string = object instanceof ColorDefinition ? this.defaultColorPreview : (object instanceof FontDefinition ? this.defaultFontPreview : this.defaultNoPreview);
        }
        this.stackLayout.topControl = string;
        this.previewComposite.layout();
        this.updateControls();
    }

    private void restoreTreeSelection() {
        String string = this.getPreferenceStore().getString(SELECTED_ELEMENT_PREF);
        if (string == null) {
            return;
        }
        IThemeElementDefinition iThemeElementDefinition = this.findElementFromMarker(string);
        if (iThemeElementDefinition == null) {
            return;
        }
        this.tree.getViewer().setSelection((ISelection)new StructuredSelection((Object)iThemeElementDefinition), true);
    }

    private void saveTreeSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tree.getViewer().getSelection();
        Object object = iStructuredSelection.getFirstElement();
        StringBuffer stringBuffer = new StringBuffer();
        this.appendMarkerToBuffer(stringBuffer, object);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(((IThemeElementDefinition)object).getId());
        }
        this.getPreferenceStore().setValue(SELECTED_ELEMENT_PREF, stringBuffer.toString());
    }

    private void restoreTreeExpansion() {
        String string = this.getPreferenceStore().getString(EXPANDED_ELEMENTS_PREF);
        if (string == null) {
            return;
        }
        String[] stringArray = Util.getArrayFromList(string, EXPANDED_ELEMENTS_TOKEN);
        if (stringArray.length == 0) {
            return;
        }
        ArrayList<IThemeElementDefinition> arrayList = new ArrayList<IThemeElementDefinition>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            IThemeElementDefinition iThemeElementDefinition = this.findElementFromMarker(stringArray[n]);
            if (iThemeElementDefinition != null) {
                arrayList.add(iThemeElementDefinition);
            }
            ++n;
        }
        this.tree.getViewer().setExpandedElements(arrayList.toArray());
    }

    private IThemeElementDefinition findElementFromMarker(String string) {
        if (string.length() < 2) {
            return null;
        }
        char c = string.charAt(0);
        String string2 = string.substring(1);
        IThemeElementDefinition iThemeElementDefinition = null;
        switch (c) {
            case 'F': {
                iThemeElementDefinition = this.themeRegistry.findFont(string2);
                break;
            }
            case 'C': {
                iThemeElementDefinition = this.themeRegistry.findColor(string2);
                break;
            }
            case 'T': {
                iThemeElementDefinition = this.themeRegistry.findCategory(string2);
            }
        }
        return iThemeElementDefinition;
    }

    private void saveTreeExpansion() {
        Object object;
        Object[] objectArray = this.tree.getViewer().getExpandedElements();
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            this.appendMarkerToBuffer(stringBuffer, object);
            if (stringBuffer.length() != 0) {
                stringBuffer.append(((IThemeElementDefinition)object).getId());
                arrayList.add(stringBuffer.toString());
            }
            stringBuffer.setLength(0);
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append((String)object);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(EXPANDED_ELEMENTS_TOKEN);
        }
        this.getPreferenceStore().setValue(EXPANDED_ELEMENTS_PREF, stringBuffer.toString());
    }

    private void appendMarkerToBuffer(StringBuffer stringBuffer, Object object) {
        if (object instanceof FontDefinition) {
            stringBuffer.append('F');
        } else if (object instanceof ColorDefinition) {
            stringBuffer.append('C');
        } else if (object instanceof ThemeElementCategory) {
            stringBuffer.append('T');
        }
    }

    private void editFont(Display display) {
        this.editFont(this.getSelectedFontDefinition(), display);
    }

    private void editFont(FontDefinition fontDefinition, Display display) {
        if (fontDefinition != null) {
            FontDialog fontDialog = new FontDialog(this.getShell());
            fontDialog.setEffectsVisible(false);
            fontDialog.setFontList(this.getFontValue(fontDefinition));
            FontData fontData = fontDialog.open();
            if (fontData != null) {
                this.setFontPreferenceValue(fontDefinition, fontDialog.getFontList());
            }
        }
    }

    private void editColor(Display display) {
        this.editColor(this.getSelectedColorDefinition(), display);
    }

    private void editColor(ColorDefinition colorDefinition, Display display) {
        if (colorDefinition == null) {
            return;
        }
        RGB rGB = this.colorRegistry.getRGB(colorDefinition.getId());
        ColorDialog colorDialog = new ColorDialog(display.getActiveShell());
        colorDialog.setRGB(rGB);
        RGB rGB2 = colorDialog.open();
        if (rGB2 != null && !rGB2.equals((Object)rGB)) {
            this.setColorPreferenceValue(colorDefinition, rGB2);
            this.setRegistryValue(colorDefinition, rGB2);
        }
    }

    protected void updateControls() {
        FontDefinition fontDefinition = this.getSelectedFontDefinition();
        if (fontDefinition != null) {
            boolean bl = this.isDefault(fontDefinition);
            boolean bl2 = fontDefinition.getDefaultsTo() != null;
            this.fontChangeButton.setEnabled(true);
            this.fontSystemButton.setEnabled(true);
            this.fontResetButton.setEnabled(!bl);
            this.editDefaultButton.setEnabled(bl2 && bl);
            this.goToDefaultButton.setEnabled(bl2);
            this.setCurrentFont(fontDefinition);
            return;
        }
        ColorDefinition colorDefinition = this.getSelectedColorDefinition();
        if (colorDefinition != null) {
            boolean bl = this.isDefault(this.getSelectedColorDefinition());
            boolean bl3 = colorDefinition.getDefaultsTo() != null;
            this.fontChangeButton.setEnabled(true);
            this.fontSystemButton.setEnabled(false);
            this.fontResetButton.setEnabled(!bl);
            this.editDefaultButton.setEnabled(bl3 && bl);
            this.goToDefaultButton.setEnabled(bl3);
            this.setCurrentColor(colorDefinition);
            return;
        }
        this.fontChangeButton.setEnabled(false);
        this.fontSystemButton.setEnabled(false);
        this.fontResetButton.setEnabled(false);
        this.editDefaultButton.setEnabled(false);
        this.goToDefaultButton.setEnabled(false);
        this.descriptionText.setText("");
    }

    private Composite createNoPreviewControl() {
        Composite composite = new Composite(this.previewComposite, 0);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("noPreviewAvailable"));
        this.myApplyDialogFont((Control)label);
        return composite;
    }

    private void setCurrentFont(FontDefinition fontDefinition) {
        this.currentFont = this.fontRegistry.get(fontDefinition.getId());
        FontData[] fontDataArray = this.currentFont.getFontData();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fontDataArray.length) {
            stringBuffer.append(fontDataArray[n].getName());
            stringBuffer.append(' ');
            stringBuffer.append(fontDataArray[n].getHeight());
            int n2 = fontDataArray[n].getStyle();
            if ((n2 & 1) != 0) {
                stringBuffer.append(' ');
                stringBuffer.append(RESOURCE_BUNDLE.getString("boldFont"));
            }
            if ((n2 & 2) != 0) {
                stringBuffer.append(' ');
                stringBuffer.append(RESOURCE_BUNDLE.getString("italicFont"));
            }
            ++n;
        }
        this.fontSampleText = stringBuffer.toString();
        String string = fontDefinition.getDescription();
        this.descriptionText.setText(string == null ? "" : string);
        this.fontSampler.redraw();
    }

    public void setCurrentColor(ColorDefinition colorDefinition) {
        this.currentColor = this.colorRegistry.get(colorDefinition.getId());
        this.colorSampler.redraw();
        String string = colorDefinition.getDescription();
        this.descriptionText.setText(string == null ? "" : string);
    }

    private Composite createFontPreviewControl() {
        this.fontSampler = new Canvas(this.previewComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fontSampler.setLayout((Layout)gridLayout);
        this.fontSampler.setLayoutData((Object)new GridData(1808));
        this.fontSampler.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ColorsAndFontsPreferencePage.this.currentFont != null) {
                    ColorsAndFontsPreferencePage.this.paintFontSample(paintEvent.gc);
                }
            }
        });
        return this.fontSampler;
    }

    private void paintFontSample(GC gC) {
        if (this.currentFont == null || this.currentFont.isDisposed()) {
            return;
        }
        Rectangle rectangle = this.colorSampler.getClientArea();
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = n * 4;
        if (rectangle.height > n2) {
            rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n2);
        }
        gC.setForeground(this.previewComposite.getDisplay().getSystemColor(18));
        gC.drawRectangle(0, 0, rectangle.width - 1, rectangle.height - 1);
        gC.setForeground(this.previewComposite.getDisplay().getSystemColor(2));
        gC.setFont(this.currentFont);
        FontMetrics fontMetrics2 = gC.getFontMetrics();
        int n3 = fontMetrics2.getHeight();
        int n4 = rectangle.y + 5;
        gC.setClipping(1, 1, rectangle.width - 2, rectangle.height - 2);
        gC.drawText(this.fontSampleText, rectangle.x + 5, n4);
        gC.drawText(RESOURCE_BUNDLE.getString("fontTextSample"), rectangle.x + 5, n4 + n3);
    }

    private Composite createColorPreviewControl() {
        this.colorSampler = new Canvas(this.previewComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.colorSampler.setLayout((Layout)gridLayout);
        this.colorSampler.setLayoutData((Object)new GridData(1808));
        this.colorSampler.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ColorsAndFontsPreferencePage.this.currentColor != null) {
                    ColorsAndFontsPreferencePage.this.paintColorSample(paintEvent.gc);
                }
            }
        });
        return this.colorSampler;
    }

    private void paintColorSample(GC gC) {
        int n;
        if (this.currentColor == null || this.currentColor.isDisposed()) {
            return;
        }
        gC.setFont(this.previewComposite.getDisplay().getSystemFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        Rectangle rectangle = this.colorSampler.getClientArea();
        int n3 = n2 * 4;
        if (rectangle.height > n3) {
            rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n3);
        }
        String string = RESOURCE_BUNDLE.getString("fontColorSample");
        RGB rGB = this.currentColor.getRGB();
        String string2 = MessageFormat.format((String)"RGB({0}, {1}, {2})", (Object[])new Object[]{new Integer(rGB.red), new Integer(rGB.green), new Integer(rGB.blue)});
        int n4 = (rectangle.width - 2) / 3;
        int n5 = rectangle.height / 2;
        int n6 = (n5 - n2) / 2;
        if (n6 < 1) {
            n6 = 1;
        }
        if ((n = n5 + (n6 += rectangle.y)) > rectangle.height - 2) {
            n = rectangle.height - 2;
        }
        n += rectangle.y;
        int n7 = gC.stringExtent((String)string).x;
        int n8 = (n4 - n7 - 1) / 2;
        if (n8 < 1) {
            n8 = 1;
        }
        n8 += rectangle.x;
        int n9 = gC.stringExtent((String)string2).x;
        int n10 = (n4 - n9 - 1) / 2;
        if (n10 < 1) {
            n10 = 1;
        }
        gC.setForeground(this.currentColor);
        gC.drawText(string, n8, n6);
        gC.drawText(string2, n10 += rectangle.x, n);
        gC.setBackground(this.previewComposite.getDisplay().getSystemColor(25));
        int n11 = rectangle.width - 2 - n4 * 2;
        gC.fillRectangle(n4 * 2, 1, n11, rectangle.height - 2);
        gC.setForeground(this.currentColor);
        gC.drawText(string, n4 * 2 + n8, n6);
        gC.drawText(string2, n4 * 2 + n10, n);
        gC.setBackground(this.currentColor);
        gC.fillRectangle(n4, 1, n4, rectangle.height - 2);
        gC.setForeground(this.previewComposite.getDisplay().getSystemColor(2));
        gC.drawText(string, n4 + n8, n6);
        gC.setForeground(this.previewComposite.getDisplay().getSystemColor(1));
        gC.drawText(string2, n4 + n10, n);
        gC.setForeground(this.previewComposite.getDisplay().getSystemColor(18));
        gC.drawLine(n4, n5, n4 * 2 - 1, n5);
        gC.setForeground(this.previewComposite.getDisplay().getSystemColor(18));
        gC.drawRectangle(0, 0, rectangle.width - 1, rectangle.height - 1);
    }

    private void createDescriptionControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(RESOURCE_BUNDLE.getString("description"));
        this.myApplyDialogFont((Control)label);
        this.descriptionText = new Text(composite2, 2120);
        gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(3);
        gridData.widthHint = this.convertWidthInCharsToPixels(30);
        this.descriptionText.setLayoutData((Object)gridData);
        this.myApplyDialogFont((Control)this.descriptionText);
    }

    private class PresentationLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private HashMap fonts = new HashMap();
        private HashMap images = new HashMap();
        private int imageSize = -1;
        private int usableImageSize = -1;
        private IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PresentationLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)PresentationLabelProvider.this));
            }
        };
        private Image emptyImage;

        public PresentationLabelProvider() {
            this.hookListeners();
        }

        public void hookListeners() {
            ColorsAndFontsPreferencePage.this.colorRegistry.addListener(this.listener);
            ColorsAndFontsPreferencePage.this.fontRegistry.addListener(this.listener);
        }

        public void dispose() {
            super.dispose();
            ColorsAndFontsPreferencePage.this.colorRegistry.removeListener(this.listener);
            ColorsAndFontsPreferencePage.this.fontRegistry.removeListener(this.listener);
            Iterator iterator = this.images.values().iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
            this.images.clear();
            if (this.emptyImage != null) {
                this.emptyImage.dispose();
                this.emptyImage = null;
            }
            this.clearFontCache();
        }

        public void clearFontCache() {
            Iterator iterator = this.fonts.values().iterator();
            while (iterator.hasNext()) {
                ((Font)iterator.next()).dispose();
            }
            this.fonts.clear();
        }

        public void clearFontCacheAndUpdate() {
            this.clearFontCache();
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        public Font getFont(Object object) {
            Display display = ColorsAndFontsPreferencePage.this.tree.getDisplay();
            if (object instanceof FontDefinition) {
                int n = ColorsAndFontsPreferencePage.this.tree.getViewer().getControl().getFont().getFontData()[0].getHeight();
                Font font = ColorsAndFontsPreferencePage.this.fontRegistry.get(((FontDefinition)object).getId());
                Font font2 = (Font)this.fonts.get(font);
                if (font2 == null) {
                    FontData[] fontDataArray = font.getFontData();
                    int n2 = 0;
                    while (n2 < fontDataArray.length) {
                        fontDataArray[n2].setHeight(n);
                        ++n2;
                    }
                    font2 = new Font((Device)display, fontDataArray);
                    this.fonts.put(font, font2);
                }
                return font2;
            }
            return JFaceResources.getDialogFont();
        }

        public Image getImage(Object object) {
            if (object instanceof ColorDefinition) {
                Color color = ColorsAndFontsPreferencePage.this.colorRegistry.get(((ColorDefinition)object).getId());
                Image image = (Image)this.images.get(color);
                if (image == null) {
                    Display display = ColorsAndFontsPreferencePage.this.tree.getDisplay();
                    this.ensureImageSize();
                    image = new Image((Device)display, this.imageSize, this.imageSize);
                    GC gC = new GC((Drawable)image);
                    gC.setBackground(ColorsAndFontsPreferencePage.this.tree.getViewer().getControl().getBackground());
                    gC.setForeground(ColorsAndFontsPreferencePage.this.tree.getViewer().getControl().getBackground());
                    gC.drawRectangle(0, 0, this.imageSize - 1, this.imageSize - 1);
                    gC.setForeground(ColorsAndFontsPreferencePage.this.tree.getViewer().getControl().getForeground());
                    gC.setBackground(color);
                    int n = (this.imageSize - this.usableImageSize) / 2;
                    gC.drawRectangle(n, n, this.usableImageSize - n, this.usableImageSize - n);
                    gC.fillRectangle(n + 1, n + 1, this.usableImageSize - n - 1, this.usableImageSize - n - 1);
                    gC.dispose();
                    this.images.put(color, image);
                }
                return image;
            }
            if (object instanceof FontDefinition) {
                return ColorsAndFontsPreferencePage.this.workbench.getSharedImages().getImage("IMG_OBJ_FONT");
            }
            return ColorsAndFontsPreferencePage.this.workbench.getSharedImages().getImage("IMG_OBJ_THEME_CATEGORY");
        }

        private void ensureImageSize() {
            if (this.imageSize == -1) {
                this.imageSize = ColorsAndFontsPreferencePage.this.tree.getViewer().getTree().getItemHeight();
                this.usableImageSize = Math.max(1, this.imageSize - 4);
            }
        }

        public String getText(Object object) {
            IHierarchalThemeElementDefinition iHierarchalThemeElementDefinition;
            if (object instanceof IHierarchalThemeElementDefinition && (iHierarchalThemeElementDefinition = (IHierarchalThemeElementDefinition)object).getDefaultsTo() != null) {
                String string = ((ICategorizedThemeElementDefinition)((Object)iHierarchalThemeElementDefinition)).getCategoryId();
                ICategorizedThemeElementDefinition iCategorizedThemeElementDefinition = object instanceof ColorDefinition ? ColorsAndFontsPreferencePage.this.themeRegistry.findColor(iHierarchalThemeElementDefinition.getDefaultsTo()) : ColorsAndFontsPreferencePage.this.themeRegistry.findFont(iHierarchalThemeElementDefinition.getDefaultsTo());
                if (!ColorsAndFontsPreferencePage.equals(iCategorizedThemeElementDefinition.getCategoryId(), string)) {
                    if (this.isDefault(iHierarchalThemeElementDefinition)) {
                        return MessageFormat.format((String)RESOURCE_BUNDLE.getString("defaultFormat_default"), (Object[])new Object[]{iHierarchalThemeElementDefinition.getName(), iCategorizedThemeElementDefinition.getName()});
                    }
                    return MessageFormat.format((String)RESOURCE_BUNDLE.getString("defaultFormat_override"), (Object[])new Object[]{iHierarchalThemeElementDefinition.getName(), iCategorizedThemeElementDefinition.getName()});
                }
            }
            return ((IThemeElementDefinition)object).getName();
        }

        private boolean isDefault(IThemeElementDefinition iThemeElementDefinition) {
            if (iThemeElementDefinition instanceof FontDefinition) {
                FontDefinition fontDefinition = (FontDefinition)iThemeElementDefinition;
                String string = fontDefinition.getDefaultsTo();
                return string != null && Arrays.equals(ColorsAndFontsPreferencePage.this.fontRegistry.getFontData(iThemeElementDefinition.getId()), ColorsAndFontsPreferencePage.this.fontRegistry.getFontData(string));
            }
            if (iThemeElementDefinition instanceof ColorDefinition) {
                ColorDefinition colorDefinition = (ColorDefinition)iThemeElementDefinition;
                String string = colorDefinition.getDefaultsTo();
                if (string == null) {
                    return false;
                }
                RGB rGB = ColorsAndFontsPreferencePage.this.colorRegistry.getRGB(string);
                return rGB != null && rGB.equals((Object)ColorsAndFontsPreferencePage.this.colorRegistry.getRGB(colorDefinition.getId()));
            }
            return false;
        }
    }

    private class ThemeContentProvider
    implements ITreeContentProvider {
        private IThemeRegistry registry;

        private ThemeContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof ThemeElementCategory) {
                String string = ((ThemeElementCategory)object).getId();
                Object[] objectArray = (Object[])ColorsAndFontsPreferencePage.this.categoryMap.get(string);
                if (objectArray == null) {
                    objectArray = this.getCategoryChildren(string);
                    ColorsAndFontsPreferencePage.this.categoryMap.put(string, objectArray);
                }
                return objectArray;
            }
            ArrayList<ICategorizedThemeElementDefinition> arrayList = new ArrayList<ICategorizedThemeElementDefinition>();
            IHierarchalThemeElementDefinition iHierarchalThemeElementDefinition = (IHierarchalThemeElementDefinition)object;
            String string = iHierarchalThemeElementDefinition.getId();
            ICategorizedThemeElementDefinition[] iCategorizedThemeElementDefinitionArray = iHierarchalThemeElementDefinition instanceof ColorDefinition ? this.registry.getColors() : this.registry.getFonts();
            int n = 0;
            while (n < iCategorizedThemeElementDefinitionArray.length) {
                if (string.equals(iCategorizedThemeElementDefinitionArray[n].getDefaultsTo()) && ColorsAndFontsPreferencePage.equals(((ICategorizedThemeElementDefinition)((Object)iHierarchalThemeElementDefinition)).getCategoryId(), iCategorizedThemeElementDefinitionArray[n].getCategoryId())) {
                    arrayList.add(iCategorizedThemeElementDefinitionArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        private Object[] getCategoryChildren(String string) {
            Object object;
            int n;
            Object[] objectArray;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (string != null) {
                objectArray = this.registry.getCategories();
                n = 0;
                while (n < objectArray.length) {
                    if (string.equals(((ThemeElementCategory)objectArray[n]).getParentId()) && ((object = ColorsAndFontsPreferencePage.this.themeRegistry.getPresentationsBindingsFor((ThemeElementCategory)objectArray[n])) == null || object.contains(ColorsAndFontsPreferencePage.this.workbench.getPresentationId()))) {
                        arrayList.add(objectArray[n]);
                    }
                    ++n;
                }
            }
            objectArray = ColorsAndFontsPreferencePage.this.themeRegistry.getColorsFor(ColorsAndFontsPreferencePage.this.currentTheme.getId());
            n = 0;
            while (n < objectArray.length) {
                if (((ColorDefinition)objectArray[n]).isEditable() && ((object = ((ColorDefinition)objectArray[n]).getCategoryId()) == null && string == null || object != null && string != null && string.equals(object)) && (((ColorDefinition)objectArray[n]).getDefaultsTo() == null || !this.parentIsInSameCategory((ColorDefinition)objectArray[n]))) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            objectArray = ColorsAndFontsPreferencePage.this.themeRegistry.getFontsFor(ColorsAndFontsPreferencePage.this.currentTheme.getId());
            n = 0;
            while (n < objectArray.length) {
                if (((FontDefinition)objectArray[n]).isEditable() && ((object = ((FontDefinition)objectArray[n]).getCategoryId()) == null && string == null || object != null && string != null && string.equals(object)) && (((FontDefinition)objectArray[n]).getDefaultsTo() == null || !this.parentIsInSameCategory((FontDefinition)objectArray[n]))) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new Object[arrayList.size()]);
        }

        private boolean parentIsInSameCategory(ColorDefinition colorDefinition) {
            String string = colorDefinition.getDefaultsTo();
            ColorDefinition[] colorDefinitionArray = this.registry.getColors();
            int n = 0;
            while (n < colorDefinitionArray.length) {
                if (colorDefinitionArray[n].getId().equals(string) && ColorsAndFontsPreferencePage.equals(colorDefinitionArray[n].getCategoryId(), colorDefinition.getCategoryId())) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private boolean parentIsInSameCategory(FontDefinition fontDefinition) {
            String string = fontDefinition.getDefaultsTo();
            FontDefinition[] fontDefinitionArray = this.registry.getFonts();
            int n = 0;
            while (n < fontDefinitionArray.length) {
                if (fontDefinitionArray[n].getId().equals(string) && ColorsAndFontsPreferencePage.equals(fontDefinitionArray[n].getCategoryId(), fontDefinition.getCategoryId())) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Object getParent(Object object) {
            if (object instanceof ThemeElementCategory) {
                return this.registry;
            }
            if (object instanceof ColorDefinition) {
                Object object2;
                String string = ((IHierarchalThemeElementDefinition)object).getDefaultsTo();
                if (string != null && this.parentIsInSameCategory((ColorDefinition)(object2 = this.registry.findColor(string)))) {
                    return object2;
                }
                object2 = ((ColorDefinition)object).getCategoryId();
                return this.registry.findCategory((String)object2);
            }
            if (object instanceof FontDefinition) {
                Object object3;
                String string = ((FontDefinition)object).getDefaultsTo();
                if (string != null && this.parentIsInSameCategory((FontDefinition)(object3 = this.registry.findFont(string)))) {
                    return object3;
                }
                object3 = ((FontDefinition)object).getCategoryId();
                return this.registry.findCategory((String)object3);
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof ThemeElementCategory) {
                return true;
            }
            IHierarchalThemeElementDefinition iHierarchalThemeElementDefinition = (IHierarchalThemeElementDefinition)object;
            String string = iHierarchalThemeElementDefinition.getId();
            ICategorizedThemeElementDefinition[] iCategorizedThemeElementDefinitionArray = iHierarchalThemeElementDefinition instanceof ColorDefinition ? this.registry.getColors() : this.registry.getFonts();
            int n = 0;
            while (n < iCategorizedThemeElementDefinitionArray.length) {
                if (string.equals(iCategorizedThemeElementDefinitionArray[n].getDefaultsTo()) && ColorsAndFontsPreferencePage.equals(((ICategorizedThemeElementDefinition)((Object)iHierarchalThemeElementDefinition)).getCategoryId(), iCategorizedThemeElementDefinitionArray[n].getCategoryId())) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Object[] getElements(Object object) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = this.getCategoryChildren(null);
            arrayList.addAll(Arrays.asList(objectArray));
            ThemeElementCategory[] themeElementCategoryArray = ((IThemeRegistry)object).getCategories();
            int n = 0;
            while (n < themeElementCategoryArray.length) {
                Set set;
                if (themeElementCategoryArray[n].getParentId() == null && ((set = ColorsAndFontsPreferencePage.this.themeRegistry.getPresentationsBindingsFor(themeElementCategoryArray[n])) == null || set.contains(ColorsAndFontsPreferencePage.this.workbench.getPresentationId()))) {
                    arrayList.add(themeElementCategoryArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new Object[arrayList.size()]);
        }

        public void dispose() {
            ColorsAndFontsPreferencePage.this.categoryMap.clear();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            ColorsAndFontsPreferencePage.this.categoryMap.clear();
            this.registry = (IThemeRegistry)object2;
        }
    }
}

