/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IEditable;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ColorUtil;

public class ColorDefinition
implements IPluginContribution,
IHierarchalThemeElementDefinition,
ICategorizedThemeElementDefinition,
IEditable {
    private static final RGB DEFAULT_COLOR_VALUE = new RGB(0, 0, 0);
    private String defaultsTo;
    private String description;
    private String id;
    private String label;
    private String pluginId;
    private String rawValue;
    private String categoryId;
    boolean isEditable;
    private RGB parsedValue;

    public ColorDefinition(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7) {
        this.label = string;
        this.id = string2;
        this.defaultsTo = string3;
        this.rawValue = string4;
        this.categoryId = string5;
        this.description = string6;
        this.isEditable = bl;
        this.pluginId = string7;
    }

    public ColorDefinition(ColorDefinition colorDefinition, RGB rGB) {
        this.label = colorDefinition.getName();
        this.id = colorDefinition.getId();
        this.categoryId = colorDefinition.getCategoryId();
        this.description = colorDefinition.getDescription();
        this.isEditable = colorDefinition.isEditable();
        this.pluginId = colorDefinition.getPluginId();
        this.parsedValue = rGB;
    }

    @Override
    public String getCategoryId() {
        return this.categoryId;
    }

    @Override
    public String getDefaultsTo() {
        return this.defaultsTo;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.label;
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    public RGB getValue() {
        if (this.parsedValue == null) {
            try {
                this.parsedValue = ColorUtil.getColorValue(this.rawValue);
            }
            catch (DataFormatException dataFormatException) {
                this.parsedValue = DEFAULT_COLOR_VALUE;
                IStatus iStatus = StatusUtil.newStatus(2, "Could not parse value for theme color " + this.id, (Throwable)dataFormatException);
                StatusManager.getManager().handle(iStatus, 1);
            }
        }
        return this.parsedValue;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean equals(Object object) {
        if (object instanceof ColorDefinition) {
            return this.getId().equals(((ColorDefinition)object).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

