/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.themes.ITheme;

public class CascadingTheme
extends EventManager
implements ITheme {
    private CascadingFontRegistry fontRegistry;
    private CascadingColorRegistry colorRegistry;
    private ITheme currentTheme;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CascadingTheme.this.fire(propertyChangeEvent);
        }
    };

    public CascadingTheme(ITheme iTheme, CascadingColorRegistry cascadingColorRegistry, CascadingFontRegistry cascadingFontRegistry) {
        this.currentTheme = iTheme;
        this.colorRegistry = cascadingColorRegistry;
        this.fontRegistry = cascadingFontRegistry;
        cascadingFontRegistry.addListener(this.listener);
        cascadingColorRegistry.addListener(this.listener);
    }

    protected void fire(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    @Override
    public String getId() {
        return this.currentTheme.getId();
    }

    @Override
    public String getLabel() {
        return this.currentTheme.getLabel();
    }

    @Override
    public ColorRegistry getColorRegistry() {
        return this.colorRegistry;
    }

    @Override
    public FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    @Override
    public void dispose() {
        this.colorRegistry.removeListener(this.listener);
        this.fontRegistry.removeListener(this.listener);
    }

    @Override
    public String getString(String string) {
        return this.currentTheme.getString(string);
    }

    @Override
    public int getInt(String string) {
        return this.currentTheme.getInt(string);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.currentTheme.getBoolean(string);
    }

    @Override
    public Set keySet() {
        return this.currentTheme.keySet();
    }
}

