/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CascadingFontRegistry
extends FontRegistry {
    private FontRegistry parent;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!CascadingFontRegistry.this.hasOverrideFor(propertyChangeEvent.getProperty())) {
                CascadingFontRegistry.this.fireMappingChanged(propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    };

    public CascadingFontRegistry(FontRegistry fontRegistry) {
        super(Display.getCurrent(), false);
        this.parent = fontRegistry;
        fontRegistry.addListener(this.listener);
    }

    public Font get(String string) {
        if (super.hasValueFor(string)) {
            return super.get(string);
        }
        return this.parent.get(string);
    }

    public Set getKeySet() {
        HashSet hashSet = new HashSet(super.getKeySet());
        hashSet.addAll(this.parent.getKeySet());
        return hashSet;
    }

    public FontData[] getFontData(String string) {
        if (super.hasValueFor(string)) {
            return super.getFontData(string);
        }
        return this.parent.getFontData(string);
    }

    public boolean hasValueFor(String string) {
        return super.hasValueFor(string) || this.parent.hasValueFor(string);
    }

    public boolean hasOverrideFor(String string) {
        return super.hasValueFor(string);
    }

    public void dispose() {
        this.parent.removeListener(this.listener);
        PlatformUI.getWorkbench().getDisplay().asyncExec(this.displayRunnable);
    }
}

