/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CascadingColorRegistry
extends ColorRegistry {
    private ColorRegistry parent;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!CascadingColorRegistry.this.hasOverrideFor(propertyChangeEvent.getProperty())) {
                CascadingColorRegistry.this.fireMappingChanged(propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    };

    public CascadingColorRegistry(ColorRegistry colorRegistry) {
        super(Display.getCurrent(), false);
        this.parent = colorRegistry;
        colorRegistry.addListener(this.listener);
    }

    public Color get(String string) {
        if (super.hasValueFor(string)) {
            return super.get(string);
        }
        return this.parent.get(string);
    }

    public Set getKeySet() {
        HashSet hashSet = new HashSet(super.getKeySet());
        hashSet.addAll(this.parent.getKeySet());
        return hashSet;
    }

    public RGB getRGB(String string) {
        if (super.hasValueFor(string)) {
            return super.getRGB(string);
        }
        return this.parent.getRGB(string);
    }

    public boolean hasValueFor(String string) {
        return super.hasValueFor(string) || this.parent.hasValueFor(string);
    }

    public boolean hasOverrideFor(String string) {
        return super.hasValueFor(string);
    }

    public void dispose() {
        this.parent.removeListener(this.listener);
        PlatformUI.getWorkbench().getDisplay().asyncExec(this.displayRunnable);
    }
}

