/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.internal.statushandlers.InternalDialog;
import org.eclipse.ui.internal.statushandlers.LabelProviderWrapper;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class WorkbenchStatusDialogManagerImpl {
    static final QualifiedName HINT = new QualifiedName("org.eclipse.ui.workbench.statusHandlers.adapters", "hint");
    private DisposeListener disposeListener = new StatusDialogDisposeListener();
    private InternalDialog dialog;
    private Map dialogState = new HashMap();

    public boolean shouldAccept(StatusAdapter statusAdapter) {
        IStatus iStatus = statusAdapter.getStatus();
        IStatus[] iStatusArray = iStatus.getChildren();
        int n = (Integer)this.dialogState.get(IStatusDialogConstants.MASK);
        boolean bl = (Boolean)this.dialogState.get(IStatusDialogConstants.HANDLE_OK_STATUSES);
        if (iStatusArray == null || iStatusArray.length == 0) {
            return iStatus.matches(n) || bl && iStatus.isOK();
        }
        int n2 = 0;
        while (n2 < iStatusArray.length) {
            if (iStatusArray[n2].matches(n)) {
                return true;
            }
            ++n2;
        }
        return bl && iStatus.isOK();
    }

    public WorkbenchStatusDialogManagerImpl(int n, String string) {
        Assert.isNotNull((Object)Display.getCurrent(), (String)"WorkbenchStatusDialogManager must be instantiated in UI thread");
        this.dialogState = this.initDialogState(this.dialogState, n, string);
    }

    public Map initDialogState(Map map, int n, String string) {
        map.put(IStatusDialogConstants.MASK, new Integer(n));
        map.put(IStatusDialogConstants.TITLE, string == null ? JFaceResources.getString((String)"Problem_Occurred") : string);
        map.put(IStatusDialogConstants.HANDLE_OK_STATUSES, Boolean.FALSE);
        map.put(IStatusDialogConstants.SHOW_SUPPORT, Boolean.FALSE);
        map.put(IStatusDialogConstants.ENABLE_DEFAULT_SUPPORT_AREA, Boolean.FALSE);
        map.put(IStatusDialogConstants.DETAILS_OPENED, Boolean.FALSE);
        map.put(IStatusDialogConstants.TRAY_OPENED, Boolean.FALSE);
        map.put(IStatusDialogConstants.HIDE_SUPPORT_BUTTON, Boolean.FALSE);
        map.put(IStatusDialogConstants.STATUS_ADAPTERS, Collections.synchronizedSet(new HashSet()));
        map.put(IStatusDialogConstants.STATUS_MODALS, new HashMap());
        map.put(IStatusDialogConstants.LABEL_PROVIDER, new LabelProviderWrapper(map));
        map.put(IStatusDialogConstants.MODALITY_SWITCH, Boolean.FALSE);
        map.put(IStatusDialogConstants.ANIMATION, Boolean.TRUE);
        return map;
    }

    public void addStatusAdapter(StatusAdapter statusAdapter, boolean bl) {
        if (ErrorDialog.AUTOMATED_MODE) {
            return;
        }
        try {
            this.doAddStatusAdapter(statusAdapter, bl);
        }
        catch (Exception exception) {
            if (!this.isDialogClosed()) {
                this.dialog.getShell().dispose();
            }
            this.cleanUp();
            WorkbenchPlugin.log(statusAdapter.getStatus());
            WorkbenchPlugin.log(exception);
            exception.printStackTrace();
        }
    }

    private boolean isDialogClosed() {
        return this.dialog == null || this.dialog.getShell() == null || this.dialog.getShell().isDisposed();
    }

    private void cleanUp() {
        this.dialog = null;
        this.getErrors().clear();
        this.getModals().clear();
        this.dialogState.put(IStatusDialogConstants.DETAILS_OPENED, Boolean.FALSE);
        this.dialogState.put(IStatusDialogConstants.TRAY_OPENED, Boolean.FALSE);
        this.dialogState.put(IStatusDialogConstants.MODALITY_SWITCH, Boolean.FALSE);
    }

    private void doAddStatusAdapter(StatusAdapter statusAdapter, boolean bl) {
        if (!PlatformUI.isWorkbenchRunning()) {
            WorkbenchPlugin.log(statusAdapter.getStatus());
            return;
        }
        if (!this.shouldAccept(statusAdapter)) {
            return;
        }
        if (this.isDialogClosed()) {
            this.getErrors().add(statusAdapter);
            this.getModals().put(statusAdapter, new Boolean(bl));
            if (this.shouldPrompt(statusAdapter)) {
                StatusManager.getManager().fireNotification(1, this.getErrors().toArray(new StatusAdapter[0]));
                if (this.dialog == null) {
                    this.setSelectedStatusAdapter(statusAdapter);
                    this.dialog = new InternalDialog(this.dialogState, this.shouldBeModal());
                    this.dialog.create();
                    this.dialog.getShell().addDisposeListener(this.disposeListener);
                    boolean bl2 = (Boolean)this.dialogState.get(IStatusDialogConstants.SHOW_SUPPORT);
                    if (bl2) {
                        this.dialog.openTray();
                        this.dialog.getShell().setLocation(this.dialog.getInitialLocation(this.dialog.getShell().getSize()));
                    }
                    this.dialog.open();
                }
                this.dialog.refresh();
                this.dialog.refreshDialogSize();
            }
        } else {
            StatusManager.getManager().fireNotification(1, new StatusAdapter[]{statusAdapter});
            if (statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) != null) {
                statusAdapter.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.FALSE);
            }
            this.openStatusDialog(bl, statusAdapter);
        }
    }

    public Collection getStatusAdapters() {
        return Collections.unmodifiableCollection(this.getErrors());
    }

    private void openStatusDialog(boolean bl, StatusAdapter statusAdapter) {
        this.getErrors().add(statusAdapter);
        this.getModals().put(statusAdapter, new Boolean(bl));
        boolean bl2 = this.shouldBeModal();
        if (bl2 ^ this.dialog.isModal()) {
            this.dialog.getShell().removeDisposeListener(this.disposeListener);
            this.dialogState.put(IStatusDialogConstants.MODALITY_SWITCH, Boolean.TRUE);
            this.dialog.close();
            this.dialog = new InternalDialog(this.dialogState, bl);
            this.dialog.open();
            this.dialog.getShell().addDisposeListener(this.disposeListener);
            this.dialogState.put(IStatusDialogConstants.MODALITY_SWITCH, Boolean.FALSE);
        }
        this.dialog.refresh();
    }

    public void setSelectedStatusAdapter(StatusAdapter statusAdapter) {
        this.dialogState.put(IStatusDialogConstants.CURRENT_STATUS_ADAPTER, statusAdapter);
    }

    public void setStatusListLabelProvider(ITableLabelProvider iTableLabelProvider) {
        Assert.isLegal((iTableLabelProvider != null ? 1 : 0) != 0, (String)"Label Provider cannot be null");
        this.dialogState.put(IStatusDialogConstants.CUSTOM_LABEL_PROVIDER, iTableLabelProvider);
    }

    public boolean shouldBeModal() {
        Map map = (Map)this.dialogState.get(IStatusDialogConstants.STATUS_MODALS);
        for (Object k : map.keySet()) {
            Boolean bl;
            Object v = map.get(k);
            if (!(v instanceof Boolean) || !(bl = (Boolean)v).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldPrompt(StatusAdapter statusAdapter) {
        Object object = statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY);
        boolean bl = true;
        if (object instanceof Boolean) {
            bl = (Boolean)object == false;
        }
        return bl;
    }

    public Shell getShell() {
        if (this.dialog == null) {
            return null;
        }
        return this.dialog.getShell();
    }

    public void setMessageDecorator(ILabelDecorator iLabelDecorator) {
        this.dialogState.put(IStatusDialogConstants.DECORATOR, iLabelDecorator);
    }

    public void setProperty(Object object, Object object2) {
        this.dialogState.put(object, object2);
    }

    public Object getProperty(Object object) {
        if (object == IStatusDialogConstants.SHELL) {
            return this.getShell();
        }
        if (object == IStatusDialogConstants.MANAGER_IMPL) {
            return this;
        }
        return this.dialogState.get(object);
    }

    public void enableErrorDialogCompatibility() {
        this.setProperty(IStatusDialogConstants.ERRORLOG_LINK, Boolean.FALSE);
        this.setProperty(IStatusDialogConstants.HANDLE_OK_STATUSES, Boolean.TRUE);
        this.setProperty(IStatusDialogConstants.SHOW_SUPPORT, Boolean.TRUE);
        this.setProperty(IStatusDialogConstants.HIDE_SUPPORT_BUTTON, Boolean.TRUE);
    }

    public InternalDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(InternalDialog internalDialog) {
        this.dialog = internalDialog;
    }

    public Map getDialogState() {
        return this.dialogState;
    }

    private Collection getErrors() {
        return (Collection)this.dialogState.get(IStatusDialogConstants.STATUS_ADAPTERS);
    }

    private Map getModals() {
        return (Map)this.dialogState.get(IStatusDialogConstants.STATUS_MODALS);
    }

    private final class StatusDialogDisposeListener
    implements DisposeListener {
        private StatusDialogDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            WorkbenchStatusDialogManagerImpl.this.cleanUp();
        }
    }
}

