/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.util.Map;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.internal.statushandlers.StackTraceSupportArea;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class SupportTray
extends DialogTray
implements ISelectionChangedListener {
    private Map dialogState;
    private IContributionItem closeAction;
    private Listener closeListener;
    private boolean hideSupportButtons;
    private Image normal;
    private Image hover;
    private Composite supportArea;
    private Composite supportAreaContent;
    private StatusAdapter lastSelectedStatus;
    private AbstractStatusAreaProvider userSupportProvider;

    public SupportTray(Map map, Listener listener) {
        this.closeListener = listener;
        this.dialogState = map;
        this.hideSupportButtons = this.getBooleanValue(IStatusDialogConstants.HIDE_SUPPORT_BUTTON);
        this.lastSelectedStatus = this.getCurrentStatusAdapter();
    }

    protected Control createContents(Composite composite) {
        Label label;
        GridData gridData;
        ToolBarManager toolBarManager;
        Composite composite2 = new Composite(composite, 0);
        if (this.providesSupport(this.getCurrentStatusAdapter()) == null) {
            this.getBooleanValue(IStatusDialogConstants.TRAY_OPENED);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData2);
        composite2.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SupportTray.this.destroyImages();
            }
        });
        if (!this.hideSupportButtons) {
            toolBarManager = new ToolBarManager(0x800000);
            toolBarManager.createControl(composite2);
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = true;
            toolBarManager.getControl().setLayoutData((Object)gridData);
            label = new Label(composite2, 258);
            gridData = new GridData(256);
            gridData.heightHint = 1;
            label.setLayoutData((Object)gridData);
            this.createActions();
            toolBarManager.add(this.closeAction);
            toolBarManager.update(true);
        }
        this.supportArea = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.supportArea.setLayout((Layout)gridLayout);
        toolBarManager = new GridData(272);
        toolBarManager.horizontalSpan = 1;
        toolBarManager.grabExcessHorizontalSpace = true;
        toolBarManager.grabExcessVerticalSpace = true;
        this.supportArea.setLayoutData((Object)toolBarManager);
        if (this.lastSelectedStatus != null) {
            this.createSupportArea(this.supportArea, this.lastSelectedStatus);
        }
        gridData = this.supportArea.getShell().getSize();
        label = this.supportArea.getShell().computeSize(-1, -1);
        if (label.y > gridData.y) {
            this.supportArea.getShell().setSize(gridData.x, Math.min(label.y, 500));
        }
        return composite2;
    }

    private void createImages() {
        Display display = Display.getCurrent();
        int[] nArray = new int[]{3, 3, 5, 3, 7, 5, 8, 5, 10, 3, 12, 3, 12, 5, 10, 7, 10, 8, 12, 10, 12, 12, 10, 12, 8, 10, 7, 10, 5, 12, 3, 12, 3, 10, 5, 8, 5, 7, 3, 5};
        Color color = display.getSystemColor(17);
        Color color2 = display.getSystemColor(25);
        Color color3 = new Color((Device)display, new RGB(252, 160, 160));
        Color color4 = display.getSystemColor(11);
        PaletteData paletteData = new PaletteData(new RGB[]{color4.getRGB(), color.getRGB(), color2.getRGB(), color3.getRGB()});
        ImageData imageData = new ImageData(16, 16, 8, paletteData);
        imageData.transparentPixel = 0;
        this.normal = new Image((Device)display, imageData);
        this.normal.setBackground(color4);
        GC gC = new GC((Drawable)this.normal);
        gC.setBackground(color2);
        gC.fillPolygon(nArray);
        gC.setForeground(color);
        gC.drawPolygon(nArray);
        gC.dispose();
        this.hover = new Image((Device)display, imageData);
        this.hover.setBackground(color4);
        gC = new GC((Drawable)this.hover);
        gC.setBackground(color3);
        gC.fillPolygon(nArray);
        gC.setForeground(color);
        gC.drawPolygon(nArray);
        gC.dispose();
        color3.dispose();
    }

    private void createActions() {
        this.createImages();
        this.closeAction = new ContributionItem(){

            public void fill(ToolBar toolBar, int n) {
                ToolItem toolItem = new ToolItem(toolBar, 8);
                toolItem.setImage(SupportTray.this.normal);
                toolItem.setHotImage(SupportTray.this.hover);
                toolItem.setToolTipText(JFaceResources.getString((String)"close"));
                toolItem.addListener(13, SupportTray.this.closeListener);
            }
        };
    }

    private void destroyImages() {
        if (this.normal != null) {
            this.normal.dispose();
        }
        if (this.hover != null) {
            this.hover.dispose();
        }
    }

    private void createSupportArea(Composite composite, StatusAdapter statusAdapter) {
        ErrorSupportProvider errorSupportProvider = this.getSupportProvider();
        if (errorSupportProvider == null) {
            return;
        }
        if (this.supportAreaContent != null) {
            this.supportAreaContent.dispose();
        }
        this.supportAreaContent = new Composite(composite, 4);
        GridData gridData = new GridData(4, 4, true, true);
        this.supportAreaContent.setLayoutData((Object)gridData);
        if (this.supportAreaContent.getLayout() == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            this.supportAreaContent.setLayout((Layout)gridLayout);
        }
        if (errorSupportProvider instanceof AbstractStatusAreaProvider) {
            ((AbstractStatusAreaProvider)errorSupportProvider).createSupportArea(this.supportAreaContent, statusAdapter);
        } else {
            errorSupportProvider.createSupportArea(this.supportAreaContent, statusAdapter.getStatus());
        }
    }

    public ErrorSupportProvider getSupportProvider() {
        ErrorSupportProvider errorSupportProvider = Policy.getErrorSupportProvider();
        if (this.userSupportProvider != null) {
            errorSupportProvider = this.userSupportProvider;
        }
        if (this.getBooleanValue(IStatusDialogConstants.ENABLE_DEFAULT_SUPPORT_AREA) && errorSupportProvider == null) {
            errorSupportProvider = new StackTraceSupportArea();
        }
        return errorSupportProvider;
    }

    private StatusAdapter getStatusAdapterFromEvent(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection;
        Object object;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)iSelection).getFirstElement()) instanceof StatusAdapter) {
            return (StatusAdapter)object;
        }
        return null;
    }

    public ErrorSupportProvider providesSupport(StatusAdapter statusAdapter) {
        ErrorSupportProvider errorSupportProvider = this.getSupportProvider();
        if (errorSupportProvider instanceof AbstractStatusAreaProvider) {
            AbstractStatusAreaProvider abstractStatusAreaProvider = (AbstractStatusAreaProvider)errorSupportProvider;
            if (abstractStatusAreaProvider.validFor(statusAdapter)) {
                return abstractStatusAreaProvider;
            }
            return null;
        }
        return errorSupportProvider;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.lastSelectedStatus = this.getStatusAdapterFromEvent(selectionChangedEvent);
        if (this.supportArea != null && !this.supportArea.isDisposed() && this.lastSelectedStatus != null) {
            this.createSupportArea(this.supportArea, this.lastSelectedStatus);
            this.supportArea.layout(true);
        }
    }

    public Composite getSupportArea() {
        return this.supportArea;
    }

    private boolean getBooleanValue(Object object) {
        Boolean bl = (Boolean)this.dialogState.get(object);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private StatusAdapter getCurrentStatusAdapter() {
        return (StatusAdapter)this.dialogState.get(IStatusDialogConstants.CURRENT_STATUS_ADAPTER);
    }
}

