/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.statushandlers.StatusHandlerDescriptor;
import org.eclipse.ui.internal.statushandlers.StatusHandlerDescriptorsMap;
import org.eclipse.ui.internal.statushandlers.StatusHandlerProductBindingDescriptor;

public class StatusHandlerRegistry
implements IExtensionChangeHandler {
    private static final String STATUSHANDLERS_POINT_NAME = "statusHandlers";
    private static final String TAG_STATUSHANDLER = "statusHandler";
    private static final String TAG_STATUSHANDLER_PRODUCTBINDING = "statusHandlerProductBinding";
    private static final String STATUSHANDLER_ARG = "-statushandler";
    private ArrayList statusHandlerDescriptors = new ArrayList();
    private ArrayList productBindingDescriptors = new ArrayList();
    private StatusHandlerDescriptorsMap statusHandlerDescriptorsMap;
    private StatusHandlerDescriptor defaultHandlerDescriptor;
    private static StatusHandlerRegistry instance;

    private StatusHandlerRegistry() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(WorkbenchPlugin.PI_WORKBENCH, STATUSHANDLERS_POINT_NAME);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        this.statusHandlerDescriptorsMap = new StatusHandlerDescriptorsMap();
        int n = 0;
        while (n < iExtensionArray.length) {
            this.addExtension(iExtensionTracker, iExtensionArray[n]);
            ++n;
        }
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)iExtensionPoint));
        IExtensionPoint iExtensionPoint2 = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.runtime", "products");
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)iExtensionPoint2));
    }

    public static StatusHandlerRegistry getDefault() {
        if (instance == null) {
            instance = new StatusHandlerRegistry();
        }
        return instance;
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IPluginContribution iPluginContribution;
            if (iConfigurationElementArray[n].getName().equals(TAG_STATUSHANDLER)) {
                iPluginContribution = new StatusHandlerDescriptor(iConfigurationElementArray[n]);
                iExtensionTracker.registerObject(iExtension, (Object)iPluginContribution, 0);
                this.statusHandlerDescriptors.add(iPluginContribution);
            } else if (iConfigurationElementArray[n].getName().equals(TAG_STATUSHANDLER_PRODUCTBINDING)) {
                iPluginContribution = new StatusHandlerProductBindingDescriptor(iConfigurationElementArray[n]);
                iExtensionTracker.registerObject(iExtension, (Object)iPluginContribution, 0);
                this.productBindingDescriptors.add(iPluginContribution);
            }
            ++n;
        }
        this.buildHandlersStructure();
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof StatusHandlerDescriptor) {
                this.statusHandlerDescriptors.remove(objectArray[n]);
            } else if (objectArray[n] instanceof StatusHandlerProductBindingDescriptor) {
                this.productBindingDescriptors.remove(objectArray[n]);
            }
            ++n;
        }
        this.buildHandlersStructure();
    }

    public StatusHandlerDescriptor getDefaultHandlerDescriptor() {
        return this.defaultHandlerDescriptor;
    }

    public List getHandlerDescriptors(String string) {
        return this.statusHandlerDescriptorsMap.getHandlerDescriptors(string);
    }

    public StatusHandlerDescriptor getHandlerDescriptor(String string) {
        StatusHandlerDescriptor statusHandlerDescriptor2 = null;
        for (StatusHandlerDescriptor statusHandlerDescriptor2 : this.statusHandlerDescriptors) {
            if (!statusHandlerDescriptor2.getId().equals(string)) continue;
            return statusHandlerDescriptor2;
        }
        if (this.defaultHandlerDescriptor != null && this.defaultHandlerDescriptor.getId().equals(string)) {
            return this.defaultHandlerDescriptor;
        }
        return null;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    private String resolveUserStatusHandlerId() {
        String[] stringArray = Platform.getCommandLineArgs();
        int n = 0;
        while (n < stringArray.length - 1) {
            if (STATUSHANDLER_ARG.equals(stringArray[n])) {
                return stringArray[n + 1];
            }
            ++n;
        }
        return null;
    }

    private void buildHandlersStructure() {
        this.statusHandlerDescriptorsMap.clear();
        this.defaultHandlerDescriptor = null;
        String string = Platform.getProduct() != null ? Platform.getProduct().getId() : null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = this.resolveUserStatusHandlerId();
        if (string2 == null) {
            for (Object object : this.productBindingDescriptors) {
                if (!((StatusHandlerProductBindingDescriptor)object).getProductId().equals(string)) continue;
                string2 = ((StatusHandlerProductBindingDescriptor)object).getHandlerId();
            }
        }
        for (Object object : this.statusHandlerDescriptors) {
            arrayList.add(object);
        }
        Object object2 = null;
        for (Object object2 : arrayList) {
            if (((StatusHandlerDescriptor)object2).getId().equals(string2)) {
                this.defaultHandlerDescriptor = object2;
                continue;
            }
            this.statusHandlerDescriptorsMap.addHandlerDescriptor((StatusHandlerDescriptor)object2);
        }
    }
}

