/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class StackTraceSupportArea
extends AbstractStatusAreaProvider {
    private List list;

    @Override
    public Control createSupportArea(Composite composite, StatusAdapter statusAdapter) {
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.StackTraceSupportArea_Title);
        this.list = new List(composite, 770);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 250;
        this.list.setLayoutData((Object)gridData);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StackTraceSupportArea.this.list.selectAll();
                super.widgetSelected(selectionEvent);
            }
        });
        this.list.removeAll();
        this.populateList(statusAdapter.getStatus().getException());
        this.createDNDSource();
        this.createCopyAction(composite);
        return composite;
    }

    private void createDNDSource() {
        DragSource dragSource = new DragSource((Control)this.list, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent dragSourceEvent) {
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = StackTraceSupportArea.this.prepareCopyString();
                }
            }

            public void dragStart(DragSourceEvent dragSourceEvent) {
                StackTraceSupportArea.this.list.selectAll();
            }
        });
    }

    private void createCopyAction(final Composite composite) {
        Menu menu = new Menu((Decorations)composite.getShell(), 8);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("&Copy");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Clipboard clipboard = null;
                try {
                    clipboard = new Clipboard(composite.getDisplay());
                    clipboard.setContents(new Object[]{StackTraceSupportArea.this.prepareCopyString()}, new Transfer[]{TextTransfer.getInstance()});
                }
                finally {
                    if (clipboard != null) {
                        clipboard.dispose();
                    }
                }
                super.widgetSelected(selectionEvent);
            }
        });
        this.list.setMenu(menu);
    }

    private String prepareCopyString() {
        if (this.list == null || this.list.isDisposed()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        int n = 0;
        while (n < this.list.getItemCount()) {
            stringBuffer.append(this.list.getItem(n));
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void populateList(Throwable throwable) {
        if (throwable == null) {
            this.list.add(WorkbenchMessages.StackTraceSupportArea_NoStackTrace);
            return;
        }
        this.list.add(throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = 0;
        while (n < stackTraceElementArray.length) {
            this.list.add(stackTraceElementArray[n].toString());
            ++n;
        }
        if (throwable.getCause() != null) {
            this.list.add(WorkbenchMessages.StackTraceSupportArea_CausedBy);
            this.populateList(throwable.getCause());
        }
    }

    public List getList() {
        return this.list;
    }

    @Override
    public boolean validFor(StatusAdapter statusAdapter) {
        return statusAdapter.getStatus().getException() != null;
    }
}

