/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import com.ibm.icu.text.DateFormat;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class LabelProviderWrapper
extends ViewerComparator
implements ITableLabelProvider {
    private ITableLabelProvider labelProvider;
    private ILabelDecorator messageDecorator;
    private Map dialogState;

    public LabelProviderWrapper(Map map) {
        this.dialogState = map;
    }

    public Image getColumnImage(Object object, int n) {
        return this.labelProvider.getColumnImage(object, n);
    }

    public String getColumnText(Object object, int n) {
        return this.getLabelProvider().getColumnText(object, n);
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        this.getLabelProvider().addListener(iLabelProviderListener);
    }

    public void dispose() {
        boolean bl = (Boolean)this.dialogState.get(IStatusDialogConstants.MODALITY_SWITCH);
        if (!bl) {
            this.getLabelProvider().dispose();
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return this.getLabelProvider().isLabelProperty(object, string);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        this.getLabelProvider().removeListener(iLabelProviderListener);
    }

    public Image getImage(StatusAdapter statusAdapter) {
        if (statusAdapter != null) {
            int n = statusAdapter.getStatus().getSeverity();
            switch (n) {
                case 0: 
                case 1: 
                case 8: {
                    return this.getSWTImage(2);
                }
                case 2: {
                    return this.getSWTImage(8);
                }
            }
            return this.getSWTImage(1);
        }
        return this.getSWTImage(1);
    }

    public Image getSWTImage(int n) {
        return Display.getCurrent().getSystemImage(n);
    }

    public String getMainMessage(StatusAdapter statusAdapter) {
        if (!this.isMulti()) {
            Job job = (Job)statusAdapter.getAdapter(Job.class);
            if (job != null) {
                return NLS.bind((String)WorkbenchMessages.WorkbenchStatusDialog_ProblemOccurredInJob, (Object)job.getName());
            }
            return this.getPrimaryMessage(statusAdapter);
        }
        if (this.isMulti()) {
            Job job = (Job)statusAdapter.getAdapter(Job.class);
            if (job != null) {
                return this.getPrimaryMessage(statusAdapter);
            }
            return this.getSecondaryMessage(statusAdapter);
        }
        return WorkbenchMessages.WorkbenchStatusDialog_ProblemOccurred;
    }

    public String getPrimaryMessage(StatusAdapter statusAdapter) {
        String string;
        Object object = statusAdapter.getProperty(IStatusAdapterConstants.TITLE_PROPERTY);
        if (object instanceof String && (string = (String)object).trim().length() > 0) {
            return this.decorate(string, statusAdapter);
        }
        string = statusAdapter.getStatus();
        if (string.getMessage() != null && string.getMessage().trim().length() > 0) {
            return this.decorate(string.getMessage(), statusAdapter);
        }
        if (string.getChildren().length > 0) {
            return WorkbenchMessages.WorkbenchStatusDialog_StatusWithChildren;
        }
        Throwable throwable = string.getException();
        if (throwable != null) {
            if (throwable.getMessage() != null && throwable.getMessage().trim().length() > 0) {
                return this.decorate(throwable.getMessage(), statusAdapter);
            }
            return throwable.getClass().getName();
        }
        return WorkbenchMessages.WorkbenchStatusDialog_ProblemOccurred;
    }

    public String getSecondaryMessage(StatusAdapter statusAdapter) {
        String string;
        String string2 = this.getPrimaryMessage(statusAdapter);
        IStatus iStatus = statusAdapter.getStatus();
        String string3 = iStatus.getMessage();
        String string4 = string = string3 == null ? null : this.decorate(string3, statusAdapter);
        if (string3 != null && string3.trim().length() > 0 && !string2.equals(string)) {
            return string;
        }
        if (iStatus.getChildren().length > 0 && !string2.equals(string)) {
            return WorkbenchMessages.WorkbenchStatusDialog_StatusWithChildren;
        }
        Throwable throwable = iStatus.getException();
        if (throwable != null) {
            String string5;
            if (throwable.getMessage() != null) {
                string5 = this.decorate(throwable.getMessage(), statusAdapter);
                if (throwable.getMessage().trim().length() > 0 && !string2.equals(string5)) {
                    return string5;
                }
            }
            if (!string2.equals(string5 = throwable.getClass().getName())) {
                return string5;
            }
        }
        return WorkbenchMessages.WorkbenchStatusDialog_SeeDetails;
    }

    private String decorate(String string, StatusAdapter statusAdapter) {
        this.messageDecorator = (ILabelDecorator)this.dialogState.get(IStatusDialogConstants.DECORATOR);
        if (this.messageDecorator != null) {
            string = this.messageDecorator.decorateText(string, (Object)statusAdapter);
        }
        return string;
    }

    private int compare(StatusAdapter statusAdapter, StatusAdapter statusAdapter2) {
        Long l = (Long)statusAdapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY);
        Long l2 = (Long)statusAdapter2.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY);
        if (l == null || l2 == null || l.equals(l2)) {
            String string = this.getColumnText(statusAdapter, 0);
            String string2 = this.getColumnText(statusAdapter2, 0);
            return string.compareTo(string2);
        }
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        if (object instanceof StatusAdapter && object2 instanceof StatusAdapter) {
            return this.compare((StatusAdapter)object, (StatusAdapter)object2);
        }
        if (object.hashCode() < object2.hashCode()) {
            return -1;
        }
        if (object2.hashCode() > object2.hashCode()) {
            return 1;
        }
        return 0;
    }

    private boolean isMulti() {
        return ((Collection)this.dialogState.get(IStatusDialogConstants.STATUS_ADAPTERS)).size() > 1;
    }

    public ITableLabelProvider getLabelProvider() {
        ITableLabelProvider iTableLabelProvider = (ITableLabelProvider)this.dialogState.get(IStatusDialogConstants.CUSTOM_LABEL_PROVIDER);
        if (iTableLabelProvider != null) {
            this.labelProvider = iTableLabelProvider;
        }
        if (this.labelProvider == null) {
            this.labelProvider = new DefaultLabelProvider();
        }
        return this.labelProvider;
    }

    private class DefaultLabelProvider
    implements ITableLabelProvider {
        ResourceManager manager = new LocalResourceManager(JFaceResources.getResources());

        private DefaultLabelProvider() {
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
            this.manager.dispose();
        }

        public Image getColumnImage(Object object, int n) {
            StatusAdapter statusAdapter;
            Job job;
            Image image = null;
            if (object != null && (job = (Job)(statusAdapter = (StatusAdapter)object).getAdapter(Job.class)) != null) {
                image = this.getIcon(job);
            }
            if (image != null && image.isDisposed()) {
                image = null;
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            Object object2;
            StatusAdapter statusAdapter = (StatusAdapter)object;
            String string = WorkbenchMessages.WorkbenchStatusDialog_ProblemOccurred;
            string = !LabelProviderWrapper.this.isMulti() ? ((object2 = (Job)statusAdapter.getAdapter(Job.class)) != null ? LabelProviderWrapper.this.getPrimaryMessage(statusAdapter) : LabelProviderWrapper.this.getSecondaryMessage(statusAdapter)) : ((object2 = (Job)statusAdapter.getAdapter(Job.class)) != null ? object2.getName() : LabelProviderWrapper.this.getPrimaryMessage(statusAdapter));
            object2 = (Long)statusAdapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY);
            if (object2 != null && LabelProviderWrapper.this.isMulti()) {
                String string2 = DateFormat.getDateTimeInstance((int)1, (int)1).format(new Date((Long)object2));
                return NLS.bind((String)ProgressMessages.JobInfo_Error, (Object[])new Object[]{string, string2});
            }
            return string;
        }

        private Image getIcon(Job job) {
            if (job != null) {
                Object object = job.getProperty(IProgressConstants.ICON_PROPERTY);
                if (object instanceof ImageDescriptor) {
                    return this.manager.createImage((ImageDescriptor)object);
                }
                if (object instanceof URL) {
                    return this.manager.createImage(ImageDescriptor.createFromURL((URL)((URL)object)));
                }
                return ProgressManager.getInstance().getIconFor(job);
            }
            return null;
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

