/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.DetailsAreaManager;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.internal.statushandlers.LabelProviderWrapper;
import org.eclipse.ui.internal.statushandlers.SupportTray;
import org.eclipse.ui.internal.statushandlers.WorkbenchStatusDialogManagerImpl;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IViewDescriptor;

public class InternalDialog
extends TrayDialog {
    static final int GOTO_ACTION_ID = 1025;
    static final String LOG_VIEW_ID = "org.eclipse.pde.runtime.LogView";
    static final String PREF_SKIP_GOTO_ACTION_PROMPT = "pref_skip_goto_action_prompt";
    private Composite dialogArea;
    private Composite listArea;
    private Composite singleStatusDisplayArea;
    private Label singleStatusLabel;
    private TableViewer statusListViewer;
    private Composite linkComposite;
    private Link launchTrayLink;
    private Link showErrorLogLink;
    private Label titleImageLabel;
    private Label mainMessageLabel;
    private Composite titleArea;
    private SupportTray supportTray;
    private DetailsAreaManager detailsManager;
    private Map dialogState;

    public InternalDialog(final Map map, boolean bl) {
        super(ProgressManagerUtil.getDefaultParent());
        this.dialogState = map;
        this.supportTray = new SupportTray(map, new Listener(){

            public void handleEvent(Event event) {
                map.put(IStatusDialogConstants.TRAY_OPENED, Boolean.FALSE);
                InternalDialog.this.closeTray();
                InternalDialog.this.getShell().setFocus();
            }
        });
        this.detailsManager = new DetailsAreaManager(map);
        this.setShellStyle(0x490 | this.getShellStyle());
        this.setBlockOnOpen(false);
        if (!bl) {
            this.setShellStyle(0xFFFEFFFF & this.getShellStyle());
        }
    }

    protected void buttonPressed(int n) {
        IAction iAction;
        if (n == 1025 && (iAction = this.getGotoAction()) != null && this.isPromptToClose()) {
            this.okPressed();
            iAction.run();
        }
        if (n == 13) {
            this.dialogState.put(IStatusDialogConstants.DETAILS_OPENED, new Boolean(this.toggleDetailsArea()));
        } else {
            super.buttonPressed(n);
        }
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getString(IStatusDialogConstants.TITLE));
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        int n = this.convertHorizontalDLUsToPixels(61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
    }

    protected Control createDialogArea(Composite composite) {
        this.createTitleArea(composite);
        this.createListArea(composite);
        this.dialogArea = composite;
        Dialog.applyDialogFont((Control)this.dialogArea);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    private void createTitleArea(Composite composite) {
        this.titleArea = new Composite(composite, 0);
        this.titleArea.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 0;
        this.titleArea.setLayout((Layout)gridLayout);
        this.titleImageLabel = new Label(this.titleArea, 0);
        this.titleImageLabel.setImage(this.getLabelProviderWrapper().getImage(this.getCurrentStatusAdapter()));
        GridData gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.verticalAlignment = 128;
        this.titleImageLabel.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.widthHint = this.convertWidthInCharsToPixels(50);
        this.mainMessageLabel = new Label(this.titleArea, 64);
        this.mainMessageLabel.setLayoutData((Object)gridData2);
        this.mainMessageLabel.setText(this.getLabelProviderWrapper().getMainMessage(this.getCurrentStatusAdapter()));
        if (!this.isMulti()) {
            this.singleStatusDisplayArea = this.createSingleStatusDisplayArea(this.titleArea);
        }
    }

    private void createListArea(Composite composite) {
        this.listArea = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        this.listArea.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        this.listArea.setLayout((Layout)gridLayout);
        if (this.isMulti()) {
            this.fillListArea(this.listArea);
        }
    }

    public boolean isModal() {
        return (this.getShellStyle() & 0x10000) == 65536;
    }

    public SupportTray getSupportTray() {
        return this.supportTray;
    }

    public void setSupportTray(SupportTray supportTray) {
        this.supportTray = supportTray;
    }

    public int open() {
        boolean bl = this.getBooleanValue(IStatusDialogConstants.MODALITY_SWITCH);
        int n = super.open();
        if (bl) {
            if (this.getBooleanValue(IStatusDialogConstants.DETAILS_OPENED)) {
                this.showDetailsArea();
            }
            if (this.getBooleanValue(IStatusDialogConstants.TRAY_OPENED)) {
                this.openTray();
            }
        } else if (this.getBooleanValue(IStatusDialogConstants.ANIMATION)) {
            Rectangle rectangle = this.getShell().getBounds();
            ProgressManagerUtil.animateUp(rectangle);
        }
        return n;
    }

    public void closeTray() throws IllegalStateException {
        if (this.getTray() != null) {
            super.closeTray();
        }
        if (!this.getBooleanValue(IStatusDialogConstants.MODALITY_SWITCH)) {
            this.dialogState.put(IStatusDialogConstants.TRAY_OPENED, Boolean.FALSE);
        }
        if (this.launchTrayLink != null && !this.launchTrayLink.isDisposed()) {
            this.launchTrayLink.setEnabled(this.providesSupport() && !this.getBooleanValue(IStatusDialogConstants.TRAY_OPENED));
        }
    }

    void refresh() {
        if (this.dialogArea == null || this.dialogArea.isDisposed()) {
            return;
        }
        this.updateTitleArea();
        this.updateListArea();
        this.updateEnablements();
        Point point = this.getShell().getSize();
        Point point2 = this.getShell().computeSize(-1, -1);
        if (point.x < point2.x) {
            this.getShell().setSize(point2.x, point.y);
        } else {
            this.getShell().layout();
        }
    }

    void refreshDialogSize() {
        Point point = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(point);
    }

    private void showDetailsArea() {
        if (this.dialogArea != null && !this.dialogArea.isDisposed()) {
            if (this.detailsManager.isOpen()) {
                this.detailsManager.close();
                this.detailsManager.createDetailsArea(this.dialogArea, this.getCurrentStatusAdapter());
                this.dialogState.put(IStatusDialogConstants.DETAILS_OPENED, Boolean.TRUE);
            } else {
                this.toggleDetailsArea();
                this.dialogState.put(IStatusDialogConstants.DETAILS_OPENED, Boolean.TRUE);
            }
            this.dialogArea.layout();
        }
    }

    private boolean toggleDetailsArea() {
        boolean bl = false;
        Point point = this.getShell().getSize();
        if (this.detailsManager.isOpen()) {
            this.detailsManager.close();
            this.getButton(13).setText(IDialogConstants.SHOW_DETAILS_LABEL);
            bl = false;
        } else {
            this.detailsManager.createDetailsArea(this.dialogArea, this.getCurrentStatusAdapter());
            this.getButton(13).setText(IDialogConstants.HIDE_DETAILS_LABEL);
            bl = true;
        }
        GridData gridData = (GridData)this.listArea.getLayoutData();
        if (!this.isMulti()) {
            gridData.heightHint = 0;
        }
        gridData.grabExcessVerticalSpace = !bl;
        this.listArea.setLayoutData((Object)gridData);
        Point point2 = this.getShell().computeSize(-1, -1);
        int n = point2.y - point.y;
        if (bl && n > 0 || !bl && n < 0) {
            this.getShell().setSize(new Point(point.x, point.y + n));
        }
        this.dialogArea.layout();
        return bl;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.refreshDialogSize();
        boolean bl = this.getBooleanValue(IStatusDialogConstants.MODALITY_SWITCH);
        if (bl) {
            this.getShell().setBounds(this.getShellBounds());
        }
    }

    public Point getInitialLocation(Point point) {
        return super.getInitialLocation(point);
    }

    private void handleSelectionChange() {
        StatusAdapter statusAdapter = this.getSingleSelection();
        if (statusAdapter != null) {
            this.dialogState.put(IStatusDialogConstants.CURRENT_STATUS_ADAPTER, statusAdapter);
            this.showDetailsArea();
            this.refresh();
        }
    }

    private void fillListArea(Composite composite) {
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        if (!this.detailsManager.isOpen()) {
            gridData.grabExcessVerticalSpace = true;
        }
        gridData.heightHint = -1;
        this.statusListViewer = new TableViewer(composite, 2820);
        this.statusListViewer.setComparator((ViewerComparator)this.getLabelProviderWrapper());
        Control control = this.statusListViewer.getControl();
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData2);
        this.initContentProvider();
        this.initLabelProvider();
        this.statusListViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                InternalDialog.this.handleSelectionChange();
                if (InternalDialog.this.getTray() == null && InternalDialog.this.getBooleanValue(IStatusDialogConstants.TRAY_OPENED) && InternalDialog.this.providesSupport()) {
                    InternalDialog.this.silentTrayOpen();
                    return;
                }
                if (InternalDialog.this.getTray() != null && !InternalDialog.this.providesSupport()) {
                    InternalDialog.this.silentTrayClose();
                    return;
                }
                InternalDialog.this.supportTray.selectionChanged(selectionChangedEvent);
            }
        });
        Dialog.applyDialogFont((Control)composite);
    }

    private void silentTrayClose() {
        super.closeTray();
    }

    private void silentTrayOpen() {
        if (this.getTray() == null) {
            super.openTray((DialogTray)this.supportTray);
        }
    }

    private void updateListArea() {
        if (this.isMulti()) {
            if (this.singleStatusDisplayArea != null) {
                this.singleStatusDisplayArea.dispose();
            }
            if (this.statusListViewer == null || this.statusListViewer.getControl().isDisposed()) {
                this.fillListArea(this.listArea);
                this.listArea.layout();
                this.listArea.getParent().layout();
                this.getShell().setSize(this.getShell().computeSize(-1, -1));
            }
            this.refreshStatusListArea();
        }
    }

    private void updateTitleArea() {
        Image image = this.getLabelProviderWrapper().getImage(this.getCurrentStatusAdapter());
        this.titleImageLabel.setImage(image);
        if (this.getCurrentStatusAdapter() != null) {
            this.mainMessageLabel.setText(this.getLabelProviderWrapper().getMainMessage(this.getCurrentStatusAdapter()));
        }
        if (this.singleStatusDisplayArea != null) {
            if (this.isMulti()) {
                this.singleStatusDisplayArea.dispose();
            } else {
                this.refreshSingleStatusArea();
            }
        }
        this.titleArea.layout();
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.linkComposite = this.createLinkComposite(composite2);
        this.createButtonsForButtonBar(composite2);
        composite2.layout();
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        IAction iAction = this.getGotoAction();
        String string = null;
        if (iAction != null) {
            string = iAction.getText();
        }
        Button button = this.createButton(composite, 1025, string == null ? "" : string, false);
        if (string == null) {
            this.hideButton(button, true);
        }
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
    }

    private Composite createSingleStatusDisplayArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        composite2.setLayoutData((Object)gridData);
        this.singleStatusLabel = new Label(composite2, 64);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.widthHint = this.convertWidthInCharsToPixels(50);
        this.singleStatusLabel.setLayoutData((Object)gridData2);
        this.singleStatusLabel.setText(this.getLabelProviderWrapper().getColumnText(this.getCurrentStatusAdapter(), 0));
        this.singleStatusLabel.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                InternalDialog.this.showDetailsArea();
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        return composite2;
    }

    public boolean close() {
        boolean bl = this.getBooleanValue(IStatusDialogConstants.MODALITY_SWITCH);
        if (this.detailsManager.isOpen()) {
            this.dialogState.put(IStatusDialogConstants.DETAILS_OPENED, Boolean.TRUE);
            this.toggleDetailsArea();
        }
        if (this.getBooleanValue(IStatusDialogConstants.TRAY_OPENED)) {
            this.closeTray();
            if (bl) {
                this.dialogState.put(IStatusDialogConstants.DETAILS_OPENED, Boolean.TRUE);
            }
        }
        this.dialogState.put(IStatusDialogConstants.SHELL_BOUNDS, this.getShell().getBounds());
        this.statusListViewer = null;
        boolean bl2 = super.close();
        if (!bl && this.getBooleanValue(IStatusDialogConstants.ANIMATION)) {
            ProgressManagerUtil.animateDown(this.getShellBounds());
        }
        return bl2;
    }

    private void hideButton(Button button, boolean bl) {
        ((GridData)button.getLayoutData()).exclude = bl;
        button.setVisible(!bl);
        button.setEnabled(!bl);
    }

    private void updateEnablements() {
        Object object;
        Button button;
        Button button2 = this.getButton(13);
        if (button2 != null) {
            button2.setEnabled(true);
        }
        if ((button = this.getButton(1025)) != null) {
            boolean bl;
            object = this.getGotoAction();
            boolean bl2 = bl = object != null && object.getText() != null;
            if (bl) {
                this.hideButton(button, false);
                button.setText(object.getText());
                ((GridData)button.getLayoutData()).widthHint = button.computeSize((int)-1, (int)-1).x;
                button.getParent().layout();
            } else {
                this.hideButton(button, true);
            }
        }
        if (this.providesSupport() && !this.getBooleanValue(IStatusDialogConstants.HIDE_SUPPORT_BUTTON)) {
            if (this.launchTrayLink == null || this.launchTrayLink.isDisposed()) {
                this.launchTrayLink = this.createGetSupportLink();
            }
            this.launchTrayLink.setEnabled(!this.getBooleanValue(IStatusDialogConstants.TRAY_OPENED));
        } else if (this.launchTrayLink != null && !this.launchTrayLink.isDisposed()) {
            this.launchTrayLink.dispose();
            this.launchTrayLink = null;
        }
        object = this.shouldDisplayLinkToErrorLog();
        if (object != null) {
            if (this.showErrorLogLink == null || this.showErrorLogLink.isDisposed()) {
                this.showErrorLogLink = this.createShowErrorLogLink();
            }
        } else if (this.showErrorLogLink != null && !this.showErrorLogLink.isDisposed()) {
            this.showErrorLogLink.dispose();
        }
        this.linkComposite.getParent().layout();
    }

    private IViewDescriptor shouldDisplayLinkToErrorLog() {
        if (!this.getBooleanValue(IStatusDialogConstants.ERRORLOG_LINK)) {
            return null;
        }
        boolean bl = false;
        for (StatusAdapter statusAdapter : (Collection)this.dialogState.get(IStatusDialogConstants.STATUS_ADAPTERS)) {
            Integer n = (Integer)statusAdapter.getProperty(WorkbenchStatusDialogManagerImpl.HINT);
            if (n == null || (n & 1) == 0) continue;
            bl |= true;
            break;
        }
        if (!bl) {
            return null;
        }
        return Workbench.getInstance().getViewRegistry().find(LOG_VIEW_ID);
    }

    public void openTray(DialogTray dialogTray) throws IllegalStateException, UnsupportedOperationException {
        if (this.launchTrayLink != null && !this.launchTrayLink.isDisposed()) {
            this.launchTrayLink.setEnabled(false);
        }
        if (this.providesSupport()) {
            super.openTray(dialogTray);
        }
        this.dialogState.put(IStatusDialogConstants.TRAY_OPENED, Boolean.TRUE);
    }

    private void refreshSingleStatusArea() {
        String string = this.getLabelProviderWrapper().getColumnText(this.getCurrentStatusAdapter(), 0);
        if (string.equals(this.singleStatusLabel.getText())) {
            this.singleStatusLabel.setText(" ");
        }
        this.singleStatusLabel.setText(string);
        this.singleStatusDisplayArea.layout();
        this.getShell().setText(this.getString(IStatusDialogConstants.TITLE));
    }

    private void refreshStatusListArea() {
        if (this.statusListViewer != null && !this.statusListViewer.getControl().isDisposed()) {
            this.statusListViewer.refresh();
            if (this.statusListViewer.getTable().getItemCount() > 1) {
                this.getShell().setText(WorkbenchMessages.WorkbenchStatusDialog_MultipleProblemsHaveOccured);
            } else {
                this.getShell().setText(this.getString(IStatusDialogConstants.TITLE));
            }
        }
    }

    private void initContentProvider() {
        IStructuredContentProvider iStructuredContentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return ((Collection)InternalDialog.this.dialogState.get(IStatusDialogConstants.STATUS_ADAPTERS)).toArray();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
                if (object2 != null) {
                    InternalDialog.this.refreshStatusListArea();
                }
            }
        };
        this.statusListViewer.setContentProvider((IContentProvider)iStructuredContentProvider);
        this.statusListViewer.setInput((Object)this);
        this.statusListViewer.setSelection((ISelection)new StructuredSelection((Object)this.getCurrentStatusAdapter()));
    }

    private Composite createLinkComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0){

            public Point computeSize(int n, int n2, boolean bl) {
                Point point = super.computeSize(n, n2, bl);
                if (this.getChildren().length == 0) {
                    point.x = 0;
                    point.y = 0;
                }
                return point;
            }
        };
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        ++((GridLayout)composite.getLayout()).numColumns;
        GridData gridData = new GridData(1, 0x1000000, true, false);
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    private Link createGetSupportLink() {
        if (!this.providesSupport() || this.getBooleanValue(IStatusDialogConstants.HIDE_SUPPORT_BUTTON)) {
            return null;
        }
        Link link = new Link(this.linkComposite, 0);
        link.setText(WorkbenchMessages.WorkbenchStatusDialog_SupportHyperlink);
        link.setToolTipText(WorkbenchMessages.WorkbenchStatusDialog_SupportTooltip);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InternalDialog.this.openTray();
            }
        });
        Dialog.applyDialogFont((Control)link);
        return link;
    }

    private Link createShowErrorLogLink() {
        Link link = new Link(this.linkComposite, 0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().showView(InternalDialog.LOG_VIEW_ID);
                }
                catch (CoreException coreException) {
                    StatusManager.getManager().handle(coreException, WorkbenchPlugin.PI_WORKBENCH);
                }
            }
        });
        link.setText(WorkbenchMessages.ErrorLogUtil_ShowErrorLogHyperlink);
        link.setToolTipText(WorkbenchMessages.ErrorLogUtil_ShowErrorLogTooltip);
        Dialog.applyDialogFont((Control)link);
        return link;
    }

    private void initLabelProvider() {
        this.statusListViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProviderWrapper());
    }

    private IAction getGotoAction() {
        Object object = null;
        Job job = (Job)this.getCurrentStatusAdapter().getAdapter(Job.class);
        if (job != null) {
            object = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        }
        if (object instanceof IAction) {
            return (IAction)object;
        }
        return null;
    }

    private StatusAdapter getSingleSelection() {
        IStructuredSelection iStructuredSelection;
        ISelection iSelection = this.statusListViewer.getSelection();
        if (iSelection != null && iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
            return (StatusAdapter)iStructuredSelection.getFirstElement();
        }
        return null;
    }

    private boolean isPromptToClose() {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (!iPreferenceStore.contains(PREF_SKIP_GOTO_ACTION_PROMPT) || !iPreferenceStore.getString(PREF_SKIP_GOTO_ACTION_PROMPT).equals("always")) {
            MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.open((int)5, (Shell)this.getShell(), (String)ProgressMessages.JobErrorDialog_CloseDialogTitle, (String)ProgressMessages.JobErrorDialog_CloseDialogMessage, (String)ProgressMessages.JobErrorDialog_DoNotShowAgainMessage, (boolean)false, (IPreferenceStore)iPreferenceStore, (String)PREF_SKIP_GOTO_ACTION_PROMPT, (int)0x10000000);
            return messageDialogWithToggle.getReturnCode() == 0;
        }
        return true;
    }

    public void openTray() {
        this.openTray(this.supportTray);
    }

    public boolean providesSupport() {
        return this.supportTray.providesSupport(this.getCurrentStatusAdapter()) != null;
    }

    private String getString(Object object) {
        return (String)this.dialogState.get(object);
    }

    private StatusAdapter getCurrentStatusAdapter() {
        return (StatusAdapter)this.dialogState.get(IStatusDialogConstants.CURRENT_STATUS_ADAPTER);
    }

    private boolean getBooleanValue(Object object) {
        Boolean bl = (Boolean)this.dialogState.get(object);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private Rectangle getShellBounds() {
        return (Rectangle)this.dialogState.get(IStatusDialogConstants.SHELL_BOUNDS);
    }

    private LabelProviderWrapper getLabelProviderWrapper() {
        return (LabelProviderWrapper)((Object)this.dialogState.get(IStatusDialogConstants.LABEL_PROVIDER));
    }

    private boolean isMulti() {
        return ((Collection)this.dialogState.get(IStatusDialogConstants.STATUS_ADAPTERS)).size() > 1;
    }
}

