/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class DefaultDetailsArea
extends AbstractStatusAreaProvider {
    private static final int MINIMUM_HEIGHT = 100;
    private int mask;
    private static final int NESTING_INDENT = 15;
    private StyledText text;
    private boolean handleOkStatuses;
    private Map dialogState;
    private MenuItem copyAction;

    public DefaultDetailsArea(Map map) {
        this.dialogState = map;
        this.handleOkStatuses = (Boolean)map.get(IStatusDialogConstants.HANDLE_OK_STATUSES);
        this.mask = (Integer)map.get(IStatusDialogConstants.MASK);
    }

    @Override
    public Control createSupportArea(Composite composite, StatusAdapter statusAdapter) {
        Composite composite2 = this.createArea(composite);
        this.setStatusAdapter(statusAdapter);
        return composite2;
    }

    protected Composite createArea(Composite composite) {
        composite = new Composite(composite, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text = new StyledText(composite, 2890);
        this.text.setBackground(composite.getDisplay().getSystemColor(1));
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 250;
        gridData.minimumHeight = 100;
        this.text.setLayoutData((Object)gridData);
        IBindingService iBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        final TriggerSequence[] triggerSequenceArray = iBindingService.getActiveBindingsFor(ActionFactory.COPY.getCommandId());
        this.text.addKeyListener(new KeyListener(){
            ArrayList keyList = new ArrayList();

            public void keyPressed(KeyEvent keyEvent) {
                boolean bl;
                int n = keyEvent.character;
                boolean bl2 = bl = (keyEvent.stateMask & 0x40000) != 0;
                if (bl && keyEvent.character != keyEvent.keyCode && keyEvent.character < ' ' && (keyEvent.keyCode & 0x1000000) == 0) {
                    n = (char)(n + 64);
                }
                if ((keyEvent.keyCode & ~SWT.MODIFIER_MASK) == 0) {
                    return;
                }
                KeyStroke keyStroke = KeyStroke.getInstance((int)keyEvent.stateMask, (int)(n != 0 ? n : keyEvent.keyCode));
                this.keyList.add(keyStroke);
                KeySequence keySequence = KeySequence.getInstance((List)this.keyList);
                boolean bl3 = false;
                int n2 = 0;
                while (n2 < triggerSequenceArray.length) {
                    if (triggerSequenceArray[n2].equals((Object)keySequence)) {
                        DefaultDetailsArea.this.copyToClipboard();
                        this.keyList.clear();
                        break;
                    }
                    if (triggerSequenceArray[n2].startsWith((TriggerSequence)keySequence, false)) {
                        bl3 = true;
                    }
                    int n3 = 0;
                    while (n3 < triggerSequenceArray[n2].getTriggers().length) {
                        if (triggerSequenceArray[n2].getTriggers()[n3].equals((Object)keyStroke)) {
                            bl3 = true;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                if (!bl3) {
                    this.keyList.clear();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.text.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DefaultDetailsArea.this.text.getSelectionText().length() == 0) {
                    if (DefaultDetailsArea.this.copyAction != null && !DefaultDetailsArea.this.copyAction.isDisposed()) {
                        DefaultDetailsArea.this.copyAction.setEnabled(false);
                    }
                } else if (DefaultDetailsArea.this.copyAction != null && !DefaultDetailsArea.this.copyAction.isDisposed()) {
                    DefaultDetailsArea.this.copyAction.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        this.createDNDSource();
        this.createCopyAction(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void setStatusAdapter(StatusAdapter statusAdapter) {
        Long l;
        this.populateList(this.text, statusAdapter.getStatus(), 0, new int[1]);
        if (!this.isMulti() && (l = (Long)statusAdapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY)) != null) {
            String string = DateFormat.getDateTimeInstance((int)1, (int)1).format(new Date(l));
            this.text.append(NLS.bind((String)ProgressMessages.JobInfo_Error, (Object[])new Object[]{"", string}));
        }
        int n = this.getLineSeparator().length();
        this.text.replaceTextRange(this.text.getText().length() - n, n, "");
        this.adjustHeight(this.text);
    }

    private void adjustHeight(StyledText styledText) {
        int n = styledText.getLineCount();
        int n2 = styledText.getLineHeight();
        int n3 = styledText.getLocation().y;
        Composite composite = styledText.getParent();
        while (composite != null) {
            n3 += composite.getLocation().y;
            composite = composite.getParent();
        }
        int n4 = styledText.getShell().getMonitor().getBounds().height;
        int n5 = n4 - (n3 += styledText.getShell().getBounds().height);
        if (n5 <= 100) {
            return;
        }
        int n6 = n * n2;
        if ((double)n6 > (double)n5 * 0.75) {
            ((GridData)styledText.getLayoutData()).heightHint = (int)((double)n5 * 0.75);
        }
    }

    private void createDNDSource() {
        DragSource dragSource = new DragSource((Control)this.text, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent dragSourceEvent) {
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = DefaultDetailsArea.this.text.getSelectionText();
                }
            }

            public void dragStart(DragSourceEvent dragSourceEvent) {
            }
        });
    }

    private void createCopyAction(Composite composite) {
        Menu menu = new Menu((Decorations)composite.getShell(), 8);
        this.copyAction = new MenuItem(menu, 8);
        this.copyAction.setText(JFaceResources.getString((String)"copy"));
        this.copyAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DefaultDetailsArea.this.copyToClipboard();
                super.widgetSelected(selectionEvent);
            }
        });
        this.text.setMenu(menu);
        if (this.text.getSelectionText().length() == 0) {
            this.copyAction.setEnabled(false);
        }
    }

    private void populateList(StyledText styledText, IStatus iStatus, int n, int[] nArray) {
        Object object;
        if (!(iStatus.matches(this.mask) || this.handleOkStatuses && iStatus.isOK())) {
            return;
        }
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        this.appendNewLine(styledText, iStatus.getMessage(), n, n2);
        Throwable throwable = iStatus.getException();
        if (throwable instanceof CoreException) {
            object = (CoreException)throwable;
            this.populateList(styledText, object.getStatus(), n + 1, nArray);
        } else if (throwable != null) {
            object = throwable.getLocalizedMessage();
            if (object == null) {
                object = throwable.toString();
            }
            int n3 = nArray[0];
            nArray[0] = n3 + 1;
            this.appendNewLine(styledText, (String)object, n, n3);
        }
        object = iStatus.getChildren();
        int n4 = 0;
        while (n4 < ((IStatus[])object).length) {
            this.populateList(styledText, object[n4], n + 1, nArray);
            ++n4;
        }
    }

    private String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    private void appendNewLine(StyledText styledText, String string, int n, int n2) {
        styledText.append(String.valueOf(string) + this.getLineSeparator());
        int n3 = n * 15;
        if (n2 != 0) {
            n3 += 7;
        }
        styledText.setLineIndent(n2, 1, n3);
        styledText.setLineWrapIndent(n2, 1, n * 15);
    }

    private void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.text.getDisplay());
            clipboard.setContents(new Object[]{this.text.getSelectionText()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private boolean isMulti() {
        return ((Collection)this.dialogState.get(IStatusDialogConstants.STATUS_ADAPTERS)).size() != 1;
    }
}

