/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;

public class WorkbenchSourceProvider
extends AbstractSourceProvider
implements INullSelectionListener {
    private static final String STATUS_LINE_VIS = "activeWorkbenchWindow.isStatusLineVisible";
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"selection", "activeEditorId", "activeEditor", "activePartId", "activePart", "activeSite", "showInSelection", "showInInput", "activeShell", "activeWorkbenchWindow", "activeWorkbenchWindowShell", "activeWorkbenchWindow.isCoolbarVisible", "activeWorkbenchWindow.isPerspectiveBarVisible", "activeWorkbenchWindow.activePerspective", "activeWorkbenchWindow.isStatusLineVisible"};
    private IWorkbench workbench;
    private IWorkbenchWindow lastWindow;
    ISelection selection;
    private IEditorPart lastActiveEditor = null;
    private String lastActiveEditorId = null;
    private IWorkbenchPart lastActivePart = null;
    private String lastActivePartId = null;
    private IWorkbenchPartSite lastActivePartSite = null;
    private Object lastShowInInput = null;
    private final IPartListener partListener = new IPartListener(){

        @Override
        public final void partActivated(IWorkbenchPart iWorkbenchPart) {
            WorkbenchSourceProvider.this.checkActivePart();
        }

        @Override
        public final void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            WorkbenchSourceProvider.this.checkActivePart();
        }

        @Override
        public final void partClosed(IWorkbenchPart iWorkbenchPart) {
            WorkbenchSourceProvider.this.checkActivePart();
        }

        @Override
        public final void partDeactivated(IWorkbenchPart iWorkbenchPart) {
            WorkbenchSourceProvider.this.checkActivePart();
        }

        @Override
        public final void partOpened(IWorkbenchPart iWorkbenchPart) {
            WorkbenchSourceProvider.this.checkActivePart();
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        @Override
        public final void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            WorkbenchSourceProvider.this.checkActivePart();
        }

        @Override
        public final void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow != null) {
                iWorkbenchWindow.getPartService().removePartListener(WorkbenchSourceProvider.this.partListener);
            }
            WorkbenchSourceProvider.this.checkActivePart();
        }

        @Override
        public final void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
            WorkbenchSourceProvider.this.checkActivePart();
        }

        @Override
        public final void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow != null) {
                iWorkbenchWindow.getPartService().addPartListener(WorkbenchSourceProvider.this.partListener);
            }
        }
    };
    private IEditorInput lastEditorInput;
    private Display display;
    private Shell lastActiveShell = null;
    private Shell lastActiveWorkbenchWindowShell = null;
    private WorkbenchWindow lastActiveWorkbenchWindow = null;
    private Boolean lastCoolbarVisibility = Boolean.FALSE;
    private Boolean lastPerspectiveBarVisibility = Boolean.FALSE;
    private Boolean lastStatusLineVisibility = Boolean.FALSE;
    private String lastPerspectiveId = null;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("coolbarVisible".equals(propertyChangeEvent.getProperty())) {
                Object object = propertyChangeEvent.getNewValue();
                if (object == null || !(object instanceof Boolean)) {
                    return;
                }
                if (!WorkbenchSourceProvider.this.lastCoolbarVisibility.equals(object)) {
                    WorkbenchSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.isCoolbarVisible", object);
                    WorkbenchSourceProvider.this.lastCoolbarVisibility = (Boolean)object;
                }
            } else if ("perspectiveBarVisible".equals(propertyChangeEvent.getProperty())) {
                Object object = propertyChangeEvent.getNewValue();
                if (object == null || !(object instanceof Boolean)) {
                    return;
                }
                if (!WorkbenchSourceProvider.this.lastPerspectiveBarVisibility.equals(object)) {
                    WorkbenchSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.isPerspectiveBarVisible", object);
                    WorkbenchSourceProvider.this.lastPerspectiveBarVisibility = (Boolean)object;
                }
            } else if ("statusLineVisible".equals(propertyChangeEvent.getProperty())) {
                Object object = propertyChangeEvent.getNewValue();
                if (object == null || !(object instanceof Boolean)) {
                    return;
                }
                if (!WorkbenchSourceProvider.this.lastStatusLineVisibility.equals(object)) {
                    WorkbenchSourceProvider.this.fireSourceChanged(32768, WorkbenchSourceProvider.STATUS_LINE_VIS, object);
                    WorkbenchSourceProvider.this.lastStatusLineVisibility = (Boolean)object;
                }
            }
        }
    };
    IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        @Override
        public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            String string;
            String string2 = string = iPerspectiveDescriptor == null ? null : iPerspectiveDescriptor.getId();
            if (Util.equals(WorkbenchSourceProvider.this.lastPerspectiveId, string)) {
                return;
            }
            WorkbenchSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.activePerspective", string);
            WorkbenchSourceProvider.this.lastPerspectiveId = string;
        }

        @Override
        public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
        }
    };
    private IPropertyListener editorListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (n == 258) {
                WorkbenchSourceProvider.this.handleInputChanged((IEditorPart)object);
            }
        }
    };
    private final Listener listener = new Listener(){

        public final void handleEvent(Event event) {
            boolean bl;
            IPerspectiveDescriptor iPerspectiveDescriptor;
            IWorkbenchPage iWorkbenchPage;
            Boolean bl2;
            Boolean bl3;
            if (!(event.widget instanceof Shell)) {
                if (DEBUG) {
                    WorkbenchSourceProvider.this.logDebuggingInfo("WSP: passOnEvent: " + event.widget);
                }
                return;
            }
            if (DEBUG) {
                WorkbenchSourceProvider.this.logDebuggingInfo("\tWSP:lastActiveShell: " + WorkbenchSourceProvider.this.lastActiveShell);
                WorkbenchSourceProvider.this.logDebuggingInfo("\tWSP:lastActiveWorkbenchWindowShell" + WorkbenchSourceProvider.this.lastActiveWorkbenchWindowShell);
            }
            Map map = WorkbenchSourceProvider.this.getCurrentState();
            Shell shell = (Shell)map.get("activeShell");
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)map.get("activeWorkbenchWindow");
            Shell shell2 = (Shell)map.get("activeWorkbenchWindowShell");
            Boolean bl4 = workbenchWindow == null ? WorkbenchSourceProvider.this.lastCoolbarVisibility : (bl3 = workbenchWindow.getCoolBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            Boolean bl5 = workbenchWindow == null ? WorkbenchSourceProvider.this.lastPerspectiveBarVisibility : (bl2 = workbenchWindow.getPerspectiveBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            Boolean bl6 = workbenchWindow == null ? WorkbenchSourceProvider.this.lastStatusLineVisibility : (workbenchWindow.getStatusLineVisible() ? Boolean.TRUE : Boolean.FALSE);
            String string = WorkbenchSourceProvider.this.lastPerspectiveId;
            if (workbenchWindow != null && (iWorkbenchPage = workbenchWindow.getActivePage()) != null && (iPerspectiveDescriptor = iWorkbenchPage.getPerspective()) != null) {
                string = iPerspectiveDescriptor.getId();
            }
            boolean bl7 = shell != WorkbenchSourceProvider.this.lastActiveShell;
            boolean bl8 = shell2 != WorkbenchSourceProvider.this.lastActiveWorkbenchWindowShell;
            boolean bl9 = bl3 != WorkbenchSourceProvider.this.lastCoolbarVisibility;
            boolean bl10 = bl6 != WorkbenchSourceProvider.this.lastStatusLineVisibility;
            boolean bl11 = bl2 != WorkbenchSourceProvider.this.lastPerspectiveBarVisibility;
            boolean bl12 = bl = !Util.equals(WorkbenchSourceProvider.this.lastPerspectiveId, string);
            if (bl7 && bl8) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
                hashMap.put("activeShell", shell);
                hashMap.put("activeWorkbenchWindow", workbenchWindow);
                hashMap.put("activeWorkbenchWindowShell", shell2);
                int n = 17408;
                if (bl9) {
                    hashMap.put("activeWorkbenchWindow.isCoolbarVisible", bl3);
                    n |= 0x8000;
                }
                if (bl10) {
                    hashMap.put(WorkbenchSourceProvider.STATUS_LINE_VIS, bl6);
                    n |= 0x8000;
                }
                if (bl11) {
                    hashMap.put("activeWorkbenchWindow.isPerspectiveBarVisible", bl2);
                    n |= 0x8000;
                }
                if (bl) {
                    hashMap.put("activeWorkbenchWindow.activePerspective", string);
                    n |= 0x8000;
                }
                if (DEBUG) {
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active shell changed to " + shell);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + workbenchWindow);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + shell2);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window coolbar visibility " + bl3);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window perspective bar visibility " + bl2);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window status line visibility " + bl6);
                }
                WorkbenchSourceProvider.this.fireSourceChanged(n, hashMap);
                WorkbenchSourceProvider.this.hookListener(WorkbenchSourceProvider.this.lastActiveWorkbenchWindow, workbenchWindow);
            } else if (bl7) {
                if (DEBUG) {
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active shell changed to " + shell);
                }
                WorkbenchSourceProvider.this.fireSourceChanged(1024, "activeShell", shell);
            } else if (bl8) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                hashMap.put("activeWorkbenchWindow", workbenchWindow);
                hashMap.put("activeWorkbenchWindowShell", shell2);
                int n = 17408;
                if (bl9) {
                    hashMap.put("activeWorkbenchWindow.isCoolbarVisible", bl3);
                    n |= 0x8000;
                }
                if (bl10) {
                    hashMap.put(WorkbenchSourceProvider.STATUS_LINE_VIS, bl6);
                    n |= 0x8000;
                }
                if (bl11) {
                    hashMap.put("activeWorkbenchWindow.isPerspectiveBarVisible", bl2);
                    n |= 0x8000;
                }
                if (bl) {
                    hashMap.put("activeWorkbenchWindow.activePerspective", string);
                    n |= 0x8000;
                }
                if (DEBUG) {
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + workbenchWindow);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + shell2);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window coolbar visibility " + bl3);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window perspective bar visibility " + bl2);
                    WorkbenchSourceProvider.this.logDebuggingInfo("Active workbench window status line visibility " + bl6);
                }
                WorkbenchSourceProvider.this.fireSourceChanged(n, hashMap);
                WorkbenchSourceProvider.this.hookListener(WorkbenchSourceProvider.this.lastActiveWorkbenchWindow, workbenchWindow);
            }
            if (bl7 || bl8) {
                WorkbenchSourceProvider.this.checkOtherSources((Shell)event.widget);
            }
            WorkbenchSourceProvider.this.lastActiveShell = shell;
            WorkbenchSourceProvider.this.lastActiveWorkbenchWindowShell = shell2;
            WorkbenchSourceProvider.this.lastActiveWorkbenchWindow = workbenchWindow;
            WorkbenchSourceProvider.this.lastCoolbarVisibility = bl3;
            WorkbenchSourceProvider.this.lastStatusLineVisibility = bl6;
            WorkbenchSourceProvider.this.lastPerspectiveBarVisibility = bl2;
            WorkbenchSourceProvider.this.lastPerspectiveId = string;
        }
    };

    @Override
    public void initialize(IServiceLocator iServiceLocator) {
        super.initialize(iServiceLocator);
        IWorkbenchLocationService iWorkbenchLocationService = (IWorkbenchLocationService)iServiceLocator.getService(IWorkbenchLocationService.class);
        this.workbench = iWorkbenchLocationService.getWorkbench();
        this.workbench.addWindowListener(this.windowListener);
        this.lastWindow = this.workbench.getActiveWorkbenchWindow();
        this.display = this.workbench.getDisplay();
        this.display.addFilter(26, this.listener);
    }

    @Override
    public void dispose() {
        if (this.lastWindow != null) {
            this.lastWindow.getSelectionService().removeSelectionListener(this);
        }
        this.workbench.removeWindowListener(this.windowListener);
        this.display.removeFilter(26, this.listener);
        this.hookListener(this.lastActiveWorkbenchWindow, null);
        this.lastActiveWorkbenchWindow = null;
        this.lastActiveWorkbenchWindowShell = null;
        this.lastActiveShell = null;
        this.lastWindow = null;
    }

    @Override
    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    @Override
    public Map getCurrentState() {
        HashMap hashMap = new HashMap();
        this.updateActiveShell(hashMap);
        this.updateActivePart(hashMap);
        this.updateSelection(hashMap);
        return hashMap;
    }

    private int updateSelection(Map map) {
        IWorkbenchPart iWorkbenchPart;
        int n = 0;
        map.put("selection", IEvaluationContext.UNDEFINED_VARIABLE);
        Object v = map.get("activePart");
        if (v instanceof IWorkbenchPart && (iWorkbenchPart = (IWorkbenchPart)v).getSite() != null && iWorkbenchPart.getSite().getSelectionProvider() != null) {
            n = 0x40000000;
            ISelection iSelection = iWorkbenchPart.getSite().getSelectionProvider().getSelection();
            map.put("selection", iSelection);
        }
        return n;
    }

    @Override
    public final void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (Util.equals(this.selection, iSelection)) {
            return;
        }
        this.selection = iSelection;
        if (DEBUG) {
            this.logDebuggingInfo("Selection changed to " + this.selection);
        }
        this.fireSourceChanged(0x40000000, "selection", this.selection);
    }

    private final void updateWindows(IWorkbenchWindow iWorkbenchWindow) {
        if (this.lastWindow == iWorkbenchWindow) {
            return;
        }
        ISelection iSelection = null;
        if (this.lastWindow != null) {
            this.lastWindow.getSelectionService().removeSelectionListener(this);
        }
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.getSelectionService().addSelectionListener(this);
            iSelection = iWorkbenchWindow.getSelectionService().getSelection();
        }
        this.selectionChanged(null, iSelection);
        this.lastWindow = iWorkbenchWindow;
    }

    public void handleCheck(Shell shell) {
        if (shell != this.lastActiveShell) {
            this.lastActiveShell = shell;
            this.checkActivePart();
            IWorkbenchWindow iWorkbenchWindow = null;
            if (shell.getData() instanceof WorkbenchWindow) {
                iWorkbenchWindow = (IWorkbenchWindow)shell.getData();
            } else if (shell.getData() instanceof DetachedWindow) {
                iWorkbenchWindow = ((DetachedWindow)shell.getData()).getWorkbenchPage().getWorkbenchWindow();
            }
            this.updateWindows(iWorkbenchWindow);
        }
    }

    public final void checkActivePart() {
        this.checkActivePart(false);
    }

    public final void checkActivePart(boolean bl) {
        Object v;
        Object v2;
        Object v3;
        Object v4;
        Object v5;
        Object v6;
        HashMap hashMap = new HashMap();
        this.updateActivePart(hashMap, bl);
        int n = 0;
        Object v7 = hashMap.get("activePart");
        if (!Util.equals(v7, this.lastActivePart)) {
            n |= 0x100000;
            this.lastActivePart = v7 != IEvaluationContext.UNDEFINED_VARIABLE ? (IWorkbenchPart)v7 : null;
        }
        if (!Util.equals(v6 = hashMap.get("activePartId"), this.lastActivePartId)) {
            n |= 0x400000;
            this.lastActivePartId = v6 != IEvaluationContext.UNDEFINED_VARIABLE ? (String)v6 : null;
        }
        if (!Util.equals(v5 = hashMap.get("activeSite"), this.lastActivePartSite)) {
            n |= 0x4000000;
            this.lastActivePartSite = v5 != IEvaluationContext.UNDEFINED_VARIABLE ? (IWorkbenchPartSite)v5 : null;
        }
        if (!Util.equals(v4 = hashMap.get("showInInput"), this.lastShowInInput)) {
            n |= 0x4000000;
            this.lastShowInInput = v4;
        }
        if (hashMap.get("showInSelection") != IEvaluationContext.UNDEFINED_VARIABLE) {
            n |= 0x4000000;
        }
        if (!Util.equals(v3 = hashMap.get("activeEditor"), this.lastActiveEditor)) {
            n |= 0x10000;
            v3 = v3 == IEvaluationContext.UNDEFINED_VARIABLE ? null : v3;
            this.hookListener(this.lastActiveEditor, (IEditorPart)v3);
            this.lastActiveEditor = (IEditorPart)v3;
        }
        if (!Util.equals(v2 = hashMap.get("activeEditorInput"), this.lastEditorInput)) {
            n |= 0x10000;
            this.lastEditorInput = v2 != IEvaluationContext.UNDEFINED_VARIABLE ? (IEditorInput)v2 : null;
        }
        if (!Util.equals(v = hashMap.get("activeEditorId"), this.lastActiveEditorId)) {
            n |= 0x40000;
            this.lastActiveEditorId = v != IEvaluationContext.UNDEFINED_VARIABLE ? (String)v : null;
        }
        if (n != 0) {
            if (DEBUG) {
                if ((n & 0x100000) != 0) {
                    this.logDebuggingInfo("Active part changed to " + this.lastActivePart);
                }
                if ((n & 0x400000) != 0) {
                    this.logDebuggingInfo("Active part id changed to " + this.lastActivePartId);
                }
                if ((n & 0x4000000) != 0) {
                    this.logDebuggingInfo("Active site changed to " + this.lastActivePartSite);
                }
                if ((n & 0x10000) != 0) {
                    this.logDebuggingInfo("Active editor changed to " + this.lastActiveEditor);
                }
                if ((n & 0x40000) != 0) {
                    this.logDebuggingInfo("Active editor id changed to " + this.lastActiveEditorId);
                }
            }
            this.fireSourceChanged(n |= this.updateSelection(hashMap), hashMap);
        }
    }

    private IShowInSource getShowInSource(IWorkbenchPart iWorkbenchPart) {
        return (IShowInSource)Util.getAdapter(iWorkbenchPart, IShowInSource.class);
    }

    private ShowInContext getContext(IWorkbenchPart iWorkbenchPart) {
        IShowInSource iShowInSource = this.getShowInSource(iWorkbenchPart);
        if (iShowInSource != null) {
            ShowInContext showInContext = iShowInSource.getShowInContext();
            if (showInContext != null) {
                return showInContext;
            }
        } else if (iWorkbenchPart instanceof IEditorPart) {
            IEditorInput iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput();
            ISelectionProvider iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider();
            ISelection iSelection = iSelectionProvider == null ? null : iSelectionProvider.getSelection();
            return new ShowInContext(iEditorInput, iSelection);
        }
        return null;
    }

    private IWorkbenchWindow getActiveWindow() {
        int n;
        Shell shell = this.workbench.getDisplay().getActiveShell();
        IContextService iContextService = (IContextService)this.workbench.getService(IContextService.class);
        if (iContextService != null && (n = iContextService.getShellType(shell)) != 0) {
            return this.workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    private void updateActivePart(Map map) {
        this.updateActivePart(map, false);
    }

    private void updateActivePart(Map map, boolean bl) {
        IWorkbenchPage iWorkbenchPage;
        map.put("activeSite", IEvaluationContext.UNDEFINED_VARIABLE);
        map.put("activePart", IEvaluationContext.UNDEFINED_VARIABLE);
        map.put("activePartId", IEvaluationContext.UNDEFINED_VARIABLE);
        map.put("activeEditor", IEvaluationContext.UNDEFINED_VARIABLE);
        map.put("activeEditorId", IEvaluationContext.UNDEFINED_VARIABLE);
        map.put("showInInput", IEvaluationContext.UNDEFINED_VARIABLE);
        map.put("showInSelection", IEvaluationContext.UNDEFINED_VARIABLE);
        IWorkbenchWindow iWorkbenchWindow = this.getActiveWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            Object object;
            Object object2;
            IAdaptable iAdaptable;
            IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
            map.put("activePart", iWorkbenchPart);
            if (iWorkbenchPart != null) {
                iAdaptable = iWorkbenchPart.getSite();
                map.put("activeSite", iAdaptable);
                if (iAdaptable != null) {
                    object2 = iAdaptable.getId();
                    map.put("activePartId", object2);
                }
                if ((object2 = this.getContext(iWorkbenchPart)) != null) {
                    ISelection iSelection;
                    object = ((ShowInContext)object2).getInput();
                    if (object != null) {
                        map.put("showInInput", object);
                    }
                    if (bl && (iSelection = ((ShowInContext)object2).getSelection()) != null) {
                        map.put("showInSelection", iSelection);
                    }
                }
            }
            iAdaptable = iWorkbenchPage.getActiveEditor();
            map.put("activeEditor", iAdaptable);
            if (iAdaptable != null) {
                map.put("activeEditorInput", iAdaptable.getEditorInput());
                object2 = iAdaptable.getEditorSite();
                if (object2 != null) {
                    object = object2.getId();
                    map.put("activeEditorId", object);
                }
            }
        }
    }

    protected void checkOtherSources(Shell shell) {
        this.handleCheck(shell);
    }

    protected void handleInputChanged(IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (!Util.equals(iEditorInput, this.lastEditorInput)) {
            this.fireSourceChanged(65536, "activeEditorInput", iEditorInput == null ? IEvaluationContext.UNDEFINED_VARIABLE : iEditorInput);
            this.lastEditorInput = iEditorInput;
        }
    }

    private void hookListener(WorkbenchWindow workbenchWindow, WorkbenchWindow workbenchWindow2) {
        if (workbenchWindow != null) {
            workbenchWindow.removePropertyChangeListener(this.propertyListener);
            workbenchWindow.removePerspectiveListener(this.perspectiveListener);
        }
        if (workbenchWindow2 != null) {
            workbenchWindow2.addPropertyChangeListener(this.propertyListener);
            workbenchWindow2.addPerspectiveListener(this.perspectiveListener);
        }
    }

    private void hookListener(IEditorPart iEditorPart, IEditorPart iEditorPart2) {
        if (iEditorPart != null) {
            iEditorPart.removePropertyListener(this.editorListener);
        }
        if (iEditorPart2 != null) {
            iEditorPart2.addPropertyListener(this.editorListener);
        }
    }

    private void updateActiveShell(Map map) {
        IPerspectiveDescriptor iPerspectiveDescriptor;
        IWorkbenchPage iWorkbenchPage;
        Boolean bl;
        Boolean bl2;
        Shell shell = this.display.getActiveShell();
        map.put("activeShell", shell);
        IContextService iContextService = (IContextService)this.workbench.getService(IContextService.class);
        int n = iContextService.getShellType(shell);
        if (n == 0) {
            return;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.workbench.getActiveWorkbenchWindow();
        Shell shell2 = workbenchWindow == null ? null : workbenchWindow.getShell();
        map.put("activeWorkbenchWindow", workbenchWindow);
        map.put("activeWorkbenchWindowShell", shell2);
        Boolean bl3 = workbenchWindow == null ? this.lastCoolbarVisibility : (bl2 = workbenchWindow.getCoolBarVisible() ? Boolean.TRUE : Boolean.FALSE);
        Boolean bl4 = workbenchWindow == null ? this.lastPerspectiveBarVisibility : (bl = workbenchWindow.getPerspectiveBarVisible() ? Boolean.TRUE : Boolean.FALSE);
        Boolean bl5 = workbenchWindow == null ? this.lastStatusLineVisibility : (workbenchWindow.getStatusLineVisible() ? Boolean.TRUE : Boolean.FALSE);
        String string = this.lastPerspectiveId;
        if (workbenchWindow != null && (iWorkbenchPage = workbenchWindow.getActivePage()) != null && (iPerspectiveDescriptor = iWorkbenchPage.getPerspective()) != null) {
            string = iPerspectiveDescriptor.getId();
        }
        map.put("activeWorkbenchWindow.isCoolbarVisible", bl2);
        map.put("activeWorkbenchWindow.isPerspectiveBarVisible", bl);
        map.put(STATUS_LINE_VIS, bl5);
        map.put("activeWorkbenchWindow.activePerspective", string);
    }
}

