/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.SourcePriorityNameMapping;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class WorkbenchServiceRegistry
implements IExtensionChangeHandler {
    private static final String WORKBENCH_LEVEL = "workbench";
    private static final String EXT_ID_SERVICES = "org.eclipse.ui.services";
    private static WorkbenchServiceRegistry registry = null;
    public static final IServiceLocator GLOBAL_PARENT = new IServiceLocator(){

        @Override
        public Object getService(Class clazz) {
            return null;
        }

        @Override
        public boolean hasService(Class clazz) {
            return false;
        }
    };
    private Map factories = new HashMap();
    private static final String[] supportedLevels = new String[]{"activeContexts", "activeShell", "activeWorkbenchWindow", "activeEditorId", "activePartId", "activeSite"};

    public static WorkbenchServiceRegistry getRegistry() {
        if (registry == null) {
            registry = new WorkbenchServiceRegistry();
        }
        return registry;
    }

    private WorkbenchServiceRegistry() {
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPoint()));
    }

    public Object getService(Class clazz, IServiceLocator iServiceLocator, ServiceLocator serviceLocator) {
        Object object;
        ServiceFactoryHandle serviceFactoryHandle = (ServiceFactoryHandle)this.factories.get(clazz.getName());
        if (serviceFactoryHandle == null) {
            serviceFactoryHandle = this.loadFromRegistry(clazz);
        }
        if (serviceFactoryHandle != null && (object = serviceFactoryHandle.factory.create(clazz, iServiceLocator, serviceLocator)) != null) {
            serviceFactoryHandle.serviceLocators.put(serviceLocator, new Object());
            return object;
        }
        return null;
    }

    private ServiceFactoryHandle loadFromRegistry(Class clazz) {
        Object object = null;
        IConfigurationElement[] iConfigurationElementArray = this.getExtensionPoint().getConfigurationElements();
        try {
            String string = clazz.getName();
            boolean bl = false;
            int n = 0;
            while (n < iConfigurationElementArray.length && !bl) {
                Object object2;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren("service");
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length && !bl) {
                    object2 = iConfigurationElementArray2[n2].getAttribute("serviceClass");
                    if (string.equals(object2)) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    AbstractServiceFactory abstractServiceFactory = (AbstractServiceFactory)iConfigurationElementArray[n].createExecutableExtension("factoryClass");
                    object2 = new ServiceFactoryHandle(abstractServiceFactory);
                    PlatformUI.getWorkbench().getExtensionTracker().registerObject(iConfigurationElementArray[n].getDeclaringExtension(), object2, 2);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n3 = 0;
                    while (n3 < iConfigurationElementArray2.length) {
                        String string2 = iConfigurationElementArray2[n3].getAttribute("serviceClass");
                        if (this.factories.containsKey(string2)) {
                            WorkbenchPlugin.log("Factory already exists for " + string2);
                        } else {
                            this.factories.put(string2, object2);
                            arrayList.add(string2);
                        }
                        ++n3;
                    }
                    ((ServiceFactoryHandle)object2).serviceNames = arrayList.toArray(new String[arrayList.size()]);
                    object = object2;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            StatusManager.getManager().handle(coreException.getStatus());
        }
        return object;
    }

    private IExtensionPoint getExtensionPoint() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXT_ID_SERVICES);
        return iExtensionPoint;
    }

    public AbstractSourceProvider[] getSourceProviders() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IExtensionPoint iExtensionPoint = this.getExtensionPoint();
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals("sourceProvider")) {
                try {
                    Object object = iConfigurationElementArray[n].createExecutableExtension("provider");
                    if (!(object instanceof AbstractSourceProvider)) {
                        String string = iConfigurationElementArray[n].getAttribute("provider");
                        String string2 = "Source Provider '" + string + "' should extend AbstractSourceProvider";
                        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, string2);
                        WorkbenchPlugin.log((IStatus)status);
                    } else {
                        arrayList.add(object);
                    }
                }
                catch (CoreException coreException) {
                    StatusManager.getManager().handle(coreException.getStatus());
                }
            }
            ++n;
        }
        return arrayList.toArray(new AbstractSourceProvider[arrayList.size()]);
    }

    public void initializeSourcePriorities() {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint();
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals("sourceProvider")) {
                this.processVariables(iConfigurationElementArray[n].getChildren("variable"));
            }
            ++n;
        }
    }

    private void processVariables(IConfigurationElement[] iConfigurationElementArray) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("name");
            if (string != null && string.length() != 0) {
                int n2;
                int n3;
                String string2 = iConfigurationElementArray[n].getAttribute("priorityLevel");
                if (string2 == null || string2.length() == 0) {
                    string2 = WORKBENCH_LEVEL;
                } else {
                    n3 = 0;
                    n2 = 0;
                    while (n2 < supportedLevels.length && n3 == 0) {
                        if (supportedLevels[n2].equals(string2)) {
                            n3 = 1;
                        }
                        ++n2;
                    }
                    if (n3 == 0) {
                        string2 = WORKBENCH_LEVEL;
                    }
                }
                n3 = SourcePriorityNameMapping.getMapping(string2);
                n2 = n3 << 1;
                SourcePriorityNameMapping.addMapping(string, n2);
            }
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof ServiceFactoryHandle) {
                Object object2;
                ServiceFactoryHandle serviceFactoryHandle = (ServiceFactoryHandle)object;
                Set set = serviceFactoryHandle.serviceLocators.keySet();
                ServiceLocator[] serviceLocatorArray = set.toArray(new ServiceLocator[set.size()]);
                Arrays.sort(serviceLocatorArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n;
                        ServiceLocator serviceLocator = (ServiceLocator)object;
                        ServiceLocator serviceLocator2 = (ServiceLocator)object2;
                        int n2 = ((IWorkbenchLocationService)serviceLocator.getService(IWorkbenchLocationService.class)).getServiceLevel();
                        return n2 < (n = ((IWorkbenchLocationService)serviceLocator2.getService(IWorkbenchLocationService.class)).getServiceLevel()) ? -1 : (n2 > n ? 1 : 0);
                    }
                });
                int n2 = 0;
                while (n2 < serviceLocatorArray.length) {
                    object2 = serviceLocatorArray[n2];
                    if (!((ServiceLocator)object2).isDisposed()) {
                        ((ServiceLocator)object2).unregisterServices(serviceFactoryHandle.serviceNames);
                    }
                    ++n2;
                }
                serviceFactoryHandle.factory = null;
                n2 = 0;
                while (n2 < serviceFactoryHandle.serviceNames.length) {
                    object2 = serviceFactoryHandle.serviceNames[n2];
                    if (this.factories.get(object2) == serviceFactoryHandle) {
                        this.factories.remove(object2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    static class ServiceFactoryHandle {
        AbstractServiceFactory factory;
        WeakHashMap serviceLocators = new WeakHashMap();
        String[] serviceNames;

        ServiceFactoryHandle(AbstractServiceFactory abstractServiceFactory) {
            this.factory = abstractServiceFactory;
        }
    }
}

