/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.internal.services.WorkbenchServiceRegistry;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;

public final class SourceProviderService
implements ISourceProviderService,
IDisposable {
    private final Map sourceProvidersByName = new HashMap();
    private final Set sourceProviders = new HashSet();
    private IServiceLocator locator;

    public SourceProviderService(IServiceLocator iServiceLocator) {
        this.locator = iServiceLocator;
    }

    @Override
    public final void dispose() {
        for (ISourceProvider iSourceProvider : this.sourceProviders) {
            iSourceProvider.dispose();
        }
        this.sourceProviders.clear();
        this.sourceProvidersByName.clear();
    }

    @Override
    public final ISourceProvider getSourceProvider(String string) {
        return (ISourceProvider)this.sourceProvidersByName.get(string);
    }

    @Override
    public final ISourceProvider[] getSourceProviders() {
        return this.sourceProviders.toArray(new ISourceProvider[this.sourceProviders.size()]);
    }

    public final void registerProvider(ISourceProvider iSourceProvider) {
        if (iSourceProvider == null) {
            throw new NullPointerException("The source provider cannot be null");
        }
        String[] stringArray = iSourceProvider.getProvidedSourceNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.sourceProvidersByName.put(string, iSourceProvider);
            ++n;
        }
        this.sourceProviders.add(iSourceProvider);
    }

    public final void unregisterProvider(ISourceProvider iSourceProvider) {
        if (iSourceProvider == null) {
            throw new NullPointerException("The source provider cannot be null");
        }
        String[] stringArray = iSourceProvider.getProvidedSourceNames();
        int n = 0;
        while (n < stringArray.length) {
            this.sourceProvidersByName.remove(stringArray[n]);
            ++n;
        }
        this.sourceProviders.remove(iSourceProvider);
    }

    public final void readRegistry() {
        AbstractSourceProvider[] abstractSourceProviderArray = WorkbenchServiceRegistry.getRegistry().getSourceProviders();
        int n = 0;
        while (n < abstractSourceProviderArray.length) {
            abstractSourceProviderArray[n].initialize(this.locator);
            this.registerProvider(abstractSourceProviderArray[n]);
            ++n;
        }
    }
}

