/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.ui.ISources;

public final class SourcePriorityNameMapping
implements ISources {
    public static final String LEGACY_LEGACY_NAME = "LEGACY";
    public static final int NO_SOURCE_PRIORITY = 0;
    private static final Map sourcePrioritiesByName = new HashMap();

    static {
        SourcePriorityNameMapping.addMapping("activeActionSets", 256);
        SourcePriorityNameMapping.addMapping("activeContexts", 64);
        SourcePriorityNameMapping.addMapping("selection", 0x40000000);
        SourcePriorityNameMapping.addMapping("activeEditor", 65536);
        SourcePriorityNameMapping.addMapping("activeEditorInput", 65536);
        SourcePriorityNameMapping.addMapping("activeEditorId", 262144);
        SourcePriorityNameMapping.addMapping("activeMenu", Integer.MIN_VALUE);
        SourcePriorityNameMapping.addMapping("activeMenuSelection", Integer.MIN_VALUE);
        SourcePriorityNameMapping.addMapping("activeMenuEditorInput", Integer.MIN_VALUE);
        SourcePriorityNameMapping.addMapping("activeFocusControlId", Integer.MIN_VALUE);
        SourcePriorityNameMapping.addMapping("activeFocusControl", Integer.MIN_VALUE);
        SourcePriorityNameMapping.addMapping("activePart", 0x100000);
        SourcePriorityNameMapping.addMapping("activePartId", 0x400000);
        SourcePriorityNameMapping.addMapping("activeShell", 1024);
        SourcePriorityNameMapping.addMapping("activeSite", 0x4000000);
        SourcePriorityNameMapping.addMapping("activeWorkbenchWindow", 16384);
        SourcePriorityNameMapping.addMapping("activeWorkbenchWindowShell", 4096);
        SourcePriorityNameMapping.addMapping("activeWorkbenchWindow.isCoolbarVisible", 32768);
        SourcePriorityNameMapping.addMapping("activeWorkbenchWindow.activePerspective", 32768);
        SourcePriorityNameMapping.addMapping("activeWorkbenchWindow.isPerspectiveBarVisible", 32768);
        SourcePriorityNameMapping.addMapping(LEGACY_LEGACY_NAME, 1);
        SourcePriorityNameMapping.addMapping("workbench", 0);
    }

    public static final void addMapping(String string, int n) {
        if (string == null) {
            throw new NullPointerException("The source name cannot be null.");
        }
        if (!sourcePrioritiesByName.containsKey(string)) {
            Integer n2 = new Integer(n);
            sourcePrioritiesByName.put(string, n2);
        }
    }

    public static final int computeSourcePriority(Expression expression) {
        int n = 0;
        if (expression == null) {
            return n;
        }
        ExpressionInfo expressionInfo = expression.computeExpressionInfo();
        if (expressionInfo.hasDefaultVariableAccess()) {
            n |= 0x40000000;
        }
        String[] stringArray = expressionInfo.getAccessedVariableNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            n |= SourcePriorityNameMapping.getMapping(string);
            ++n2;
        }
        return n;
    }

    public static final int getMapping(String string) {
        Object v = sourcePrioritiesByName.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return 0;
    }

    private SourcePriorityNameMapping() {
    }
}

