/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public class SlaveEvaluationService
implements IEvaluationService {
    private IEvaluationService parentService;
    private Collection sourceProviders = new ArrayList();
    private Collection serviceListeners = new ArrayList();
    private Collection evaluationReferences = new ArrayList();

    public SlaveEvaluationService(IEvaluationService iEvaluationService) {
        this.parentService = iEvaluationService;
    }

    @Override
    public IEvaluationReference addEvaluationListener(Expression expression, IPropertyChangeListener iPropertyChangeListener, String string) {
        IEvaluationReference iEvaluationReference = this.parentService.addEvaluationListener(expression, iPropertyChangeListener, string);
        if (!this.evaluationReferences.contains(iEvaluationReference)) {
            this.evaluationReferences.add(iEvaluationReference);
        }
        return iEvaluationReference;
    }

    @Override
    public void addEvaluationReference(IEvaluationReference iEvaluationReference) {
        if (!this.evaluationReferences.contains(iEvaluationReference)) {
            this.evaluationReferences.add(iEvaluationReference);
        }
        this.parentService.addEvaluationReference(iEvaluationReference);
    }

    @Override
    public void addServiceListener(IPropertyChangeListener iPropertyChangeListener) {
        if (!this.serviceListeners.contains(iPropertyChangeListener)) {
            this.serviceListeners.add(iPropertyChangeListener);
        }
        this.parentService.addServiceListener(iPropertyChangeListener);
    }

    @Override
    public void addSourceProvider(ISourceProvider iSourceProvider) {
        if (!this.sourceProviders.contains(iSourceProvider)) {
            this.sourceProviders.add(iSourceProvider);
        }
        this.parentService.addSourceProvider(iSourceProvider);
    }

    @Override
    public IEvaluationContext getCurrentState() {
        return this.parentService.getCurrentState();
    }

    @Override
    public void removeEvaluationListener(IEvaluationReference iEvaluationReference) {
        this.evaluationReferences.remove(iEvaluationReference);
        this.parentService.removeEvaluationListener(iEvaluationReference);
    }

    @Override
    public void removeServiceListener(IPropertyChangeListener iPropertyChangeListener) {
        this.serviceListeners.remove(iPropertyChangeListener);
        this.parentService.removeServiceListener(iPropertyChangeListener);
    }

    @Override
    public void removeSourceProvider(ISourceProvider iSourceProvider) {
        this.sourceProviders.remove(iSourceProvider);
        this.parentService.removeSourceProvider(iSourceProvider);
    }

    @Override
    public void dispose() {
        int n;
        Object[] objectArray;
        if (!this.evaluationReferences.isEmpty()) {
            objectArray = this.evaluationReferences.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.parentService.removeEvaluationListener((IEvaluationReference)objectArray[n]);
                ++n;
            }
        }
        if (!this.serviceListeners.isEmpty()) {
            objectArray = this.serviceListeners.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.parentService.removeServiceListener((IPropertyChangeListener)objectArray[n]);
                ++n;
            }
            this.serviceListeners.clear();
        }
        if (!this.sourceProviders.isEmpty()) {
            objectArray = this.sourceProviders.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.parentService.removeSourceProvider((ISourceProvider)objectArray[n]);
                ++n;
            }
            this.sourceProviders.clear();
        }
    }

    @Override
    public void requestEvaluation(String string) {
        this.parentService.requestEvaluation(string);
    }
}

