/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.WorkbenchServiceRegistry;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public final class ServiceLocator
implements IDisposable,
INestable,
IServiceLocator {
    boolean activated = false;
    private AbstractServiceFactory factory;
    private IServiceLocator parent;
    private Map services = null;
    private boolean disposed;
    private final IDisposable owner;

    public ServiceLocator() {
        this(null, null, null);
    }

    public ServiceLocator(IServiceLocator iServiceLocator, AbstractServiceFactory abstractServiceFactory, IDisposable iDisposable) {
        this.parent = iServiceLocator;
        this.factory = abstractServiceFactory;
        this.owner = iDisposable;
    }

    @Override
    public final void activate() {
        this.activated = true;
        if (this.services != null) {
            for (Object v : this.services.values()) {
                if (!(v instanceof INestable)) continue;
                INestable iNestable = (INestable)v;
                iNestable.activate();
            }
        }
    }

    @Override
    public final void deactivate() {
        this.activated = false;
        if (this.services != null) {
            for (Object v : this.services.values()) {
                if (!(v instanceof INestable)) continue;
                INestable iNestable = (INestable)v;
                iNestable.deactivate();
            }
        }
    }

    @Override
    public final void dispose() {
        if (this.services != null) {
            for (Object v : this.services.values()) {
                if (!(v instanceof IDisposable)) continue;
                IDisposable iDisposable = (IDisposable)v;
                iDisposable.dispose();
            }
            this.services = null;
        }
        this.parent = null;
        this.disposed = true;
    }

    @Override
    public final Object getService(Class clazz) {
        if (this.disposed) {
            return null;
        }
        Object object = this.services != null ? (Object)this.services.get(clazz) : null;
        if (object == null) {
            IServiceLocator iServiceLocator = WorkbenchServiceRegistry.GLOBAL_PARENT;
            if (this.parent != null) {
                iServiceLocator = new ParentLocator(this.parent, clazz);
            }
            if (this.factory != null) {
                object = this.factory.create(clazz, iServiceLocator, this);
            }
            if (object == null) {
                object = WorkbenchServiceRegistry.getRegistry().getService(clazz, iServiceLocator, this);
            }
            if (object == null) {
                object = iServiceLocator.getService(clazz);
            } else {
                this.registerService(clazz, object);
            }
        }
        return object;
    }

    @Override
    public final boolean hasService(Class clazz) {
        if (this.disposed) {
            return false;
        }
        return this.services != null && this.services.containsKey(clazz);
    }

    public final void registerService(Class clazz, Object object) {
        Object v;
        if (clazz == null) {
            throw new NullPointerException("The service key cannot be null");
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("The service does not implement the given interface");
        }
        if (this.services == null) {
            this.services = new HashMap();
        }
        if (this.services.containsKey(clazz) && (v = this.services.remove(clazz)) instanceof IDisposable) {
            IDisposable iDisposable = (IDisposable)v;
            iDisposable.dispose();
        }
        if (object == null) {
            if (this.services.isEmpty()) {
                this.services = null;
            }
        } else {
            this.services.put(clazz, object);
            if (object instanceof INestable && this.activated) {
                ((INestable)object).activate();
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void unregisterServices(String[] stringArray) {
        if (this.owner != null) {
            this.owner.dispose();
        }
    }

    private static class ParentLocator
    implements IServiceLocator {
        private IServiceLocator locator;
        private Class key;

        public ParentLocator(IServiceLocator iServiceLocator, Class clazz) {
            this.locator = iServiceLocator;
            this.key = clazz;
        }

        @Override
        public Object getService(Class clazz) {
            if (this.key.equals(clazz)) {
                return this.locator.getService(this.key);
            }
            return null;
        }

        @Override
        public boolean hasService(Class clazz) {
            return this.key.equals(clazz);
        }
    }
}

