/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IWorkbenchRegistryConstants;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.services.IDisposable;

public abstract class RegistryPersistence
implements IDisposable,
IWorkbenchRegistryConstants {
    protected static final Expression ERROR_EXPRESSION = new Expression(){

        public final EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
            return null;
        }
    };
    private final IRegistryChangeListener registryChangeListener = new IRegistryChangeListener(){

        public final void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
            if (RegistryPersistence.this.isChangeImportant(iRegistryChangeEvent)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public final void run() {
                        RegistryPersistence.this.read();
                    }
                });
            }
        }
    };
    protected boolean registryListenerAttached = false;

    protected static final void addElementToIndexedArray(IConfigurationElement iConfigurationElement, IConfigurationElement[][] iConfigurationElementArray, int n, int n2) {
        IConfigurationElement[] iConfigurationElementArray2;
        if (n2 == 0) {
            iConfigurationElementArray2 = new IConfigurationElement[1];
            iConfigurationElementArray[n] = iConfigurationElementArray2;
        } else if (n2 >= iConfigurationElementArray[n].length) {
            IConfigurationElement[] iConfigurationElementArray3 = new IConfigurationElement[iConfigurationElementArray[n].length * 2];
            System.arraycopy(iConfigurationElementArray[n], 0, iConfigurationElementArray3, 0, n2);
            iConfigurationElementArray2 = iConfigurationElementArray3;
            iConfigurationElementArray[n] = iConfigurationElementArray2;
        } else {
            iConfigurationElementArray2 = iConfigurationElementArray[n];
        }
        iConfigurationElementArray2[n2] = iConfigurationElement;
    }

    protected static final void addWarning(List list, String string, IConfigurationElement iConfigurationElement) {
        RegistryPersistence.addWarning(list, string, iConfigurationElement, null, null, null);
    }

    protected static final void addWarning(List list, String string, IConfigurationElement iConfigurationElement, String string2) {
        RegistryPersistence.addWarning(list, string, iConfigurationElement, string2, null, null);
    }

    protected static final void addWarning(List list, String string, IConfigurationElement iConfigurationElement, String string2, String string3, String string4) {
        String string5 = string;
        if (iConfigurationElement != null) {
            string5 = String.valueOf(string5) + ": plug-in='" + iConfigurationElement.getNamespace() + '\'';
        }
        if (string2 != null) {
            string5 = iConfigurationElement != null ? String.valueOf(string5) + ',' : String.valueOf(string5) + ':';
            string5 = String.valueOf(string5) + " id='" + string2 + '\'';
        }
        if (string3 != null) {
            string5 = iConfigurationElement != null || string2 != null ? String.valueOf(string5) + ',' : String.valueOf(string5) + ':';
            string5 = String.valueOf(string5) + ' ' + string3 + "='" + string4 + '\'';
        }
        Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string5, null);
        list.add(status);
    }

    protected static final boolean checkClass(IConfigurationElement iConfigurationElement, List list, String string, String string2) {
        if (iConfigurationElement.getAttribute("class") == null && iConfigurationElement.getChildren("class").length == 0) {
            RegistryPersistence.addWarning(list, string, iConfigurationElement, string2);
            return false;
        }
        return true;
    }

    protected static final boolean isPulldown(IConfigurationElement iConfigurationElement) {
        String string = RegistryPersistence.readOptional(iConfigurationElement, "style");
        boolean bl = RegistryPersistence.readBoolean(iConfigurationElement, "pulldown", false);
        return bl || "pulldown".equals(string);
    }

    protected static final void logWarnings(List list, String string) {
        if (list != null && !list.isEmpty()) {
            MultiStatus multiStatus = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, list.toArray(new IStatus[list.size()]), string, null);
            WorkbenchPlugin.log((IStatus)multiStatus);
        }
    }

    protected static final boolean readBoolean(IConfigurationElement iConfigurationElement, String string, boolean bl) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null) {
            return bl;
        }
        if (bl) {
            return !string2.equalsIgnoreCase("false");
        }
        return string2.equalsIgnoreCase("true");
    }

    protected static final String readOptional(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    protected static final ParameterizedCommand readParameterizedCommand(IConfigurationElement iConfigurationElement, ICommandService iCommandService, List list, String string, String string2) {
        String string3 = RegistryPersistence.readRequired(iConfigurationElement, "commandId", list, string, string2);
        if (string3 == null) {
            return null;
        }
        Command command = iCommandService.getCommand(string3);
        ParameterizedCommand parameterizedCommand = RegistryPersistence.readParameters(iConfigurationElement, list, command);
        return parameterizedCommand;
    }

    protected static final ParameterizedCommand readParameters(IConfigurationElement iConfigurationElement, List list, Command command) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("parameter");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return new ParameterizedCommand(command, null);
        }
        ArrayList<Parameterization> arrayList = new ArrayList<Parameterization>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            String string = iConfigurationElement2.getAttribute("id");
            if (string == null || string.length() == 0) {
                RegistryPersistence.addWarning(list, "Parameters need a name", iConfigurationElement);
            } else {
                Object object;
                Object object2;
                block13: {
                    object2 = null;
                    try {
                        object = command.getParameters();
                        if (arrayList == null) break block13;
                        int n2 = 0;
                        while (n2 < ((IParameter[])object).length) {
                            Object object3 = object[n2];
                            if (Util.equals(object3.getId(), string)) {
                                object2 = object3;
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                if (object2 == null) {
                    RegistryPersistence.addWarning(list, "Could not find a matching parameter", iConfigurationElement, string);
                } else {
                    object = iConfigurationElement2.getAttribute("value");
                    if (object == null || ((String)object).length() == 0) {
                        RegistryPersistence.addWarning(list, "Parameters need a value", iConfigurationElement, string);
                    } else {
                        arrayList.add(new Parameterization(object2, (String)object));
                    }
                }
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return new ParameterizedCommand(command, null);
        }
        return new ParameterizedCommand(command, arrayList.toArray(new Parameterization[arrayList.size()]));
    }

    protected static final String readRequired(IConfigurationElement iConfigurationElement, String string, List list, String string2) {
        return RegistryPersistence.readRequired(iConfigurationElement, string, list, string2, null);
    }

    protected static final String readRequired(IConfigurationElement iConfigurationElement, String string, List list, String string2, String string3) {
        String string4 = iConfigurationElement.getAttribute(string);
        if (string4 == null || string4.length() == 0) {
            RegistryPersistence.addWarning(list, string2, iConfigurationElement, string3);
            return null;
        }
        return string4;
    }

    protected static final Expression readWhenElement(IConfigurationElement iConfigurationElement, String string, String string2, List list) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(string);
        Expression expression = null;
        if (iConfigurationElementArray.length > 0) {
            if (iConfigurationElementArray.length > 1) {
                RegistryPersistence.addWarning(list, "There should only be one when element", iConfigurationElement, string2, "whenElementName", string);
                return ERROR_EXPRESSION;
            }
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[0];
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement2.getChildren();
            if (iConfigurationElementArray2.length > 0) {
                if (iConfigurationElementArray2.length > 1) {
                    RegistryPersistence.addWarning(list, "There should only be one expression element", iConfigurationElement, string2, "whenElementName", string);
                    return ERROR_EXPRESSION;
                }
                ElementHandler elementHandler = ElementHandler.getDefault();
                ExpressionConverter expressionConverter = ExpressionConverter.getDefault();
                IConfigurationElement iConfigurationElement3 = iConfigurationElementArray2[0];
                try {
                    expression = elementHandler.create(expressionConverter, iConfigurationElement3);
                }
                catch (CoreException coreException) {
                    RegistryPersistence.addWarning(list, "Problem creating when element", iConfigurationElement, string2, "whenElementName", string);
                    return ERROR_EXPRESSION;
                }
            }
        }
        return expression;
    }

    protected RegistryPersistence() {
    }

    @Override
    public void dispose() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        iExtensionRegistry.removeRegistryChangeListener(this.registryChangeListener);
        this.registryListenerAttached = false;
    }

    protected abstract boolean isChangeImportant(IRegistryChangeEvent var1);

    protected void read() {
        if (!this.registryListenerAttached) {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            iExtensionRegistry.addRegistryChangeListener(this.registryChangeListener);
            this.registryListenerAttached = true;
        }
    }
}

