/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.internal.util.Util;

public abstract class PreferencePersistence
extends RegistryPersistence {
    protected boolean preferenceListenerAttached = false;
    private final IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (PreferencePersistence.this.isChangeImportant(propertyChangeEvent)) {
                PreferencePersistence.this.read();
            }
        }
    };

    protected static final void addElementToIndexedArray(IMemento iMemento, IMemento[][] iMementoArray, int n, int n2) {
        IMemento[] iMementoArray2;
        if (n2 == 0) {
            iMementoArray2 = new IMemento[1];
            iMementoArray[n] = iMementoArray2;
        } else if (n2 >= iMementoArray[n].length) {
            IMemento[] iMementoArray3 = new IMemento[iMementoArray[n].length * 2];
            System.arraycopy(iMementoArray[n], 0, iMementoArray3, 0, n2);
            iMementoArray2 = iMementoArray3;
            iMementoArray[n] = iMementoArray2;
        } else {
            iMementoArray2 = iMementoArray[n];
        }
        iMementoArray2[n2] = iMemento;
    }

    protected static final void addWarning(List list, String string) {
        PreferencePersistence.addWarning(list, string, null, null, null);
    }

    protected static final void addWarning(List list, String string, String string2) {
        PreferencePersistence.addWarning(list, string, string2, null, null);
    }

    protected static final void addWarning(List list, String string, String string2, String string3, String string4) {
        String string5 = string;
        if (string2 != null) {
            string5 = String.valueOf(string5) + ": id='" + string2 + '\'';
        }
        if (string3 != null) {
            string5 = string2 != null ? String.valueOf(string5) + ',' : String.valueOf(string5) + ':';
            string5 = String.valueOf(string5) + ' ' + string3 + "='" + string4 + '\'';
        }
        Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string5, null);
        list.add(status);
    }

    protected static final boolean readBoolean(IMemento iMemento, String string, boolean bl) {
        String string2 = iMemento.getString(string);
        if (string2 == null) {
            return bl;
        }
        if (bl) {
            return !string2.equalsIgnoreCase("false");
        }
        return !string2.equalsIgnoreCase("true");
    }

    protected static final String readOptional(IMemento iMemento, String string) {
        String string2 = iMemento.getString(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    protected static final ParameterizedCommand readParameterizedCommand(IMemento iMemento, ICommandService iCommandService, List list, String string, String string2) {
        String string3 = PreferencePersistence.readRequired(iMemento, "commandId", list, string, string2);
        if (string3 == null) {
            return null;
        }
        Command command = iCommandService.getCommand(string3);
        ParameterizedCommand parameterizedCommand = PreferencePersistence.readParameters(iMemento, list, command);
        return parameterizedCommand;
    }

    protected static final ParameterizedCommand readParameters(IMemento iMemento, List list, Command command) {
        IMemento[] iMementoArray = iMemento.getChildren("parameter");
        if (iMementoArray == null || iMementoArray.length == 0) {
            return new ParameterizedCommand(command, null);
        }
        ArrayList<Parameterization> arrayList = new ArrayList<Parameterization>();
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento2 = iMementoArray[n];
            String string = iMemento2.getString("id");
            if (string == null || string.length() == 0) {
                PreferencePersistence.addWarning(list, "Parameters need a name");
            } else {
                Object object;
                Object object2;
                block13: {
                    object2 = null;
                    try {
                        object = command.getParameters();
                        if (arrayList == null) break block13;
                        int n2 = 0;
                        while (n2 < ((IParameter[])object).length) {
                            Object object3 = object[n2];
                            if (Util.equals(object3.getId(), string)) {
                                object2 = object3;
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                if (object2 == null) {
                    PreferencePersistence.addWarning(list, "Could not find a matching parameter", string);
                } else {
                    object = iMemento2.getString("value");
                    if (object == null || ((String)object).length() == 0) {
                        PreferencePersistence.addWarning(list, "Parameters need a value", string);
                    } else {
                        arrayList.add(new Parameterization(object2, (String)object));
                    }
                }
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return new ParameterizedCommand(command, null);
        }
        return new ParameterizedCommand(command, arrayList.toArray(new Parameterization[arrayList.size()]));
    }

    protected static final String readRequired(IMemento iMemento, String string, List list, String string2) {
        return PreferencePersistence.readRequired(iMemento, string, list, string2, null);
    }

    protected static final String readRequired(IMemento iMemento, String string, List list, String string2, String string3) {
        String string4 = iMemento.getString(string);
        if (string4 == null || string4.length() == 0) {
            PreferencePersistence.addWarning(list, string2, string3);
            return null;
        }
        return string4;
    }

    @Override
    public final void dispose() {
        super.dispose();
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.removePropertyChangeListener(this.preferenceChangeListener);
    }

    protected abstract boolean isChangeImportant(PropertyChangeEvent var1);

    @Override
    protected void read() {
        super.read();
        if (!this.preferenceListenerAttached) {
            IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.addPropertyChangeListener(this.preferenceChangeListener);
        }
    }

    protected PreferencePersistence() {
    }
}

