/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.AbstractSourceProvider;

public final class MenuSourceProvider
extends AbstractSourceProvider {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeMenu", "activeMenuSelection", "activeMenuEditorInput"};
    private Set menuIds = new HashSet();
    private ISelection selection = null;
    private ISelection input = null;

    public final void addShowingMenus(Set set, ISelection iSelection, ISelection iSelection2) {
        this.menuIds.addAll(set);
        if (DEBUG) {
            this.logDebuggingInfo("Menu ids changed to " + this.menuIds);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("activeMenu", this.menuIds);
        if (this.selection != iSelection) {
            this.selection = iSelection;
            hashMap.put("activeMenuSelection", this.selection == null ? IEvaluationContext.UNDEFINED_VARIABLE : this.selection);
        }
        if (this.input != iSelection2) {
            this.input = iSelection2;
            hashMap.put("activeMenuEditorInput", this.input == null ? IEvaluationContext.UNDEFINED_VARIABLE : this.input);
        }
        this.fireSourceChanged(Integer.MIN_VALUE, hashMap);
    }

    @Override
    public final void dispose() {
        this.menuIds.clear();
        this.selection = null;
        this.input = null;
    }

    @Override
    public final Map getCurrentState() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("activeMenu", this.menuIds);
        hashMap.put("activeMenuSelection", this.selection == null ? IEvaluationContext.UNDEFINED_VARIABLE : this.selection);
        hashMap.put("activeMenuEditorInput", this.input == null ? IEvaluationContext.UNDEFINED_VARIABLE : this.input);
        return hashMap;
    }

    @Override
    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    public final void removeShowingMenus(Set set, ISelection iSelection, ISelection iSelection2) {
        this.menuIds.removeAll(set);
        if (DEBUG) {
            this.logDebuggingInfo("Menu ids changed to " + this.menuIds);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("activeMenu", this.menuIds);
        if (this.selection != iSelection) {
            this.selection = iSelection;
            hashMap.put("activeMenuSelection", this.selection == null ? IEvaluationContext.UNDEFINED_VARIABLE : this.selection);
        }
        if (this.input != iSelection2) {
            this.input = iSelection2;
            hashMap.put("activeMenuEditorInput", this.input == null ? IEvaluationContext.UNDEFINED_VARIABLE : this.input);
        }
        this.fireSourceChanged(Integer.MIN_VALUE, hashMap);
    }
}

