/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.internal.services.IEvaluationResultCache;

public abstract class ExpressionAuthority
implements ISourceProviderListener {
    private final IEvaluationContext context;
    private IEvaluationContext currentState = null;
    private final Collection providers = new ArrayList();

    protected ExpressionAuthority() {
        this.context = new EvaluationContext(null, (Object)this);
        this.context.setAllowPluginActivation(true);
        this.context.addVariable("org.eclipse.core.runtime.Platform", Platform.class);
    }

    public final void addSourceProvider(ISourceProvider iSourceProvider) {
        iSourceProvider.addSourceProviderListener(this);
        this.providers.add(iSourceProvider);
        Map map = iSourceProvider.getCurrentState();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (string == null || "activeWorkbenchWindowShell".equals(string)) continue;
            this.changeVariable(string, v);
        }
        this.sourceChanged(0, map);
    }

    public void dispose() {
        for (ISourceProvider iSourceProvider : this.providers) {
            iSourceProvider.removeSourceProviderListener(this);
        }
        this.providers.clear();
    }

    protected final boolean evaluate(Collection collection) {
        for (IEvaluationResultCache iEvaluationResultCache : collection) {
            if (!this.evaluate(iEvaluationResultCache)) continue;
            return true;
        }
        return false;
    }

    protected final boolean evaluate(IEvaluationResultCache iEvaluationResultCache) {
        IEvaluationContext iEvaluationContext = this.getCurrentState();
        return iEvaluationResultCache.evaluate(iEvaluationContext);
    }

    public final IEvaluationContext getCurrentState() {
        if (this.currentState == null) {
            EvaluationContext evaluationContext;
            Object object = this.context.getVariable("selection");
            if (object instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
                evaluationContext = new EvaluationContext(this.context, (Object)iStructuredSelection.toList());
            } else {
                evaluationContext = object instanceof ISelection && !((ISelection)object).isEmpty() ? new EvaluationContext(this.context, Collections.singleton(object)) : new EvaluationContext(this.context, (Object)Collections.EMPTY_LIST);
            }
            this.currentState = evaluationContext;
        }
        return this.currentState;
    }

    protected final Object getVariable(String string) {
        return this.context.getVariable(string);
    }

    public final void removeSourceProvider(ISourceProvider iSourceProvider) {
        iSourceProvider.removeSourceProviderListener(this);
        this.providers.remove(iSourceProvider);
        Map map = iSourceProvider.getCurrentState();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            this.changeVariable(string, null);
        }
    }

    protected final void changeVariable(String string, Object object) {
        if (object == null) {
            this.context.removeVariable(string);
        } else {
            this.context.addVariable(string, object);
        }
    }

    protected abstract void sourceChanged(int var1);

    protected void sourceChanged(String[] stringArray) {
    }

    @Override
    public final void sourceChanged(int n, Map map) {
        if (map.containsKey("selection")) {
            this.currentState = null;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            this.updateEvaluationContext(string, v);
        }
        this.sourceChanged(n, map.keySet().toArray(new String[0]));
    }

    @Override
    public final void sourceChanged(int n, String string, Object object) {
        if ("selection".equals(string)) {
            this.currentState = null;
        }
        this.updateEvaluationContext(string, object);
        this.sourceChanged(n, new String[]{string});
    }

    private void sourceChanged(int n, String[] stringArray) {
        this.sourceChanged(n);
        this.sourceChanged(stringArray);
    }

    protected final void updateCurrentState() {
        for (ISourceProvider iSourceProvider : this.providers) {
            Map map = iSourceProvider.getCurrentState();
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (string == null || "activeWorkbenchWindowShell".equals(string)) continue;
                this.changeVariable(string, v);
            }
        }
    }

    protected void updateEvaluationContext(String string, Object object) {
        if (string != null) {
            this.changeVariable(string, object);
        }
    }
}

