/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.internal.services.EvaluationAuthority;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public final class EvaluationService
implements IEvaluationService {
    private EvaluationAuthority evaluationAuthority = new EvaluationAuthority();

    @Override
    public IEvaluationReference addEvaluationListener(Expression expression, IPropertyChangeListener iPropertyChangeListener, String string) {
        EvaluationReference evaluationReference = new EvaluationReference(expression, iPropertyChangeListener, string);
        this.evaluationAuthority.addEvaluationListener(evaluationReference);
        return evaluationReference;
    }

    @Override
    public void addEvaluationReference(IEvaluationReference iEvaluationReference) {
        Assert.isLegal((boolean)(iEvaluationReference instanceof EvaluationReference), (String)("Invalid type: " + iEvaluationReference.getClass().getName()));
        this.evaluationAuthority.addEvaluationListener(iEvaluationReference);
    }

    @Override
    public void removeEvaluationListener(IEvaluationReference iEvaluationReference) {
        this.evaluationAuthority.removeEvaluationListener(iEvaluationReference);
    }

    @Override
    public void addSourceProvider(ISourceProvider iSourceProvider) {
        this.evaluationAuthority.addSourceProvider(iSourceProvider);
    }

    @Override
    public void removeSourceProvider(ISourceProvider iSourceProvider) {
        this.evaluationAuthority.removeSourceProvider(iSourceProvider);
    }

    @Override
    public void dispose() {
        this.evaluationAuthority.dispose();
    }

    @Override
    public IEvaluationContext getCurrentState() {
        return this.evaluationAuthority.getCurrentState();
    }

    @Override
    public void addServiceListener(IPropertyChangeListener iPropertyChangeListener) {
        this.evaluationAuthority.addServiceListener(iPropertyChangeListener);
    }

    @Override
    public void removeServiceListener(IPropertyChangeListener iPropertyChangeListener) {
        this.evaluationAuthority.removeServiceListener(iPropertyChangeListener);
    }

    @Override
    public void requestEvaluation(String string) {
        this.evaluationAuthority.sourceChanged(new String[]{string});
    }

    public void updateShellKludge() {
        this.evaluationAuthority.updateShellKludge();
    }

    public final void updateShellKludge(Shell shell) {
        Shell shell2 = this.evaluationAuthority.getActiveShell();
        if (shell2 != shell) {
            this.evaluationAuthority.sourceChanged(1024, "activeShell", shell);
        }
    }
}

