/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.internal.services.ExpressionAuthority;
import org.eclipse.ui.services.IEvaluationReference;

public class EvaluationAuthority
extends ExpressionAuthority {
    private static final String COMPONENT = "EVALUATION";
    private final Map cachesBySourceName = new HashMap();
    private ListenerList serviceListeners = new ListenerList();
    private int notifying = 0;

    public void addEvaluationListener(IEvaluationReference iEvaluationReference) {
        String[] stringArray = this.getNames(iEvaluationReference);
        int n = 0;
        while (n < stringArray.length) {
            Expression expression;
            HashSet<IEvaluationReference> hashSet;
            HashMap<Expression, HashSet<IEvaluationReference>> hashMap = (HashMap<Expression, HashSet<IEvaluationReference>>)this.cachesBySourceName.get(stringArray[n]);
            if (hashMap == null) {
                hashMap = new HashMap<Expression, HashSet<IEvaluationReference>>(1);
                this.cachesBySourceName.put(stringArray[n], hashMap);
            }
            if ((hashSet = (HashSet<IEvaluationReference>)hashMap.get(expression = iEvaluationReference.getExpression())) == null) {
                hashSet = new HashSet<IEvaluationReference>();
                hashMap.put(expression, hashSet);
            }
            hashSet.add(iEvaluationReference);
            ++n;
        }
        n = this.evaluate(iEvaluationReference) ? 1 : 0;
        this.firePropertyChange(iEvaluationReference, null, this.valueOf(n != 0));
    }

    private Boolean valueOf(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private String[] getNames(IEvaluationReference iEvaluationReference) {
        ExpressionInfo expressionInfo = new ExpressionInfo();
        iEvaluationReference.getExpression().collectExpressionInfo(expressionInfo);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(expressionInfo.getAccessedVariableNames()));
        if (expressionInfo.hasDefaultVariableAccess()) {
            arrayList.add("selection");
        }
        arrayList.addAll(Arrays.asList(expressionInfo.getAccessedPropertyNames()));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected void sourceChanged(int n) {
    }

    @Override
    protected void sourceChanged(String[] stringArray) {
        this.startSourceChange(stringArray);
        try {
            int n = 0;
            while (n < stringArray.length) {
                HashMap hashMap = (HashMap)this.cachesBySourceName.get(stringArray[n]);
                if (hashMap != null) {
                    Collection collection = hashMap.values();
                    Set[] setArray = collection.toArray(new Set[collection.size()]);
                    int n2 = 0;
                    while (n2 < setArray.length) {
                        if (setArray[n2].size() > 0) {
                            EvaluationReference[] evaluationReferenceArray = setArray[n2].toArray(new EvaluationReference[setArray[n2].size()]);
                            this.refsWithSameExpression(evaluationReferenceArray);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        finally {
            this.endSourceChange(stringArray);
        }
    }

    private void refsWithSameExpression(EvaluationReference[] evaluationReferenceArray) {
        int n = 0;
        while (n < evaluationReferenceArray.length && !evaluationReferenceArray[n].isPostingChanges()) {
            ++n;
        }
        if (n >= evaluationReferenceArray.length) {
            return;
        }
        EvaluationReference evaluationReference = evaluationReferenceArray[n];
        boolean bl = this.evaluate(evaluationReference);
        evaluationReference.clearResult();
        boolean bl2 = this.evaluate(evaluationReference);
        if (bl != bl2) {
            this.firePropertyChange(evaluationReference, this.valueOf(bl), this.valueOf(bl2));
        }
        ++n;
        while (n < evaluationReferenceArray.length) {
            evaluationReference = evaluationReferenceArray[n];
            if (evaluationReference.isPostingChanges() && (bl = this.evaluate(evaluationReference)) != bl2) {
                evaluationReference.setResult(bl2);
                this.firePropertyChange(evaluationReference, this.valueOf(bl), this.valueOf(bl2));
            }
            ++n;
        }
    }

    private void startSourceChange(String[] stringArray) {
        if (Policy.DEBUG_SOURCES) {
            Tracing.printTrace((String)COMPONENT, (String)("start source changed: " + Arrays.asList(stringArray)));
        }
        ++this.notifying;
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private void endSourceChange(String[] stringArray) {
        if (Policy.DEBUG_SOURCES) {
            Tracing.printTrace((String)COMPONENT, (String)("end source changed: " + Arrays.asList(stringArray)));
        }
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.TRUE, Boolean.FALSE);
        }
        --this.notifying;
    }

    public void removeEvaluationListener(IEvaluationReference iEvaluationReference) {
        String[] stringArray = this.getNames(iEvaluationReference);
        int n = 0;
        while (n < stringArray.length) {
            HashMap hashMap = (HashMap)this.cachesBySourceName.get(stringArray[n]);
            if (hashMap != null) {
                Set set = (Set)hashMap.get(iEvaluationReference.getExpression());
                if (set != null) {
                    set.remove(iEvaluationReference);
                    if (set.isEmpty()) {
                        hashMap.remove(iEvaluationReference.getExpression());
                    }
                }
                if (hashMap.isEmpty()) {
                    this.cachesBySourceName.remove(stringArray[n]);
                }
            }
            ++n;
        }
        n = this.evaluate(iEvaluationReference) ? 1 : 0;
        this.firePropertyChange(iEvaluationReference, this.valueOf(n != 0), null);
    }

    private void firePropertyChange(IEvaluationReference iEvaluationReference, Object object, Object object2) {
        iEvaluationReference.getListener().propertyChange(new PropertyChangeEvent((Object)iEvaluationReference, iEvaluationReference.getProperty(), object, object2));
    }

    private void fireServiceChange(final String string, final Object object, final Object object2) {
        Object[] objectArray = this.serviceListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    WorkbenchPlugin.log(throwable);
                }

                public void run() throws Exception {
                    iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)EvaluationAuthority.this, string, object, object2));
                }
            });
            ++n;
        }
    }

    public void addServiceListener(IPropertyChangeListener iPropertyChangeListener) {
        this.serviceListeners.add((Object)iPropertyChangeListener);
    }

    public void removeServiceListener(IPropertyChangeListener iPropertyChangeListener) {
        this.serviceListeners.remove((Object)iPropertyChangeListener);
    }

    final void updateShellKludge() {
        this.updateCurrentState();
        this.sourceChanged(new String[]{"activeShell"});
    }

    final Shell getActiveShell() {
        return (Shell)this.getVariable("activeShell");
    }
}

