/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.internal.ActionSetsEvent;
import org.eclipse.ui.internal.menus.IActionSetsListener;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.util.Util;

public final class ActionSetSourceProvider
extends AbstractSourceProvider
implements IActionSetsListener {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeActionSets"};
    private IActionSetDescriptor[] activeActionSets;

    @Override
    public final void actionSetsChanged(ActionSetsEvent actionSetsEvent) {
        Object[] objectArray = actionSetsEvent.getNewActionSets();
        if (!Util.equals(objectArray, this.activeActionSets)) {
            if (DEBUG) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Action sets changed to [");
                if (objectArray != null) {
                    int n = 0;
                    while (n < objectArray.length) {
                        stringBuffer.append(objectArray[n].getLabel());
                        if (n < objectArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
                stringBuffer.append(']');
                this.logDebuggingInfo(stringBuffer.toString());
            }
            this.activeActionSets = objectArray;
            this.fireSourceChanged(256, "activeActionSets", this.activeActionSets);
        }
    }

    @Override
    public final void dispose() {
        this.activeActionSets = null;
    }

    @Override
    public final Map getCurrentState() {
        HashMap<String, IActionSetDescriptor[]> hashMap = new HashMap<String, IActionSetDescriptor[]>();
        hashMap.put("activeActionSets", this.activeActionSets);
        return hashMap;
    }

    @Override
    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }
}

